/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class AddRepositoryLocationDialog
extends DialogWrapper {
    private final List<String> myPreviousLocations;
    private JComboBox myCombo;
    private String mySelected;
    private JTextField myComboField;

    public AddRepositoryLocationDialog(Project project, List<String> values) {
        super(project, true);
        this.myPreviousLocations = new ArrayList<String>(values);
        Collections.sort(this.myPreviousLocations);
        this.setTitle(this.getTitle());
        this.init();
        this.myComboField.setText(this.initText());
    }

    public String getTitle() {
        return SvnBundle.message("repository.browser.add.location.title", new Object[0]);
    }

    protected String initText() {
        return "http://";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCombo;
    }

    protected JComponent createCenterPanel() {
        JLabel selectText = new JLabel(SvnBundle.message("repository.browser.add.location.prompt", new Object[0]));
        selectText.setUI((LabelUI)new MultiLineLabelUI());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        mainPanel.add((Component)selectText, gb);
        ++gb.gridy;
        this.myCombo = new JComboBox<Object>(ArrayUtil.toObjectArray(this.myPreviousLocations));
        this.myCombo.setEditable(true);
        this.myCombo.setMinimumSize(new Dimension(250, 20));
        gb.fill = 2;
        mainPanel.add((Component)this.myCombo, gb);
        gb.fill = 0;
        this.myComboField = (JTextField)this.myCombo.getEditor().getEditorComponent();
        this.myComboField.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                AddRepositoryLocationDialog.this.validateMe();
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
                AddRepositoryLocationDialog.this.validateMe();
            }
        });
        this.myComboField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                AddRepositoryLocationDialog.this.validateMe();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                AddRepositoryLocationDialog.this.validateMe();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AddRepositoryLocationDialog.this.validateMe();
            }
        });
        this.myCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRepositoryLocationDialog.this.validateMe();
            }
        });
        this.validateMe();
        JPanel wrapper = new JPanel(new GridBagLayout());
        wrapper.add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        wrapper.setPreferredSize(new Dimension(400, 70));
        return wrapper;
    }

    private void validateMe() {
        String inputString = this.myComboField.getText();
        this.setOKActionEnabled(this.urlValid(inputString));
    }

    private boolean urlValid(String inputString) {
        if (inputString == null) {
            return false;
        }
        try {
            SVNURL svnurl = SVNURL.parseURIDecoded((String)inputString.trim());
            return svnurl != null;
        }
        catch (SVNException sVNException) {
            return false;
        }
    }

    protected void doOKAction() {
        this.mySelected = this.myComboField.getText().trim();
        super.doOKAction();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    public String getSelected() {
        return this.mySelected;
    }
}

