/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.delete;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkin.CmdCheckinClient;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.delete.DeleteClient;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdDeleteClient
extends BaseSvnClient
implements DeleteClient {
    @Override
    public void delete(@NotNull File path, boolean force, boolean dryRun, @Nullable ProgressTracker handler) throws VcsException {
        if (!dryRun) {
            ArrayList<String> parameters = new ArrayList<String>();
            CommandUtil.put(parameters, path);
            CommandUtil.put(parameters, force, "--force");
            File workingDirectory = CommandUtil.getHomeDirectory();
            BaseUpdateCommandListener listener = new BaseUpdateCommandListener(workingDirectory, handler);
            this.execute(this.myVcs, SvnTarget.fromFile((File)path), workingDirectory, SvnCommandName.delete, parameters, listener);
            listener.throwWrappedIfException();
        }
    }

    @Override
    public long delete(@NotNull SVNURL url, @NotNull String message) throws VcsException {
        SvnTarget target = SvnTarget.fromURL((SVNURL)url);
        ArrayList parameters = ContainerUtil.newArrayList();
        CommandUtil.put((List<String>)parameters, target);
        parameters.add("--message");
        parameters.add(message);
        CmdCheckinClient.CommandListener listener = new CmdCheckinClient.CommandListener(null);
        this.execute(this.myVcs, target, SvnCommandName.delete, parameters, (LineCommandListener)listener);
        return listener.getCommittedRevision();
    }
}

