/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.checkin.CheckinClient;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;

public class SvnKitCheckinClient
extends BaseSvnClient
implements CheckinClient {
    private static final Logger LOG = Logger.getInstance(SvnKitCheckinClient.class);

    @Override
    @NotNull
    public CommitInfo[] commit(@NotNull List<File> paths, @NotNull String comment) throws VcsException {
        SVNCommitInfo[] results;
        File[] pathsToCommit = (File[])ArrayUtil.toObjectArray(paths, File.class);
        boolean keepLocks = this.myVcs.getSvnConfiguration().isKeepLocks();
        SVNCommitPacket[] commitPackets = null;
        SVNCommitClient committer = this.myVcs.getSvnKitManager().createCommitClient();
        IdeaCommitHandler handler = new IdeaCommitHandler(ProgressManager.getInstance().getProgressIndicator(), true, true);
        committer.setEventHandler(SvnKitCheckinClient.toEventHandler(handler));
        try {
            commitPackets = committer.doCollectCommitItems(pathsToCommit, keepLocks, true, SVNDepth.EMPTY, true, null);
            results = committer.doCommit(commitPackets, keepLocks, comment);
            commitPackets = null;
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        finally {
            if (commitPackets != null) {
                for (SVNCommitPacket commitPacket : commitPackets) {
                    try {
                        commitPacket.dispose();
                    }
                    catch (SVNException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }
        for (VirtualFile f : handler.getDeletedFiles()) {
            f.putUserData(VirtualFile.REQUESTOR_MARKER, (Object)this);
        }
        return SvnKitCheckinClient.convert(results);
    }

    @NotNull
    private static CommitInfo[] convert(@NotNull SVNCommitInfo[] infos) {
        return (CommitInfo[])ContainerUtil.map((Object[])infos, (Function)new Function<SVNCommitInfo, CommitInfo>(){

            public CommitInfo fun(SVNCommitInfo info) {
                return new CommitInfo.Builder(info.getNewRevision(), info.getDate(), info.getAuthor()).setError(info.getErrorMessage()).build();
            }
        }, (Object[])new CommitInfo[0]);
    }
}

