/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.checkin.CheckinClient;
import org.jetbrains.idea.svn.checkin.CommitEventHandler;
import org.jetbrains.idea.svn.checkin.CommitEventType;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdCheckinClient
extends BaseSvnClient
implements CheckinClient {
    private static final Logger LOG = Logger.getInstance(CmdCheckinClient.class);
    public static final long INVALID_REVISION_NUMBER = -1L;

    @Override
    @NotNull
    public CommitInfo[] commit(@NotNull List<File> paths, @NotNull String message) throws VcsException {
        paths = this.filterCommittables(paths);
        return this.runCommit(paths, message);
    }

    @NotNull
    private CommitInfo[] runCommit(@NotNull List<File> paths, @NotNull String message) throws VcsException {
        if (ContainerUtil.isEmpty(paths)) {
            return new CommitInfo[]{CommitInfo.EMPTY};
        }
        Command command = this.newCommand(SvnCommandName.ci);
        command.put(Depth.EMPTY);
        command.put("-m", message);
        ContainerUtil.sort(paths);
        command.setTargets(paths);
        IdeaCommitHandler handler = new IdeaCommitHandler(ProgressManager.getInstance().getProgressIndicator());
        CommandListener listener = new CommandListener(handler);
        listener.setBaseDirectory(CommandUtil.requireExistingParent(paths.get(0)));
        this.execute(this.myVcs, SvnTarget.fromFile((File)paths.get(0)), null, command, (LineCommandListener)listener);
        listener.throwExceptionIfOccurred();
        long revision = CmdCheckinClient.validateRevisionNumber(listener.getCommittedRevision());
        return new CommitInfo[]{new CommitInfo.Builder().setRevision(revision).build()};
    }

    private static long validateRevisionNumber(long revision) throws VcsException {
        if (revision < 0L) {
            throw new VcsException("Wrong committed revision number: " + revision);
        }
        return revision;
    }

    @NotNull
    private List<File> filterCommittables(@NotNull List<File> committables) throws SvnBindException {
        final HashSet childrenOfSomebody = ContainerUtil.newHashSet();
        new AbstractFilterChildren<File>(){

            protected void sortAscending(List<File> list) {
                Collections.sort(list);
            }

            protected boolean isAncestor(File parent, File child) {
                boolean isAncestor = FileUtil.isAncestor((File)parent, (File)child, (boolean)true);
                if (isAncestor) {
                    childrenOfSomebody.add(child.getPath());
                }
                return isAncestor;
            }
        }.doFilter((List)ContainerUtil.newArrayList(committables));
        if (!childrenOfSomebody.isEmpty()) {
            ArrayList result = ContainerUtil.newArrayList();
            StatusClient statusClient = this.myFactory.createStatusClient();
            for (File file : committables) {
                if (!childrenOfSomebody.contains(file.getPath())) {
                    result.add(file);
                    continue;
                }
                try {
                    Status status = statusClient.doStatus(file, false);
                    if (status == null || StatusType.STATUS_NONE.equals((Object)status.getContentsStatus()) || StatusType.STATUS_UNVERSIONED.equals((Object)status.getContentsStatus())) continue;
                    result.add(file);
                }
                catch (SvnBindException e) {
                    LOG.info((Throwable)((Object)e));
                    throw e;
                }
            }
            return result;
        }
        return committables;
    }

    public static class CommandListener
    extends LineCommandAdapter {
        private static final String STATUS = "\\s*(\\w+)(.*?)\\s\\s+";
        private static final String OPTIONAL_FILE_TYPE = "(\\(.*\\))?";
        private static final String PATH = "\\s*(.*?)\\s*";
        private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(\\w+)(.*?)\\s\\s+(\\(.*\\))?\\s*(.*?)\\s*");
        @Nullable
        private final CommitEventHandler myHandler;
        private SvnBindException myException;
        private long myCommittedRevision = -1L;
        private File myBase;

        public CommandListener(@Nullable CommitEventHandler handler) {
            this.myHandler = handler;
        }

        public void throwExceptionIfOccurred() throws VcsException {
            if (this.myException != null) {
                throw this.myException;
            }
        }

        public long getCommittedRevision() {
            return this.myCommittedRevision;
        }

        public void setBaseDirectory(@NotNull File file) {
            this.myBase = file;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            String trim = line.trim();
            if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                try {
                    this.parseLine(trim);
                }
                catch (SvnBindException e) {
                    this.myException = e;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void parseLine(String line) throws SvnBindException {
            if (StringUtil.isEmptyOrSpaces((String)line)) {
                return;
            }
            if (line.startsWith(CommitEventType.transmittingDeltas.getText())) {
                if (this.myHandler == null) return;
                this.myHandler.commitEvent(CommitEventType.transmittingDeltas, this.myBase);
                return;
            }
            if (line.startsWith(CommitEventType.skipped.getText())) {
                int pathEnd;
                File target = null;
                if (this.myHandler == null) return;
                int pathStart = line.indexOf(39);
                if (pathStart > -1 && (pathEnd = line.indexOf(39, pathStart + 1)) > -1) {
                    target = this.toFile(line.substring(pathStart + 1, pathEnd));
                }
                if (target != null) {
                    this.myHandler.commitEvent(CommitEventType.skipped, this.myBase);
                    return;
                }
                LOG.info("Can not parse 'Skipped' path " + line);
                return;
            }
            if (line.startsWith(CommitEventType.committedRevision.getText())) {
                String substring = line.substring(CommitEventType.committedRevision.getText().length());
                int cnt = 0;
                while (StringUtil.isWhiteSpace((char)substring.charAt(cnt))) {
                    ++cnt;
                }
                StringBuilder num = new StringBuilder();
                while (Character.isDigit(substring.charAt(cnt))) {
                    num.append(substring.charAt(cnt));
                    ++cnt;
                }
                if (num.length() <= 0) {
                    String message = "Missing committed revision number: " + num.toString() + ", string: " + line;
                    LOG.info(message);
                    throw new SvnBindException(message);
                }
                try {
                    this.myCommittedRevision = Long.parseLong(num.toString());
                    if (this.myHandler == null) return;
                    this.myHandler.committedRevision(this.myCommittedRevision);
                    return;
                }
                catch (NumberFormatException e) {
                    String message = "Wrong committed revision number: " + num.toString() + ", string: " + line;
                    LOG.info(message, (Throwable)e);
                    throw new SvnBindException(message);
                }
            }
            if (this.myHandler == null) {
                return;
            }
            Matcher matcher = CHANGED_PATH.matcher(line);
            if (!matcher.matches()) {
                LOG.info("Can not parse output: " + line);
                return;
            }
            CommitEventType type = CommitEventType.create(matcher.group(1));
            if (type == null) {
                LOG.info("Can not parse event type: " + line);
                return;
            }
            this.myHandler.commitEvent(type, this.toFile(matcher.group(4)));
        }

        @NotNull
        private File toFile(@NotNull String path) {
            return SvnUtil.resolvePath(this.myBase, path);
        }
    }
}

