/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.auth.SvnInteractiveAuthenticationProvider;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.wc.SVNRevision;

abstract class AbstractAuthenticator {
    private static final Logger LOG = Logger.getInstance(AbstractAuthenticator.class);
    @NotNull
    protected final AuthenticationService myAuthenticationService;
    @NotNull
    protected final SvnVcs myVcs;
    @NotNull
    protected final SVNURL myUrl;
    protected final String myRealm;
    protected boolean myStoreInUsual;
    protected SvnAuthenticationManager myTmpDirManager;

    AbstractAuthenticator(@NotNull AuthenticationService authenticationService, @NotNull SVNURL url, String realm) {
        this.myAuthenticationService = authenticationService;
        this.myVcs = this.myAuthenticationService.getVcs();
        this.myUrl = url;
        this.myRealm = realm;
    }

    protected boolean tryAuthenticate() {
        SvnAuthenticationManager passive = this.myVcs.getSvnConfiguration().getPassiveAuthenticationManager(this.myVcs.getProject());
        SvnAuthenticationManager active = this.myVcs.getSvnConfiguration().getAuthenticationManager(this.myVcs);
        try {
            boolean authenticated;
            boolean bl = authenticated = this.getWithPassive(passive) || this.myAuthenticationService.isActive() && this.getWithActive(active);
            if (!authenticated) {
                return false;
            }
            SvnAuthenticationManager manager = this.myStoreInUsual ? active : this.createTmpManager();
            manager.setArtificialSaving(true);
            return this.acknowledge(manager);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myVcs.getProject(), (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            return false;
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myVcs.getProject(), (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            return false;
        }
    }

    @NotNull
    protected SvnAuthenticationManager createTmpManager() throws IOException {
        if (this.myTmpDirManager == null) {
            this.myAuthenticationService.initTmpDir(this.myVcs.getSvnConfiguration());
            this.myTmpDirManager = new SvnAuthenticationManager(this.myVcs.getProject(), this.myAuthenticationService.getTempDirectory());
            this.myTmpDirManager.setRuntimeStorage(SvnConfiguration.RUNTIME_AUTH_CACHE);
            this.myTmpDirManager.setAuthenticationProvider(new SvnInteractiveAuthenticationProvider(this.myVcs, this.myTmpDirManager));
        }
        return this.myTmpDirManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getWithActive(SvnAuthenticationManager active) throws SVNException {
        MessageBusConnection connection = null;
        try {
            Project project = this.myVcs.getProject();
            connection = project.getMessageBus().connect((Disposable)project);
            connection.subscribe(SvnAuthenticationManager.AUTHENTICATION_PROVIDER_LISTENER, (Object)new MyAuthenticationProviderListener());
            this.makeAuthCall(active);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return this.afterAuthCall();
    }

    protected void makeAuthCall(@NotNull SvnAuthenticationManager manager) throws SVNException {
        this.myVcs.getSvnKitManager().createWCClient((ISVNAuthenticationManager)manager).doInfo(this.myUrl, SVNRevision.UNDEFINED, SVNRevision.HEAD);
    }

    protected void acceptServerAuthentication(SVNURL url, String realm, Object certificate, int acceptResult) {
    }

    public void requestClientAuthentication(SVNURL url, String realm, SVNAuthentication authentication) {
    }

    protected abstract boolean afterAuthCall();

    protected abstract boolean getWithPassive(SvnAuthenticationManager var1) throws SVNException;

    protected abstract boolean acknowledge(SvnAuthenticationManager var1) throws SVNException;

    protected static boolean storeCredentials(@NotNull SvnAuthenticationManager manager, SVNAuthentication authentication, String realm) throws SVNException {
        try {
            if (authentication instanceof SVNSSLAuthentication && ((SVNSSLAuthentication)authentication).getCertificateFile() != null) {
                manager.acknowledgeForSSL(true, authentication);
                realm = ((SVNSSLAuthentication)authentication).getCertificateFile().getPath();
            }
            manager.acknowledgeAuthentication(true, AbstractAuthenticator.getFromType(authentication), realm, null, authentication, authentication.getURL());
        }
        catch (SvnAuthenticationManager.CredentialsSavedException e) {
            return e.isSuccess();
        }
        return true;
    }

    @NotNull
    private static String getFromType(SVNAuthentication authentication) {
        if (authentication instanceof SVNPasswordAuthentication) {
            return "svn.simple";
        }
        if (authentication instanceof SVNSSHAuthentication) {
            return "svn.ssh";
        }
        if (authentication instanceof SVNSSLAuthentication) {
            return "svn.ssl.client-passphrase";
        }
        if (authentication instanceof SVNUserNameAuthentication) {
            return "svn.username";
        }
        throw new IllegalArgumentException();
    }

    private class MyAuthenticationProviderListener
    implements SvnAuthenticationManager.ISVNAuthenticationProviderListener {
        private MyAuthenticationProviderListener() {
        }

        @Override
        public void requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored, SVNAuthentication authentication) {
            AbstractAuthenticator.this.requestClientAuthentication(url, realm, authentication);
        }

        @Override
        public void acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored, int acceptResult) {
            AbstractAuthenticator.this.acceptServerAuthentication(url, realm, certificate, acceptResult);
        }
    }
}

