/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public abstract class BaseSvnClient
implements SvnClient {
    protected SvnVcs myVcs;
    protected ClientFactory myFactory;
    protected boolean myIsActive;

    @Override
    @NotNull
    public SvnVcs getVcs() {
        return this.myVcs;
    }

    @Override
    public void setVcs(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
    }

    @Override
    @NotNull
    public ClientFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public void setFactory(@NotNull ClientFactory factory) {
        this.myFactory = factory;
    }

    @Override
    public void setIsActive(boolean isActive) {
        this.myIsActive = isActive;
    }

    protected void assertUrl(@NotNull SvnTarget target) {
        if (!target.isURL()) {
            throw new IllegalArgumentException("Target should be url " + target);
        }
    }

    protected void assertFile(@NotNull SvnTarget target) {
        if (!target.isFile()) {
            throw new IllegalArgumentException("Target should be file " + target);
        }
    }

    protected void assertDirectory(@NotNull SvnTarget target) {
        this.assertFile(target);
        if (!target.getFile().isDirectory()) {
            throw new IllegalArgumentException("Target should be directory " + target);
        }
    }

    protected void validateFormat(@NotNull WorkingCopyFormat format, @NotNull Collection<WorkingCopyFormat> supported) throws VcsException {
        if (!supported.contains((Object)format)) {
            throw new VcsException(String.format("%s format is not supported. Supported formats are: %s.", format.getName(), StringUtil.join(supported, (String)",")));
        }
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener) throws SvnBindException {
        return this.execute(vcs, target, null, name, parameters, listener);
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable File workingDirectory, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener) throws SvnBindException {
        Command command = this.newCommand(name);
        command.put(parameters);
        return this.execute(vcs, target, workingDirectory, command, listener);
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable File workingDirectory, @NotNull Command command, @Nullable LineCommandListener listener) throws SvnBindException {
        command.setTarget(target);
        command.setWorkingDirectory(workingDirectory);
        command.setResultBuilder(listener);
        return this.newRuntime(vcs).runWithAuthenticationAttempt(command);
    }

    @NotNull
    public Command newCommand(@NotNull SvnCommandName name) {
        return new Command(name);
    }

    @NotNull
    public CommandRuntime newRuntime(@NotNull SvnVcs vcs) {
        return new CommandRuntime(vcs, new AuthenticationService(vcs, this.myIsActive));
    }

    protected static void callHandler(@Nullable ProgressTracker handler, @NotNull ProgressEvent event) throws VcsException {
        if (handler != null) {
            try {
                handler.consume(event);
            }
            catch (SVNException e) {
                throw new SvnBindException(e);
            }
        }
    }

    @NotNull
    protected static ProgressEvent createEvent(@NotNull File path, @Nullable EventAction action) {
        return new ProgressEvent(path, 0L, null, null, action, null, null);
    }

    @Nullable
    protected static ISVNEventHandler toEventHandler(final @Nullable ProgressTracker handler) {
        ISVNEventHandler result = null;
        if (handler != null) {
            result = new ISVNEventHandler(){

                public void handleEvent(SVNEvent event, double progress) throws SVNException {
                    handler.consume(ProgressEvent.create(event));
                }

                public void checkCancelled() throws SVNCancelException {
                    handler.checkCancelled();
                }
            };
        }
        return result;
    }

    @Nullable
    protected static SVNDiffOptions toDiffOptions(@Nullable DiffOptions options) {
        return options != null ? new SVNDiffOptions(options.isIgnoreAllWhitespace(), options.isIgnoreAmountOfWhitespace(), options.isIgnoreEOLStyle()) : null;
    }

    @Nullable
    protected static SVNDepth toDepth(@Nullable Depth depth) {
        return depth != null ? SVNDepth.fromString((String)depth.getName()) : null;
    }

    @NotNull
    protected static SVNRevision notNullize(@Nullable SVNRevision revision) {
        return revision != null ? revision : SVNRevision.UNDEFINED;
    }
}

