/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.ActionExecuteHelper;
import com.intellij.vcsUtil.ActionStateConsumer;
import com.intellij.vcsUtil.ActionUpdateHelper;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.dialogs.SelectCreateExternalTargetDialog;
import org.jetbrains.idea.svn.properties.ExternalsDefinitionParser;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CreateExternalAction
extends DumbAwareAction {
    public CreateExternalAction() {
        super(SvnBundle.message("svn.create.external.below.action", new Object[0]), SvnBundle.message("svn.create.external.below.description", new Object[0]), null);
    }

    public void actionPerformed(AnActionEvent e) {
        ActionExecuteHelper helper = new ActionExecuteHelper();
        this.checkState(e, (ActionStateConsumer)helper);
        if (!helper.isOk()) {
            return;
        }
        DataContext dc = e.getDataContext();
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        final VirtualFile vf = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dc);
        SelectCreateExternalTargetDialog dialog = new SelectCreateExternalTargetDialog(project, vf);
        dialog.show();
        if (0 != dialog.getExitCode()) {
            return;
        }
        final String url = dialog.getSelectedURL();
        final boolean checkout = dialog.isCheckout();
        final String target = dialog.getLocalTarget().trim();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Creating External", true, null){

            public void run(@NotNull ProgressIndicator indicator) {
                CreateExternalAction.this.doInBackground(project, vf, url, checkout, target);
            }
        });
    }

    private void doInBackground(Project project, VirtualFile vf, String url, boolean checkout, String target) {
        SvnVcs vcs = SvnVcs.getInstance(project);
        try {
            File ioFile = new File(vf.getPath());
            if (CreateExternalAction.addToExternalProperty(vcs, ioFile, target, url)) {
                return;
            }
            final VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
            final FilePath filePath = VcsUtil.getFilePath((File)ioFile, (boolean)true);
            dirtyScopeManager.fileDirty(filePath);
            if (checkout) {
                UpdateClient client = vcs.getFactory(ioFile).createUpdateClient();
                client.setEventHandler(new ProgressTracker(){

                    public void consume(ProgressEvent event) throws SVNException {
                    }

                    @Override
                    public void checkCancelled() throws SVNCancelException {
                        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                        if (pi != null && pi.isCanceled()) {
                            throw new SVNCancelException();
                        }
                    }
                });
                client.doUpdate(ioFile, SVNRevision.HEAD, Depth.UNKNOWN, false, false);
                vf.refresh(true, true, new Runnable(){

                    @Override
                    public void run() {
                        dirtyScopeManager.dirDirtyRecursively(filePath);
                    }
                });
            }
        }
        catch (SVNException e1) {
            AbstractVcsHelper.getInstance((Project)project).showError(new VcsException((Throwable)e1), "Create External");
        }
        catch (VcsException e1) {
            AbstractVcsHelper.getInstance((Project)project).showError(e1, "Create External");
        }
    }

    public static boolean addToExternalProperty(@NotNull SvnVcs vcs, @NotNull File ioFile, String target, String url) throws SVNException, VcsException {
        String newValue;
        ClientFactory factory = vcs.getFactory(ioFile);
        PropertyValue propertyValue = factory.createPropertyClient().getProperty(SvnTarget.fromFile((File)ioFile), "svn:externals", false, SVNRevision.UNDEFINED);
        if (propertyValue != null && !StringUtil.isEmptyOrSpaces((String)propertyValue.toString())) {
            Map<String, String> externalsMap = ExternalsDefinitionParser.parseExternalsProperty(propertyValue.toString());
            String externalsForTarget = externalsMap.get(target);
            if (externalsForTarget != null) {
                AbstractVcsHelper.getInstance((Project)vcs.getProject()).showError(new VcsException("Selected destination conflicts with existing: " + externalsForTarget), "Create External");
                return true;
            }
            String string = CreateExternalAction.createExternalDefinitionString(url, target);
            newValue = propertyValue.toString().trim() + "\n" + string;
        } else {
            newValue = CreateExternalAction.createExternalDefinitionString(url, target);
        }
        factory.createPropertyClient().setProperty(ioFile, "svn:externals", PropertyValue.create(newValue), Depth.EMPTY, false);
        return false;
    }

    public static String createExternalDefinitionString(String url, String target) {
        return CommandUtil.escape(url) + " " + target;
    }

    public void update(AnActionEvent e) {
        ActionUpdateHelper helper = new ActionUpdateHelper();
        this.checkState(e, (ActionStateConsumer)helper);
        helper.apply(e);
    }

    private void checkState(AnActionEvent e, ActionStateConsumer sc) {
        DataContext dc = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            sc.hide();
            return;
        }
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        if (!manager.checkVcsIsActive(SvnVcs.getKey().getName())) {
            sc.hide();
            return;
        }
        VirtualFile vf = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dc);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dc);
        if (vf == null || files == null || files.length != 1 || !vf.isDirectory()) {
            sc.disable();
            return;
        }
        AbstractVcs vcsFor = manager.getVcsFor(vf);
        if (vcsFor == null || !SvnVcs.getKey().equals((Object)vcsFor.getKeyInstanceMethod())) {
            sc.disable();
            return;
        }
        FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(vf);
        if (status == null || FileStatus.DELETED.equals(status) || FileStatus.IGNORED.equals(status) || FileStatus.MERGED_WITH_PROPERTY_CONFLICTS.equals(status) || FileStatus.OBSOLETE.equals(status) || FileStatus.UNKNOWN.equals(status)) {
            sc.disable();
            return;
        }
        sc.enable();
    }
}

