/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;

public class CleanupWorker {
    protected VirtualFile[] myRoots;
    private final Project myProject;
    private final String myTitleKey;

    public CleanupWorker(VirtualFile[] roots, Project project, String titleKey) {
        this.myRoots = roots;
        this.myProject = project;
        this.myTitleKey = titleKey;
    }

    public void execute() {
        ApplicationManager.getApplication().saveAll();
        this.chanceToFillRoots();
        if (this.myRoots.length == 0) {
            return;
        }
        final LinkedList exceptions = new LinkedList();
        final SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, SvnBundle.message(this.myTitleKey, new Object[0]), true){

            public void run(final @NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                VirtualFile[] virtualFileArray = CleanupWorker.this.myRoots;
                int n = virtualFileArray.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile root;
                    VirtualFile currentRoot = root = virtualFileArray[i];
                    try {
                        File path = new File(root.getPath());
                        indicator.setText(SvnBundle.message("action.Subversion.cleanup.progress.text", path));
                        ProgressTracker handler = new ProgressTracker(){

                            public void consume(ProgressEvent event) throws SVNException {
                            }

                            @Override
                            public void checkCancelled() throws SVNCancelException {
                                if (indicator.isCanceled()) {
                                    throw new SVNCancelException();
                                }
                            }
                        };
                        vcs.getFactory(path).createCleanupClient().cleanup(path, handler);
                        continue;
                    }
                    catch (VcsException ex) {
                        exceptions.add(Pair.create((Object)((Object)ex), (Object)currentRoot));
                    }
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                if (this.myProject.isDisposed()) {
                    return;
                }
                VcsDirtyScopeManager manager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                if (myProject.isDisposed()) {
                                    return;
                                }
                                for (VirtualFile root : CleanupWorker.this.myRoots) {
                                    root.refresh(false, true);
                                }
                            }
                        });
                    }
                });
                for (VirtualFile root : CleanupWorker.this.myRoots) {
                    if (root.isDirectory()) {
                        manager.dirDirtyRecursively(root);
                        continue;
                    }
                    manager.fileDirty(root);
                }
                if (!exceptions.isEmpty()) {
                    LinkedList<VcsException> vcsExceptions = new LinkedList<VcsException>();
                    for (Pair pair : exceptions) {
                        VcsException exception = (VcsException)((Object)pair.first);
                        vcsExceptions.add(new VcsException(SvnBundle.message("action.Subversion.cleanup.error.message", FileUtil.toSystemDependentName((String)((VirtualFile)pair.second).getPath()), exception == null ? "" : exception.getMessage())));
                    }
                    AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
                    helper.showErrors(vcsExceptions, SvnBundle.message(CleanupWorker.this.myTitleKey, new Object[0]));
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    protected void chanceToFillRoots() {
    }
}

