/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.util.TimeoutUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopy;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.SVNException;

public abstract class SvnAbstractWriteOperationLocks {
    private final long myTimeout;
    private static final Map<String, Lock> myLockMap = new HashMap<String, Lock>();
    private static final Object myLock = new Object();
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnAbstractWriteOperationLocks");
    private ISqlJetBusyHandler ourBusyHandler;
    private volatile boolean myDisposed;

    protected SvnAbstractWriteOperationLocks(long timeout) {
        this.myTimeout = timeout;
        this.ourBusyHandler = new ISqlJetBusyHandler(){

            public boolean call(int i) {
                if (SvnAbstractWriteOperationLocks.this.myDisposed) {
                    return false;
                }
                TimeoutUtil.sleep((long)SvnAbstractWriteOperationLocks.this.myTimeout);
                return true;
            }
        };
    }

    public void dispose() {
        this.myDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Lock getLockObject(File file) throws SVNException {
        Lock lock;
        boolean directory = file.isDirectory();
        WorkingCopy wcRoot = this.getCopy(file, directory);
        if (!wcRoot.is17Copy()) {
            return null;
        }
        String path = FilePathsHelper.convertPath((String)wcRoot.getFile().getPath());
        Object object = myLock;
        synchronized (object) {
            lock = myLockMap.get(path);
            if (lock == null) {
                lock = new ReentrantLock();
                myLockMap.put(path, lock);
            }
        }
        return lock;
    }

    protected abstract WorkingCopy getCopy(File var1, boolean var2) throws SVNException;

    public void lockWrite(File file) throws SVNException {
        Lock lock = this.getLockObject(file);
        if (lock != null) {
            lock.lock();
        }
    }

    public void unlockWrite(File file) throws SVNException {
        Lock lock = this.getLockObject(file);
        if (lock != null) {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapRead(File file, final Runnable runnable) throws SVNException {
        WorkingCopy copy = this.getCopy(file, file.isDirectory());
        if (!copy.is17Copy()) {
            runnable.run();
            return;
        }
        File root = copy.getFile();
        SqlJetDb open = null;
        final boolean[] run = new boolean[]{false};
        try {
            open = SqlJetDb.open((File)SvnUtil.getWcDb(root), (boolean)false);
            open.setBusyHandler(this.ourBusyHandler);
            try {
                SqlJetDb finalOpen = open;
                open.runReadTransaction(new ISqlJetTransaction(){

                    public Object run(SqlJetDb db) throws SqlJetException {
                        run[0] = true;
                        runnable.run();
                        return null;
                    }
                });
            }
            finally {
                open.rollback();
            }
        }
        catch (SqlJetException e) {
            LOG.info((Throwable)e);
            if (!run[0]) {
                runnable.run();
            }
        }
        finally {
            if (open != null) {
                try {
                    open.close();
                }
                catch (SqlJetException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }
}

