/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.UriUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNURL;

public class RootUrlInfo
implements RootUrlPair {
    @NotNull
    private final String myRepositoryUrl;
    @NotNull
    private final WorkingCopyFormat myFormat;
    @NotNull
    private final Node myNode;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private volatile NestedCopyType myType;

    public RootUrlInfo(@NotNull Node node, @NotNull WorkingCopyFormat format, @NotNull VirtualFile root) {
        this(node, format, root, null);
    }

    public RootUrlInfo(@NotNull Node node, @NotNull WorkingCopyFormat format, @NotNull VirtualFile root, @Nullable NestedCopyType type) {
        this.myNode = node;
        this.myFormat = format;
        this.myRoot = root;
        this.myRepositoryUrl = UriUtil.trimTrailingSlashes((String)node.getRepositoryRootUrl().toString());
        this.myType = type;
    }

    @NotNull
    public Node getNode() {
        return this.myNode;
    }

    @NotNull
    public String getRepositoryUrl() {
        return this.myRepositoryUrl;
    }

    @NotNull
    public SVNURL getRepositoryUrlUrl() {
        return this.myNode.getRepositoryRootUrl();
    }

    @NotNull
    public String getAbsoluteUrl() {
        return this.getAbsoluteUrlAsUrl().toString();
    }

    @NotNull
    public SVNURL getAbsoluteUrlAsUrl() {
        return this.myNode.getUrl();
    }

    @NotNull
    public WorkingCopyFormat getFormat() {
        return this.myFormat;
    }

    @NotNull
    public File getIoFile() {
        return this.myNode.getIoFile();
    }

    @NotNull
    public String getPath() {
        return this.getIoFile().getAbsolutePath();
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myNode.getFile();
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.getAbsoluteUrl();
    }

    @Nullable
    public NestedCopyType getType() {
        return this.myType;
    }

    public void setType(@Nullable NestedCopyType type) {
        this.myType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootUrlInfo info = (RootUrlInfo)o;
        if (this.myFormat != info.myFormat) {
            return false;
        }
        if (!this.myNode.equals(info.myNode)) {
            return false;
        }
        if (!this.myRoot.equals(info.myRoot)) {
            return false;
        }
        return this.myType == info.myType;
    }

    public int hashCode() {
        int result = this.myFormat.hashCode();
        result = 31 * result + this.myNode.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }
}

