/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.config.DefaultProxyGroup;
import org.jetbrains.idea.svn.config.ProxyGroup;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;

public class IdeaSVNConfigFile {
    public static final String SERVERS_FILE_NAME = "servers";
    public static final String CONFIG_FILE_NAME = "config";
    private final Map<String, String> myPatternsMap;
    private final long myLatestUpdate;
    private final File myFile;
    private Map myDefaultProperties;
    private final SVNConfigFile mySVNConfigFile;
    private static final String GROUPS_GROUP_NAME = "groups";

    public IdeaSVNConfigFile(File file) {
        this.mySVNConfigFile = new SVNConfigFile(file);
        this.myFile = file;
        this.myLatestUpdate = -1L;
        this.myPatternsMap = new HashMap<String, String>();
    }

    @NotNull
    public static String getNewGroupName(@NotNull String host, @NotNull IdeaSVNConfigFile configFile) {
        String groupName = host;
        Map<String, ProxyGroup> groups = configFile.getAllGroups();
        while (StringUtil.isEmptyOrSpaces((String)groupName) || groups.containsKey(groupName)) {
            groupName = groupName + "1";
        }
        return groupName;
    }

    public void updateGroups() {
        if (this.myLatestUpdate != this.myFile.lastModified()) {
            this.myPatternsMap.clear();
            this.myPatternsMap.putAll(this.mySVNConfigFile.getProperties(GROUPS_GROUP_NAME));
            this.myDefaultProperties = this.mySVNConfigFile.getProperties("global");
        }
    }

    public Map<String, ProxyGroup> getAllGroups() {
        HashMap<String, ProxyGroup> result = new HashMap<String, ProxyGroup>(this.myPatternsMap.size());
        for (Map.Entry<String, String> entry : this.myPatternsMap.entrySet()) {
            String groupName = entry.getKey();
            result.put(groupName, new ProxyGroup(groupName, entry.getValue(), this.mySVNConfigFile.getProperties(groupName)));
        }
        return result;
    }

    public DefaultProxyGroup getDefaultGroup() {
        return new DefaultProxyGroup(this.myDefaultProperties);
    }

    public void setValue(String groupName, String propertyName, String value) {
        this.mySVNConfigFile.setPropertyValue(groupName, propertyName, value, true);
    }

    public void deleteGroup(String name) {
        Map properties = this.mySVNConfigFile.getProperties(name);
        for (String propertyName : properties.keySet()) {
            this.mySVNConfigFile.setPropertyValue(name, propertyName, null, false);
        }
        if ("global".equals(name)) {
            this.myDefaultProperties.clear();
        }
        this.mySVNConfigFile.setPropertyValue(GROUPS_GROUP_NAME, name, null, false);
        this.mySVNConfigFile.deleteGroup(name, false);
    }

    public void addGroup(String name, String patterns, Map<String, String> properties) {
        this.mySVNConfigFile.setPropertyValue(GROUPS_GROUP_NAME, name, patterns, false);
        this.addProperties(name, properties);
    }

    private void addProperties(String groupName, Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.mySVNConfigFile.setPropertyValue(groupName, entry.getKey(), entry.getValue(), false);
        }
    }

    public void modifyGroup(String name, String patterns, Collection<String> delete, Map<String, String> addOrModify, boolean isDefault) {
        if (!isDefault) {
            this.mySVNConfigFile.setPropertyValue(GROUPS_GROUP_NAME, name, patterns, false);
        }
        HashMap<String, String> deletedPrepared = new HashMap<String, String>(delete.size());
        for (String property : delete) {
            deletedPrepared.put(property, null);
        }
        this.addProperties(name, deletedPrepared);
        this.addProperties(name, addOrModify);
    }

    public void save() {
        this.mySVNConfigFile.save();
    }
}

