/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNodeChunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public final class XmlCdataChunk
extends XmlNodeChunk {
    private final int rawValue;
    private final BinaryResourceValue binaryResourceValue;

    protected XmlCdataChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.rawValue = buffer.getInt();
        this.binaryResourceValue = BinaryResourceValue.create(buffer);
    }

    public String getRawValue() {
        return this.getString(this.rawValue);
    }

    public BinaryResourceValue getResourceValue() {
        return this.binaryResourceValue;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_CDATA;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        super.writePayload(output, header, shrink);
        output.writeInt(this.rawValue);
        output.write(this.binaryResourceValue.toByteArray());
    }

    @Override
    public String toString() {
        return String.format("XmlCdataChunk{line=%d, comment=%s, value=%s}", this.getLineNumber(), this.getComment(), this.getRawValue());
    }
}

