/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Entity;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class Message
implements BinaryObject {
    public Entity[] entities;
    public ConstantSet[] constants;

    @Override
    @NotNull
    public BinaryClass klass() {
        return Klass.INSTANCE;
    }

    public static void register() {
    }

    static {
        Namespace.register(Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;

        private static final Entity ENTITY;

        @Override
        @NotNull
        public Entity entity() {
            return ENTITY;
        }

        @Override
        @NotNull
        public BinaryObject create() {
            return new Message();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            int oldMode = e.setMode(1);
            try {
                Message o = (Message)obj;
                e.uint32(o.entities.length);
                for (Entity entity : o.entities) {
                    e.entity(entity);
                }
                e.uint32(o.constants.length);
                for (ConstantSet set : o.constants) {
                    set.encode(e);
                }
            }
            finally {
                e.setMode(oldMode);
            }
        }

        @Override
        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            int i;
            Message o = (Message)obj;
            o.entities = new Entity[d.uint32()];
            for (i = 0; i < o.entities.length; ++i) {
                o.entities[i] = d.entity();
            }
            o.constants = new ConstantSet[d.uint32()];
            for (i = 0; i < o.constants.length; ++i) {
                o.constants[i] = new ConstantSet(d);
            }
        }

        static {
            ENTITY = new Entity("schema", "Message", "", "");
        }
    }
}

