/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.binary;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;

public class BinaryID {
    private static final int SIZE = 20;
    public static BinaryID INVALID = new BinaryID();
    @NotNull
    private final byte[] mValue = new byte[20];
    private final int mHashCode;

    public BinaryID() {
        this.mHashCode = 0;
    }

    public BinaryID(@NotNull byte[] value) {
        assert (value.length == 20);
        System.arraycopy(value, 0, this.mValue, 0, 20);
        this.mHashCode = ByteBuffer.wrap(this.mValue).getInt();
    }

    public BinaryID(@NotNull Decoder d) throws IOException {
        d.read(this.mValue, 20);
        this.mHashCode = ByteBuffer.wrap(this.mValue).getInt();
    }

    public void write(@NotNull Encoder e) throws IOException {
        e.write(this.mValue, 20);
    }

    public boolean equals(Object other) {
        if (!(other instanceof BinaryID)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return Arrays.equals(this.mValue, ((BinaryID)other).mValue);
    }

    public String toString() {
        return DatatypeConverter.printHexBinary((byte[])this.mValue).toLowerCase();
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public byte[] getBytes() {
        return this.mValue;
    }
}

