/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import java.util.Arrays;
import java.util.List;

public class MathDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("FloatMath", "Using `FloatMath` instead of `Math`", "In older versions of Android, using `android.util.FloatMath` was recommended for performance reasons when operating on floats. However, on modern hardware doubles are just as fast as float (though they take more memory), and in recent versions of Android, `FloatMath` is actually slower than using `java.lang.Math` due to the way the JIT optimizes `java.lang.Math`. Therefore, you should use `Math` instead of `FloatMath` if you are only targeting Froyo and above.", Category.PERFORMANCE, 3, Severity.WARNING, new Implementation(MathDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/design/performance.html#avoidfloat");

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("sin", "cos", "ceil", "sqrt", "floor");
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        if (context.getEvaluator().isMemberInClass((PsiMember)method, "android.util.FloatMath") && context.getProject().getMinSdk() >= 8) {
            String message = String.format("Use `java.lang.Math#%1$s` instead of `android.util.FloatMath#%1$s()` since it is faster as of API 8", method.getName());
            PsiReferenceExpression expression = call.getMethodExpression();
            PsiElement operand = expression.getQualifier();
            Location location = operand != null && expression.getReferenceNameElement() != null ? context.getRangeLocation(operand, 0, expression.getReferenceNameElement(), 0) : context.getLocation((PsiElement)call);
            context.report(ISSUE, (PsiElement)call, location, message);
        }
    }
}

