/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.repository.api.LocalPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiPackage;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.primitives.UnsignedBytes;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiLookup {
    private static final String XML_FILE_PATH = "platform-tools/api/api-versions.xml";
    private static final String FILE_HEADER = "API database used by Android lint\u0000";
    private static final int BINARY_FORMAT_VERSION = 8;
    private static final boolean DEBUG_SEARCH = false;
    private static final boolean WRITE_STATS = false;
    private static final int CLASS_HEADER_MEMBER_OFFSETS = 1;
    private static final int CLASS_HEADER_API = 2;
    private static final int CLASS_HEADER_DEPRECATED = 3;
    private static final int CLASS_HEADER_INTERFACES = 4;
    private static final int HAS_DEPRECATION_BYTE_FLAG = 128;
    private static final int API_MASK = -129;
    static final boolean DEBUG_FORCE_REGENERATE_BINARY = false;
    private final Api mInfo;
    private byte[] mData;
    private int[] mIndices;
    private static WeakReference<ApiLookup> sInstance = new WeakReference<Object>(null);
    private int mPackageCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiLookup get(LintClient client) {
        Class<ApiLookup> clazz = ApiLookup.class;
        synchronized (ApiLookup.class) {
            ApiLookup db = (ApiLookup)sInstance.get();
            if (db == null) {
                String build;
                String env = System.getProperty("LINT_API_DATABASE");
                File file = env != null ? new File(env) : client.findResource(XML_FILE_PATH);
                if (file == null && (build = System.getenv("ANDROID_BUILD_TOP")) != null) {
                    file = new File(build, "development/sdk/api-versions.xml".replace('/', File.separatorChar));
                }
                if (file == null || !file.exists()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                db = ApiLookup.get(client, file);
                sInstance = new WeakReference<ApiLookup>(db);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return db;
        }
    }

    static String getPlatformVersion(LintClient client) {
        LocalPackage pkgInfo;
        AndroidSdkHandler sdk = client.getSdk();
        if (sdk != null && (pkgInfo = sdk.getLocalPackage("platform-tools", client.getRepositoryLogger())) != null) {
            return pkgInfo.getVersion().toShortString();
        }
        return null;
    }

    static String getCacheFileName(String xmlFileName, String platformVersion) {
        if (LintUtils.endsWith(xmlFileName, ".xml")) {
            xmlFileName = xmlFileName.substring(0, xmlFileName.length() - ".xml".length());
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(xmlFileName);
        sb.append('-').append(8);
        if (platformVersion != null) {
            sb.append('-').append(platformVersion);
        }
        sb.append(".bin");
        return sb.toString();
    }

    private static ApiLookup get(LintClient client, File xmlFile) {
        if (!xmlFile.exists()) {
            client.log(null, "The API database file %1$s does not exist", xmlFile);
            return null;
        }
        File cacheDir = client.getCacheDir(true);
        if (cacheDir == null) {
            cacheDir = xmlFile.getParentFile();
        }
        String platformVersion = ApiLookup.getPlatformVersion(client);
        File binaryData = new File(cacheDir, ApiLookup.getCacheFileName(xmlFile.getName(), platformVersion));
        if (!(binaryData.exists() && binaryData.lastModified() >= xmlFile.lastModified() && binaryData.length() != 0L || ApiLookup.createCache(client, xmlFile, binaryData))) {
            return null;
        }
        if (!binaryData.exists()) {
            client.log(null, "The API database file %1$s does not exist", binaryData);
            return null;
        }
        return new ApiLookup(client, xmlFile, binaryData, null);
    }

    private static boolean createCache(LintClient client, File xmlFile, File binaryData) {
        long begin = 0L;
        Api info = Api.parseApi(xmlFile);
        if (info != null) {
            try {
                ApiLookup.writeDatabase(binaryData, info);
                return true;
            }
            catch (IOException ioe) {
                client.log(ioe, "Can't write API cache file", new Object[0]);
            }
        }
        return false;
    }

    private ApiLookup(LintClient client, File xmlFile, File binaryFile, Api info) {
        this.mInfo = info;
        if (binaryFile != null) {
            this.readData(client, xmlFile, binaryFile);
        }
    }

    private void readData(LintClient client, File xmlFile, File binaryFile) {
        if (!binaryFile.exists()) {
            client.log(null, "%1$s does not exist", binaryFile);
            return;
        }
        long start = System.currentTimeMillis();
        try {
            byte[] expectedHeader;
            byte[] b = Files.toByteArray((File)binaryFile);
            int offset = 0;
            for (byte anExpectedHeader : expectedHeader = FILE_HEADER.getBytes(Charsets.US_ASCII)) {
                if (anExpectedHeader == b[offset++]) continue;
                client.log(null, "Incorrect file header: not an API database cache file, or a corrupt cache file", new Object[0]);
                return;
            }
            if (b[offset++] != 8) {
                if (ApiLookup.createCache(client, xmlFile, binaryFile)) {
                    this.readData(client, xmlFile, binaryFile);
                }
                return;
            }
            int indexCount = ApiLookup.get4ByteInt(b, offset);
            this.mPackageCount = ApiLookup.get4ByteInt(b, offset += 4);
            offset += 4;
            this.mIndices = new int[indexCount];
            for (int i = 0; i < indexCount; ++i) {
                this.mIndices[i] = ApiLookup.get4ByteInt(b, offset);
                offset += 4;
            }
            this.mData = b;
        }
        catch (Throwable e) {
            client.log(null, "Failure reading binary cache file %1$s", binaryFile.getPath());
            client.log(null, "Please delete the file and restart the IDE/lint: %1$s", binaryFile.getPath());
            client.log(e, null, new Object[0]);
        }
    }

    private static void writeDatabase(File file, Api info) throws IOException {
        int deprecatedIn;
        int since;
        Map<String, ApiClass> classMap = info.getClasses();
        ArrayList packages = Lists.newArrayList(info.getPackages().values());
        Collections.sort(packages);
        int estimatedSize = 0;
        for (ApiPackage pkg : packages) {
            estimatedSize += 4;
            estimatedSize += pkg.getName().length() + 20;
            if (LintUtils.assertionsEnabled() && !ApiLookup.isRelevantOwner(pkg.getName() + "/") && !pkg.getName().startsWith("android/support")) {
                System.out.println("Warning: isRelevantOwner fails for " + pkg.getName() + "/");
            }
            for (ApiClass apiClass : pkg.getClasses()) {
                estimatedSize += 4;
                estimatedSize += apiClass.getName().length() + 20;
                Iterator allMethods = apiClass.getAllMethods(info);
                Set<String> allFields = apiClass.getAllFields(info);
                int clsSince = apiClass.getSince();
                ArrayList<String> arrayList = new ArrayList<String>(allMethods.size() + allFields.size());
                Iterator<Object> iterator = allMethods.iterator();
                while (iterator.hasNext()) {
                    String member = (String)iterator.next();
                    if (apiClass.getMethod(member, info) == clsSince && apiClass.getMemberDeprecatedIn(member, info) <= 0) continue;
                    arrayList.add(member);
                }
                for (String member : allFields) {
                    if (apiClass.getField(member, info) == clsSince && apiClass.getMemberDeprecatedIn(member, info) <= 0) continue;
                    arrayList.add(member);
                }
                estimatedSize += 2 + 4 * apiClass.getInterfaces().size();
                if (apiClass.getSuperClasses().size() > 1) {
                    estimatedSize += 2 + 4 * apiClass.getSuperClasses().size();
                }
                Collections.sort(arrayList);
                apiClass.members = arrayList;
                for (String member : arrayList) {
                    estimatedSize += member.length();
                    estimatedSize += 16;
                }
            }
            Collections.sort(pkg.getClasses());
        }
        ByteBuffer buffer = ByteBuffer.allocate(estimatedSize);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put(FILE_HEADER.getBytes(Charsets.US_ASCII));
        buffer.put((byte)8);
        int indexCountOffset = buffer.position();
        int indexCount = 0;
        buffer.putInt(0);
        buffer.putInt(packages.size());
        int newIndex = buffer.position();
        for (ApiPackage pkg : packages) {
            pkg.indexOffset = newIndex;
            newIndex += 4;
            ++indexCount;
        }
        for (ApiPackage pkg : packages) {
            for (ApiClass apiClass : pkg.getClasses()) {
                apiClass.indexOffset = newIndex;
                apiClass.index = indexCount++;
                newIndex += 4;
            }
        }
        for (ApiPackage pkg : packages) {
            for (ApiClass apiClass : pkg.getClasses()) {
                if (apiClass.members != null && !apiClass.members.isEmpty()) {
                    apiClass.memberOffsetBegin = newIndex;
                    apiClass.memberIndexStart = indexCount;
                    for (String ignored : apiClass.members) {
                        newIndex += 4;
                        ++indexCount;
                    }
                    apiClass.memberOffsetEnd = newIndex;
                    apiClass.memberIndexLength = indexCount - apiClass.memberIndexStart;
                    continue;
                }
                apiClass.memberOffsetBegin = -1;
                apiClass.memberOffsetEnd = -1;
                apiClass.memberIndexStart = -1;
                apiClass.memberIndexLength = 0;
            }
        }
        buffer.position(indexCountOffset);
        buffer.putInt(indexCount);
        buffer.position(newIndex);
        for (ApiPackage pkg : packages) {
            for (ApiClass apiClass : pkg.getClasses()) {
                String clz = apiClass.getName();
                int index = apiClass.memberOffsetBegin;
                for (String member : apiClass.members) {
                    boolean isDeprecated;
                    byte[] signature;
                    int start = buffer.position();
                    buffer.position(index);
                    buffer.putInt(start);
                    index = buffer.position();
                    buffer.position(start);
                    since = member.indexOf(40) != -1 ? apiClass.getMethod(member, info) : apiClass.getField(member, info);
                    if (since == Integer.MAX_VALUE) {
                        assert (false) : clz + ':' + member;
                        since = 1;
                    }
                    if ((deprecatedIn = apiClass.getMemberDeprecatedIn(member, info)) != 0) assert (deprecatedIn != -1) : deprecatedIn + " for " + member;
                    for (byte b : signature = member.getBytes(Charsets.UTF_8)) {
                        assert (b == (b & 0x7F)) : member;
                        buffer.put(b);
                        if (b == 41) break;
                    }
                    buffer.put((byte)0);
                    int api = since;
                    assert (api == UnsignedBytes.toInt((byte)((byte)api)));
                    assert (api >= 1 && api < 255);
                    boolean bl = isDeprecated = deprecatedIn > 0;
                    if (isDeprecated) {
                        api |= 0x80;
                    }
                    buffer.put((byte)api);
                    if (!isDeprecated) continue;
                    assert (deprecatedIn == UnsignedBytes.toInt((byte)((byte)deprecatedIn)));
                    buffer.put((byte)deprecatedIn);
                }
                assert (index == apiClass.memberOffsetEnd) : apiClass.memberOffsetEnd;
            }
        }
        for (ApiPackage pkg : packages) {
            List<ApiClass> classes = pkg.getClasses();
            for (ApiClass cls : classes) {
                int api;
                List<Pair<String, Integer>> supers;
                boolean isDeprecated;
                int index = buffer.position();
                buffer.position(cls.indexOffset);
                buffer.putInt(index);
                buffer.position(index);
                String name = cls.getSimpleName();
                byte[] nameBytes = name.getBytes(Charsets.UTF_8);
                assert (nameBytes.length < 254) : name;
                buffer.put((byte)(nameBytes.length + 2));
                buffer.put(nameBytes);
                buffer.put((byte)0);
                ApiLookup.put3ByteInt(buffer, cls.memberIndexStart);
                ApiLookup.put2ByteInt(buffer, cls.memberIndexLength);
                ApiClass apiClass = classMap.get(cls.getName());
                assert (apiClass != null) : cls.getName();
                since = apiClass.getSince();
                assert (since == UnsignedBytes.toInt((byte)((byte)since))) : since;
                deprecatedIn = apiClass.getDeprecatedIn();
                boolean bl = isDeprecated = deprecatedIn > 0;
                if (isDeprecated) assert ((since |= 0x80) == UnsignedBytes.toInt((byte)((byte)since))) : since;
                buffer.put((byte)since);
                if (isDeprecated) {
                    assert (deprecatedIn == UnsignedBytes.toInt((byte)((byte)deprecatedIn))) : deprecatedIn;
                    buffer.put((byte)deprecatedIn);
                }
                List<Pair<String, Integer>> interfaces = apiClass.getInterfaces();
                int count = 0;
                if (interfaces != null && !interfaces.isEmpty()) {
                    for (Pair<String, Integer> pair : interfaces) {
                        int api2 = (Integer)pair.getSecond();
                        if (api2 <= apiClass.getSince()) continue;
                        ++count;
                    }
                }
                if ((supers = apiClass.getSuperClasses()) != null && !supers.isEmpty()) {
                    for (Pair<String, Integer> pair : supers) {
                        api = (Integer)pair.getSecond();
                        if (api <= apiClass.getSince()) continue;
                        ++count;
                    }
                }
                buffer.put((byte)count);
                if (count <= 0) continue;
                if (supers != null) {
                    for (Pair<String, Integer> pair : supers) {
                        api = (Integer)pair.getSecond();
                        if (api <= apiClass.getSince()) continue;
                        ApiClass superClass = classMap.get(pair.getFirst());
                        assert (superClass != null) : cls;
                        ApiLookup.put3ByteInt(buffer, superClass.index);
                        buffer.put((byte)api);
                    }
                }
                if (interfaces == null) continue;
                for (Pair<String, Integer> pair : interfaces) {
                    api = (Integer)pair.getSecond();
                    if (api <= apiClass.getSince()) continue;
                    ApiClass interfaceClass = classMap.get(pair.getFirst());
                    assert (interfaceClass != null) : cls;
                    ApiLookup.put3ByteInt(buffer, interfaceClass.index);
                    buffer.put((byte)api);
                }
            }
        }
        for (ApiPackage pkg : packages) {
            int index = buffer.position();
            buffer.position(pkg.indexOffset);
            buffer.putInt(index);
            buffer.position(index);
            byte[] byArray = pkg.getName().getBytes(Charsets.UTF_8);
            buffer.put(byArray);
            buffer.put((byte)0);
            List<ApiClass> classes = pkg.getClasses();
            if (classes.isEmpty()) {
                ApiLookup.put3ByteInt(buffer, 0);
                ApiLookup.put2ByteInt(buffer, 0);
                continue;
            }
            int firstClassIndex = classes.get((int)0).index;
            int classCount = classes.get((int)(classes.size() - 1)).index - firstClassIndex + 1;
            ApiLookup.put3ByteInt(buffer, firstClassIndex);
            ApiLookup.put2ByteInt(buffer, classCount);
        }
        int size = buffer.position();
        assert (size <= buffer.limit());
        buffer.mark();
        byte[] b = new byte[size];
        buffer.rewind();
        buffer.get(b);
        if (file.exists()) {
            boolean deleted = file.delete();
            assert (deleted) : file;
        }
        ByteSink sink = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]);
        sink.write(b);
    }

    private String dumpEntry(int offset) {
        return "<disabled>";
    }

    private static int compare(byte[] data, int offset, byte terminator, String s, int sOffset, int max) {
        int i = offset;
        for (int j = sOffset; j < max; ++j) {
            byte b = data[i];
            char c = s.charAt(j);
            byte cb = (byte)c;
            int delta = b - cb;
            if (delta != 0) {
                return delta;
            }
            ++i;
        }
        return data[i] - terminator;
    }

    public int getClassVersion(String className) {
        ApiClass clz;
        if (this.mData != null) {
            return this.getClassVersion(this.findClass(className));
        }
        if (this.mInfo != null && (clz = this.mInfo.getClass(className)) != null) {
            int since = clz.getSince();
            if (since == Integer.MAX_VALUE) {
                since = -1;
            }
            return since;
        }
        return -1;
    }

    public boolean isKnownClass(String className) {
        return this.findClass(className) != -1;
    }

    private int getClassVersion(int classNumber) {
        if (classNumber != -1) {
            int offset = this.seekClassData(classNumber, 2);
            int api = UnsignedBytes.toInt((byte)this.mData[offset]) & 0xFFFFFF7F;
            return api > 1 ? api : -1;
        }
        return -1;
    }

    public int getValidCastVersion(String sourceClass, String destinationClass) {
        ApiClass clz;
        if (this.mData != null) {
            int interfaceNumber;
            int classNumber = this.findClass(sourceClass);
            if (classNumber != -1 && (interfaceNumber = this.findClass(destinationClass)) != -1) {
                int offset = this.seekClassData(classNumber, 4);
                int interfaceCount = this.mData[offset++];
                for (int i = 0; i < interfaceCount; ++i) {
                    int clsNumber = ApiLookup.get3ByteInt(this.mData, offset);
                    offset += 3;
                    byte api = this.mData[offset++];
                    if (clsNumber != interfaceNumber) continue;
                    return api;
                }
                return this.getClassVersion(classNumber);
            }
        } else if (this.mInfo != null && (clz = this.mInfo.getClass(sourceClass)) != null) {
            List<Pair<String, Integer>> interfaces = clz.getInterfaces();
            for (Pair<String, Integer> pair : interfaces) {
                String interfaceName = (String)pair.getFirst();
                if (!interfaceName.equals(destinationClass)) continue;
                return (Integer)pair.getSecond();
            }
        }
        return -1;
    }

    public int getClassDeprecatedIn(String className) {
        ApiClass clz;
        if (this.mData != null) {
            int classNumber = this.findClass(className);
            if (classNumber != -1) {
                int offset = this.seekClassData(classNumber, 3);
                if (offset == -1) {
                    return -1;
                }
                int deprecatedIn = UnsignedBytes.toInt((byte)this.mData[offset]);
                return deprecatedIn != 0 ? deprecatedIn : -1;
            }
        } else if (this.mInfo != null && (clz = this.mInfo.getClass(className)) != null) {
            int deprecatedIn = clz.getDeprecatedIn();
            if (deprecatedIn == Integer.MAX_VALUE) {
                deprecatedIn = -1;
            }
            return deprecatedIn;
        }
        return -1;
    }

    public int getCallVersion(String owner, String name, String desc) {
        ApiClass clz;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int api = this.findMember(classNumber, name, desc);
                if (api == -1) {
                    return this.getClassVersion(classNumber);
                }
                return api;
            }
        } else if (this.mInfo != null && (clz = this.mInfo.getClass(owner)) != null) {
            String signature = name + desc;
            int since = clz.getMethod(signature, this.mInfo);
            if (since == Integer.MAX_VALUE) {
                since = -1;
            }
            return since;
        }
        return -1;
    }

    public int getCallDeprecatedIn(String owner, String name, String desc) {
        ApiClass clz;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int deprecatedIn = this.findMemberDeprecatedIn(classNumber, name, desc);
                return deprecatedIn != 0 ? deprecatedIn : -1;
            }
        } else if (this.mInfo != null && (clz = this.mInfo.getClass(owner)) != null) {
            String signature = name + desc;
            int deprecatedIn = clz.getMemberDeprecatedIn(signature, this.mInfo);
            if (deprecatedIn == Integer.MAX_VALUE) {
                deprecatedIn = -1;
            }
            return deprecatedIn;
        }
        return -1;
    }

    public int getFieldVersion(String owner, String name) {
        ApiClass clz;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int api = this.findMember(classNumber, name, null);
                if (api == -1) {
                    return this.getClassVersion(classNumber);
                }
                return api;
            }
        } else if (this.mInfo != null && (clz = this.mInfo.getClass(owner)) != null) {
            int since = clz.getField(name, this.mInfo);
            if (since == Integer.MAX_VALUE) {
                since = -1;
            }
            return since;
        }
        return -1;
    }

    public int getFieldDeprecatedIn(String owner, String name) {
        ApiClass clz;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int deprecatedIn = this.findMemberDeprecatedIn(classNumber, name, null);
                return deprecatedIn != 0 ? deprecatedIn : -1;
            }
        } else if (this.mInfo != null && (clz = this.mInfo.getClass(owner)) != null) {
            int deprecatedIn = clz.getMemberDeprecatedIn(name, this.mInfo);
            if (deprecatedIn == Integer.MAX_VALUE) {
                deprecatedIn = -1;
            }
            return deprecatedIn;
        }
        return -1;
    }

    public static boolean isRelevantOwner(String owner) {
        if (owner.startsWith("java")) {
            return true;
        }
        if (owner.startsWith("android")) {
            return !owner.startsWith("/support/", 7);
        }
        return owner.startsWith("org/") ? owner.startsWith("xml", 4) || owner.startsWith("w3c/", 4) || owner.startsWith("json/", 4) || owner.startsWith("apache/", 4) : (owner.startsWith("com/") ? owner.startsWith("google/", 4) || owner.startsWith("android/", 4) : owner.startsWith("junit") || owner.startsWith("dalvik"));
    }

    public boolean isValidJavaPackage(String owner) {
        return this.findPackage(owner) != -1;
    }

    private int findPackage(String owner) {
        assert (owner.indexOf(46) == -1) : "Should use / instead of . in owner: " + owner;
        int low = 0;
        int high = this.mPackageCount - 1;
        int classNameLength = owner.lastIndexOf(47);
        while (low <= high) {
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            int compare = ApiLookup.compare(this.mData, offset, (byte)0, owner, 0, classNameLength);
            if (compare == 0) {
                return middle;
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle - 1;
                continue;
            }
            assert (false);
            return -1;
        }
        return -1;
    }

    private static int get4ByteInt(byte[] data, int offset) {
        byte b1 = data[offset++];
        byte b2 = data[offset++];
        byte b3 = data[offset++];
        byte b4 = data[offset];
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    private static void put3ByteInt(ByteBuffer buffer, int value) {
        byte b3 = (byte)(value & 0xFF);
        byte b2 = (byte)((value >>>= 8) & 0xFF);
        byte b1 = (byte)((value >>>= 8) & 0xFF);
        buffer.put(b1);
        buffer.put(b2);
        buffer.put(b3);
    }

    private static void put2ByteInt(ByteBuffer buffer, int value) {
        byte b2 = (byte)(value & 0xFF);
        byte b1 = (byte)((value >>>= 8) & 0xFF);
        buffer.put(b1);
        buffer.put(b2);
    }

    private static int get3ByteInt(byte[] mData, int offset) {
        byte b1 = mData[offset++];
        byte b2 = mData[offset++];
        byte b3 = mData[offset];
        return (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
    }

    private static int get2ByteInt(byte[] data, int offset) {
        byte b1 = data[offset++];
        byte b2 = data[offset];
        return (b1 & 0xFF) << 8 | b2 & 0xFF;
    }

    private int findClass(String owner) {
        assert (owner.indexOf(46) == -1) : "Should use / instead of . in owner: " + owner;
        int packageNumber = this.findPackage(owner);
        if (packageNumber == -1) {
            return -1;
        }
        int curr = this.mIndices[packageNumber];
        while (this.mData[curr] != 0) {
            ++curr;
        }
        int low = ApiLookup.get3ByteInt(this.mData, ++curr);
        int length = ApiLookup.get2ByteInt(this.mData, curr += 3);
        if (length == 0) {
            return -1;
        }
        int high = low + length - 1;
        int index = owner.lastIndexOf(47);
        int classNameLength = owner.length();
        while (low <= high) {
            int compare;
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            if ((compare = ApiLookup.compare(this.mData, ++offset, (byte)0, owner, index + 1, classNameLength)) == 0) {
                return middle;
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle - 1;
                continue;
            }
            assert (false);
            return -1;
        }
        return -1;
    }

    private int findMember(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, false);
    }

    private int findMemberDeprecatedIn(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, true);
    }

    private int seekClassData(int classNumber, int field) {
        int offset = this.mIndices[classNumber];
        offset += this.mData[offset] & 0xFF;
        if (field == 1) {
            return offset;
        }
        offset += 5;
        if (field == 2) {
            return offset;
        }
        boolean hasDeprecation = (this.mData[offset] & 0x80) != 0;
        ++offset;
        if (field == 3) {
            return hasDeprecation ? offset : -1;
        }
        if (hasDeprecation) {
            ++offset;
        }
        assert (field == 4);
        return offset;
    }

    private int findMember(int classNumber, String name, String desc, boolean deprecation) {
        int curr = this.seekClassData(classNumber, 1);
        int low = ApiLookup.get3ByteInt(this.mData, curr);
        int length = ApiLookup.get2ByteInt(this.mData, curr += 3);
        if (length == 0) {
            return -1;
        }
        int high = low + length - 1;
        while (low <= high) {
            int compare;
            int nameLength;
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            if (desc != null) {
                int argsEnd;
                nameLength = name.length();
                compare = ApiLookup.compare(this.mData, offset, (byte)40, name, 0, nameLength);
                if (compare == 0 && (compare = ApiLookup.compare(this.mData, offset += nameLength, (byte)41, desc, 0, argsEnd = desc.indexOf(41))) == 0) {
                    offset += argsEnd + 1;
                    if (this.mData[offset++] == 0) {
                        int api = UnsignedBytes.toInt((byte)this.mData[offset]);
                        if (deprecation) {
                            if ((api & 0x80) != 0) {
                                return UnsignedBytes.toInt((byte)this.mData[offset + 1]);
                            }
                            return -1;
                        }
                        return api & 0xFFFFFF7F;
                    }
                }
            } else {
                nameLength = name.length();
                compare = ApiLookup.compare(this.mData, offset, (byte)0, name, 0, nameLength);
                if (compare == 0) {
                    offset += nameLength;
                    if (this.mData[offset++] == 0) {
                        int api = UnsignedBytes.toInt((byte)this.mData[offset]);
                        if (deprecation) {
                            if ((api & 0x80) != 0) {
                                return UnsignedBytes.toInt((byte)this.mData[offset + 1]);
                            }
                            return -1;
                        }
                        return api & 0xFFFFFF7F;
                    }
                }
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle - 1;
                continue;
            }
            assert (false);
            return -1;
        }
        return -1;
    }

    static void dispose() {
        sInstance.clear();
    }
}

