/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib;

import com.android.assetstudiolib.GraphicGenerator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Map;

public final class AssetStudio {
    public static final String MATERIAL_DESIGN_ICONS_PATH = "images/material_design_icons/";
    private static final Iterable<String> MATERIAL_DESIGN_ICON_CATEGORIES = ImmutableSet.of((Object)"action", (Object)"alert", (Object)"av", (Object)"communication", (Object)"content", (Object)"device", (Object[])new String[]{"editor", "file", "hardware", "image", "maps", "navigation", "notification", "places", "social", "toggle"});

    private AssetStudio() {
    }

    public static String getPathForBasename(String basename) {
        Generator generator = path -> GraphicGenerator.getResourcesNames(path, ".xml");
        return AssetStudio.getBasenameToPathMap(generator).get(basename);
    }

    static Map<String, String> getBasenameToPathMap(Generator generator) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int dotXmlLength = ".xml".length();
        for (String category : MATERIAL_DESIGN_ICON_CATEGORIES) {
            String path = MATERIAL_DESIGN_ICONS_PATH + category + '/';
            Iterator<String> i = generator.getResourceNames(path);
            while (i.hasNext()) {
                String name = i.next();
                builder.put((Object)name.substring(0, name.length() - dotXmlLength), (Object)(path + name));
            }
        }
        return builder.build();
    }

    static interface Generator {
        public Iterator<String> getResourceNames(String var1);
    }
}

