/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.ide.common.util.AssetUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class ActionBarIconGenerator
extends GraphicGenerator {
    @Override
    public BufferedImage generate(GraphicGeneratorContext context, GraphicGenerator.Options options) {
        ActionBarOptions actionBarOptions = (ActionBarOptions)options;
        Rectangle iconSizeMdpi = new Rectangle(0, 0, 32, 32);
        Rectangle targetRectMdpi = actionBarOptions.sourceIsClipart ? new Rectangle(0, 0, 32, 32) : new Rectangle(4, 4, 24, 24);
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        Rectangle imageRect = AssetUtil.scaleRectangle((Rectangle)iconSizeMdpi, (float)scaleFactor);
        Rectangle targetRect = AssetUtil.scaleRectangle((Rectangle)targetRectMdpi, (float)scaleFactor);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g2 = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCenterInside((Graphics2D)g2, (BufferedImage)options.sourceImage, (Rectangle)targetRect);
        if (actionBarOptions.theme == Theme.CUSTOM) {
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(actionBarOptions.customThemeColor), 0.8)});
        } else if (actionBarOptions.theme == Theme.HOLO_LIGHT) {
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(0x333333), 0.6)});
        } else {
            assert (actionBarOptions.theme == Theme.HOLO_DARK);
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(0xFFFFFF), 0.8)});
        }
        g.dispose();
        g2.dispose();
        return outImage;
    }

    public static enum Theme {
        HOLO_DARK,
        HOLO_LIGHT,
        CUSTOM;

    }

    public static class ActionBarOptions
    extends GraphicGenerator.Options {
        public Theme theme = Theme.HOLO_LIGHT;
        public boolean sourceIsClipart = false;
        public int customThemeColor = 0;
    }
}

