/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common.formatter;

import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class BaseAxisFormatter {
    private int mMultiplier;
    private final int mMaxMinorTicks;
    private final int mMaxMajorTicks;
    private final int mSwitchThreshold;

    protected BaseAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        this.mMaxMinorTicks = Math.max(1, maxMinorTicks);
        this.mMaxMajorTicks = Math.max(1, maxMajorTicks);
        this.mSwitchThreshold = switchThreshold;
    }

    @NotNull
    public String getFormattedString(double globalRange, double value) {
        int index = this.getMultiplierIndex(globalRange, 1);
        String unit = this.getUnit(index);
        return String.format("%.2f%s", Float.valueOf((float)value / (float)this.mMultiplier), unit);
    }

    public int getMajorInterval(double range) {
        return this.getInterval(range, this.mMaxMajorTicks);
    }

    public int getMinorInterval(double range) {
        return this.getInterval(range, this.mMaxMinorTicks);
    }

    public int getInterval(double range, int numTicks) {
        int index = this.getMultiplierIndex(range, this.mSwitchThreshold);
        int base = this.getUnitBase(index);
        int minInterval = this.getUnitMinimalInterval(index);
        TIntArrayList factors = this.getUnitBaseFactors(index);
        return BaseAxisFormatter.getInterval(range / (double)this.mMultiplier, numTicks, base, minInterval, factors) * this.mMultiplier;
    }

    protected abstract int getNumUnits();

    @NotNull
    protected abstract String getUnit(int var1);

    protected abstract int getUnitBase(int var1);

    protected abstract int getUnitMultiplier(int var1);

    protected abstract int getUnitMinimalInterval(int var1);

    @NotNull
    protected abstract TIntArrayList getUnitBaseFactors(int var1);

    protected int getMultiplierIndex(double value, int threshold) {
        this.mMultiplier = 1;
        int count = this.getNumUnits();
        for (int i = 0; i < count; ++i) {
            int temp = this.mMultiplier * this.getUnitMultiplier(i);
            if (value <= (double)(temp * threshold)) {
                return i;
            }
            this.mMultiplier = temp;
        }
        return count - 1;
    }

    protected static int getInterval(double range, int maxTicks, int base, int minInterval, TIntArrayList baseFactors) {
        int power;
        int magnitude;
        double interval = Math.max((double)minInterval, range / (double)maxTicks);
        float multiplier = (float)Math.max(1.0, interval / (double)(magnitude = (int)Math.pow(base, power = (int)Math.floor(Math.log(interval) / Math.log(base)))));
        if (multiplier > 1.0f) {
            for (int i = 1; i < baseFactors.size(); ++i) {
                if (!(multiplier > (float)baseFactors.get(i))) continue;
                multiplier = baseFactors.get(i - 1);
                break;
            }
        }
        return (int)multiplier * magnitude;
    }

    @NotNull
    protected static TIntArrayList getMultiplierFactors(int base) {
        TIntArrayList factors = new TIntArrayList();
        while (base > 1) {
            int divider = 2;
            while (base % divider != 0) {
                if (++divider * divider <= base) continue;
                divider = base;
                break;
            }
            factors.add(base);
            base /= divider;
        }
        factors.add(1);
        return factors;
    }

    protected int getMultiplier() {
        return this.mMultiplier;
    }
}

