/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ColumnTreeBuilder {
    @NotNull
    private final JTree myTree;
    @NotNull
    private final ColumnTreeCellRenderer myCellRenderer;
    @NotNull
    private final JTable myTable;
    @NotNull
    private final TableRowSorter<TableModel> myRowSorter;
    @NotNull
    private final DefaultTableModel myTableModel;
    private TreeSorter myTreeSorter;
    @NotNull
    private List<ColumnBuilder> myColumBuilders;

    public ColumnTreeBuilder(@NotNull JTree tree) {
        this.myTree = tree;
        this.myTableModel = new DefaultTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myCellRenderer = new ColumnTreeCellRenderer(this.myTree, this.myTable.getColumnModel());
        this.myRowSorter = new TableRowSorter<TableModel>(this.myTable.getModel());
        this.myColumBuilders = new LinkedList<ColumnBuilder>();
    }

    public ColumnTreeBuilder setTreeSorter(@NotNull TreeSorter sorter) {
        this.myTreeSorter = sorter;
        return this;
    }

    public JComponent build() {
        boolean showsRootHandles = this.myTree.getShowsRootHandles();
        this.myTree.setUI((TreeUI)((Object)new ColumnTreeUI()));
        this.myTree.setShowsRootHandles(showsRootHandles);
        this.myTree.setCellRenderer(this.myCellRenderer);
        this.myTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                ColumnTreeBuilder.this.myTree.revalidate();
                ColumnTreeBuilder.this.myTree.repaint();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.myTable.setRowSorter(this.myRowSorter);
        this.myRowSorter.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent event) {
                if (ColumnTreeBuilder.this.myTreeSorter != null && !ColumnTreeBuilder.this.myRowSorter.getSortKeys().isEmpty()) {
                    RowSorter.SortKey key = ColumnTreeBuilder.this.myRowSorter.getSortKeys().get(0);
                    Comparator<?> comparator = ColumnTreeBuilder.this.myRowSorter.getComparator(key.getColumn());
                    Enumeration<TreePath> expanded = ColumnTreeBuilder.this.myTree.getExpandedDescendants(new TreePath(ColumnTreeBuilder.this.myTree.getModel().getRoot()));
                    comparator = key.getSortOrder() == SortOrder.ASCENDING ? comparator : Collections.reverseOrder(comparator);
                    ColumnTreeBuilder.this.myTreeSorter.sort(comparator, key.getSortOrder());
                    if (expanded != null) {
                        while (expanded.hasMoreElements()) {
                            ColumnTreeBuilder.this.myTree.expandPath(expanded.nextElement());
                        }
                    }
                }
            }
        });
        this.myTable.setAutoResizeMode(1);
        for (ColumnBuilder column : this.myColumBuilders) {
            column.create(this.myTableModel);
        }
        for (ColumnBuilder column : this.myColumBuilders) {
            column.configure(this.myTable, this.myRowSorter, this.myCellRenderer);
        }
        TreeWrapperPanel panel = new TreeWrapperPanel(this.myTable, this.myTree);
        JTableHeader header = this.myTable.getTableHeader();
        header.setReorderingAllowed(false);
        JViewport viewport = new JViewport();
        viewport.setView(header);
        JBScrollPane scrollPane = new JBScrollPane((Component)panel);
        scrollPane.setColumnHeader(viewport);
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    public ColumnTreeBuilder addColumn(ColumnBuilder column) {
        this.myColumBuilders.add(column);
        return this;
    }

    private static class TreeWrapperPanel
    extends JPanel
    implements Scrollable {
        private final JTree myTree;

        public TreeWrapperPanel(JTable table, JTree tree) {
            super(new BorderLayout());
            this.myTree = tree;
            this.add((Component)table, "North");
            this.add((Component)this.myTree, "Center");
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.myTree.getPreferredScrollableViewportSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myTree.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myTree.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.myTree.getScrollableTracksViewportWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.myTree.getScrollableTracksViewportHeight();
        }
    }

    public static class ColumnBuilder {
        private String myName;
        private int myWidth;
        private int myHeaderAlignment;
        private Comparator<?> myComparator;
        private ColoredTreeCellRenderer myRenderer;
        private SortOrder myInitialOrder = SortOrder.UNSORTED;

        public ColumnBuilder setName(String name) {
            this.myName = name;
            return this;
        }

        public ColumnBuilder setPreferredWidth(int width) {
            this.myWidth = width;
            return this;
        }

        public ColumnBuilder setHeaderAlignment(int alignment) {
            this.myHeaderAlignment = alignment;
            return this;
        }

        public void create(DefaultTableModel model) {
            model.addColumn(this.myName);
        }

        public void configure(JTable table, TableRowSorter<TableModel> sorter, ColumnTreeCellRenderer renderer) {
            TableColumn column = table.getColumn(this.myName);
            column.setPreferredWidth(this.myWidth);
            final TableCellRenderer tableCellRenderer = table.getTableHeader().getDefaultRenderer();
            column.setHeaderRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (component instanceof JLabel) {
                        ((JLabel)component).setHorizontalAlignment(myHeaderAlignment);
                    }
                    return component;
                }
            });
            if (this.myComparator != null) {
                sorter.setComparator(column.getModelIndex(), this.myComparator);
                if (this.myInitialOrder != SortOrder.UNSORTED) {
                    sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(column.getModelIndex(), this.myInitialOrder)));
                }
            } else {
                sorter.setSortable(column.getModelIndex(), false);
            }
            assert (this.myRenderer != null);
            renderer.add((Component)this.myRenderer);
        }

        public ColumnBuilder setComparator(@NotNull Comparator<?> comparator) {
            this.myComparator = comparator;
            return this;
        }

        public ColumnBuilder setRenderer(@NotNull ColoredTreeCellRenderer renderer) {
            this.myRenderer = renderer;
            return this;
        }

        public ColumnBuilder setInitialOrder(@NotNull SortOrder initialOrder) {
            this.myInitialOrder = initialOrder;
            return this;
        }
    }

    private static class ColumnTreeUI
    extends WideSelectionTreeUI {
        private int myWidth = -1;

        private ColumnTreeUI() {
        }

        public void paint(Graphics g, JComponent c) {
            if (this.myWidth != c.getWidth()) {
                this.treeState.invalidateSizes();
                this.myWidth = c.getWidth();
            }
            super.paint(g, c);
        }

        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                    dimensions.width = tree.getWidth() - this.getRowX(row, depth);
                    return dimensions;
                }
            };
        }
    }

    private static class ColumnTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        public ColumnTreeCellRenderer(JTree tree, TableColumnModel columnModel) {
            super(new ColumnLayout(tree, columnModel));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setFont(tree.getFont());
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof ColoredTreeCellRenderer)) continue;
                ((ColoredTreeCellRenderer)component).getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Dimension size = this.getComponent(i).getPreferredSize();
                dimension.width += size.width;
                dimension.height = Math.max(dimension.height, size.height);
            }
            return dimension;
        }
    }

    private static class ColumnLayout
    implements LayoutManager {
        @NotNull
        private final TableColumnModel myColumnModel;
        @NotNull
        private final JTree myTree;

        public ColumnLayout(@NotNull JTree tree, @NotNull TableColumnModel columnModel) {
            this.myTree = tree;
            this.myColumnModel = columnModel;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int size = parent.getComponentCount();
            int columns = this.myColumnModel.getColumnCount();
            assert (size == columns);
            int padding = this.myTree.getWidth();
            for (int i = 0; i < size && i < columns; ++i) {
                padding -= this.myColumnModel.getColumn(i).getWidth();
            }
            int offset = parent.getWidth();
            for (int i = size - 1; i >= 0; --i) {
                Component component = parent.getComponent(i);
                TableColumn column = this.myColumnModel.getColumn(i);
                int width = Math.min(column.getWidth() + padding, offset);
                component.setBounds(offset - width, 0, width, parent.getHeight());
                offset -= width;
                padding = 0;
            }
        }
    }

    public static interface TreeSorter<T> {
        public void sort(Comparator<T> var1, SortOrder var2);
    }
}

