/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.EventAction;
import com.android.tools.adtui.model.EventRenderData;
import com.android.tools.adtui.model.RangedSimpleSeries;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;

public class StackedEventComponent
extends AnimatedComponent {
    private static final Color DISABLED_ACTION = new Color(137, 157, 179);
    private static final Color ENABLED_ACTION = new Color(93, 185, 98);
    private static final int CHARACTERS_TO_SHRINK_BY = 1;
    private static final int TAIL_HEIGHT = 4;
    private static final int SEGMENT_SPACING = 4;
    private static final int NORMALIZED_END = 1;
    private static final float EPSILON = 0.99f;
    @NotNull
    private final RangedSimpleSeries<EventAction<Action, String>> mData;
    @NotNull
    private final ArrayList<Shape> mPaths;
    private final int myMaxHeight;
    private HashMap<EventAction<Action, String>, EventRenderData> myActionToDrawLocationMap = new HashMap();

    public StackedEventComponent(int maxHeight, @NotNull RangedSimpleSeries<EventAction<Action, String>> data) {
        this.mData = data;
        this.myMaxHeight = maxHeight;
        this.mPaths = new ArrayList();
    }

    @Override
    protected void updateData() {
        double tailHeight;
        double baseHeight;
        double normalizedstartPosition;
        double normalizedEndPosition;
        Path2D.Float path;
        double min = this.mData.getRange().getMin();
        double max = this.mData.getRange().getMax();
        HashMap<Long, EventAction<Action, String>> downEvents = new HashMap<Long, EventAction<Action, String>>();
        HashMap<Long, Integer> drawOrderIndex = new HashMap<Long, Integer>();
        PriorityQueue<Integer> offsetValues = new PriorityQueue<Integer>();
        this.mPaths.clear();
        this.myActionToDrawLocationMap.clear();
        int lastIndex = 0;
        EventAction<Action, String> lastStart = null;
        int lastStartIndex = 0;
        for (int i = 0; i < this.mData.getSeries().size(); ++i) {
            EventAction<Action, String> data = this.mData.getSeries().get(i);
            if (!drawOrderIndex.containsKey(data.getStart())) {
                int index = lastIndex++;
                if (offsetValues.size() != 0) {
                    index = (Integer)offsetValues.remove();
                }
                drawOrderIndex.put(data.getStart(), index);
                if (lastStart == null) {
                    lastStart = data;
                    lastStartIndex = index;
                } else if (index >= lastStartIndex) {
                    this.myActionToDrawLocationMap.put(lastStart, new EventRenderData(lastStartIndex, data.getStart() - lastStart.getStart()));
                    lastStart = data;
                    lastStartIndex = index;
                }
            }
            if (data.getValue() == Action.ACTIVITY_STARTED) {
                downEvents.put(data.getStart(), data);
                continue;
            }
            if (data.getValue() != Action.ACTIVITY_COMPLETED) continue;
            assert (downEvents.containsKey(data.getStart()));
            EventAction event = (EventAction)downEvents.get(data.getStart());
            int index = (Integer)drawOrderIndex.get(event.getStart());
            drawOrderIndex.remove(event.getStart());
            offsetValues.add(index);
            path = new Path2D.Float();
            normalizedEndPosition = ((double)data.getEnd() - min) / (max - min);
            normalizedstartPosition = ((double)event.getStart() - min) / (max - min);
            baseHeight = this.myMaxHeight - index * 4;
            tailHeight = this.myMaxHeight - (index * 4 - 4);
            path.moveTo(normalizedEndPosition, baseHeight);
            path.lineTo(normalizedEndPosition, tailHeight);
            path.lineTo(normalizedstartPosition, tailHeight);
            path.lineTo(normalizedstartPosition, baseHeight);
            this.mPaths.add(path);
            if (lastStart != null && index == lastStartIndex) {
                this.myActionToDrawLocationMap.put(lastStart, new EventRenderData(lastStartIndex, data.getEnd() - lastStart.getStart()));
                lastStart = null;
                lastStartIndex = 0;
            }
            downEvents.remove(data.getStart());
        }
        if (lastStart != null) {
            this.myActionToDrawLocationMap.put(lastStart, new EventRenderData(lastStartIndex, (long)max - lastStart.getStart()));
            lastStart = null;
            lastStartIndex = 0;
        }
        for (Long key : downEvents.keySet()) {
            EventAction event = (EventAction)downEvents.get(key);
            int offset = (Integer)drawOrderIndex.get(key);
            path = new Path2D.Float();
            normalizedEndPosition = 1.0;
            normalizedstartPosition = ((double)event.getStart() - min) / (max - min);
            baseHeight = this.myMaxHeight - offset * 4;
            tailHeight = this.myMaxHeight - (offset * 4 - 4);
            path.moveTo(normalizedEndPosition, baseHeight);
            path.lineTo(normalizedEndPosition, tailHeight);
            path.lineTo(normalizedstartPosition, tailHeight);
            path.lineTo(normalizedstartPosition, baseHeight);
            this.mPaths.add(path);
        }
    }

    @Override
    protected void draw(Graphics2D g2d) {
        Dimension dim = this.getSize();
        int scaleFactor = dim.width;
        double min = this.mData.getRange().getMin();
        double max = this.mData.getRange().getMax();
        Stroke current = g2d.getStroke();
        BasicStroke str = new BasicStroke(2.0f);
        g2d.setStroke(str);
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, 1.0);
        for (int i = 0; i < this.mPaths.size(); ++i) {
            double maxX = this.mPaths.get(i).getBounds2D().getMaxX() * (double)scaleFactor;
            if (maxX <= (double)((float)scaleFactor - 0.99f)) {
                g2d.setColor(DISABLED_ACTION);
            } else {
                g2d.setColor(ENABLED_ACTION);
            }
            Shape shape = scale.createTransformedShape(this.mPaths.get(i));
            g2d.draw(shape);
        }
        g2d.setStroke(current);
        g2d.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        FontMetrics metrics = g2d.getFontMetrics();
        for (EventAction<Action, String> event : this.myActionToDrawLocationMap.keySet()) {
            EventRenderData positionData = this.myActionToDrawLocationMap.get(event);
            int offset = positionData.getIndex();
            String text = event.getValueData();
            int width = metrics.stringWidth(text);
            double normalizedStartPosition = ((double)event.getStart() - min) / (max - min);
            double normalizedEndPosition = ((double)(event.getStart() + positionData.getTimestamp()) - min) / (max - min);
            float startPosition = (float)normalizedStartPosition * (float)scaleFactor;
            float endPosition = (float)normalizedEndPosition * (float)scaleFactor;
            boolean ellipsis = true;
            if (startPosition < 0.0f && endPosition > 0.0f) {
                startPosition = (float)width < endPosition ? 0.0f : endPosition - (float)width;
                ellipsis = false;
            }
            if (ellipsis && (text = AdtUiUtils.getFittedString(metrics, text, endPosition - startPosition, 1)).isEmpty()) continue;
            if (endPosition <= (float)scaleFactor - 0.99f) {
                g2d.setColor(DISABLED_ACTION);
            } else {
                g2d.setColor(ENABLED_ACTION);
            }
            g2d.drawString(text, startPosition, (float)(this.myMaxHeight - offset * 4));
        }
    }

    @Override
    protected void debugDraw(Graphics2D g) {
        super.debugDraw(g);
    }

    public static enum Action {
        ACTIVITY_STARTED,
        ACTIVITY_COMPLETED;

    }
}

