/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Range;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;

public final class RangeScrollbar
extends JBScrollBar
implements Animatable {
    private static final float STREAMING_POSITION_THRESHOLD = 0.1f;
    @NotNull
    private ScrollingMode mScrollingMode;
    private boolean mStableScrolling;
    @NotNull
    private final Range mGlobalRange;
    @NotNull
    private final Range mRange;

    public RangeScrollbar(@NotNull Range globalRange, @NotNull Range range) {
        super(0);
        this.mGlobalRange = globalRange;
        this.mRange = range;
        this.mScrollingMode = ScrollingMode.STREAMING;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RangeScrollbar.this.mScrollingMode = ScrollingMode.SCROLLING;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RangeScrollbar.this.mScrollingMode = RangeScrollbar.this.closeToMaxRange() ? ScrollingMode.STREAMING : ScrollingMode.VIEWING;
            }
        });
    }

    public void setStableScrolling(boolean fixedScrolling) {
        this.mStableScrolling = fixedScrolling;
    }

    public void updateUI() {
        this.setUI((ScrollBarUI)((Object)new RangeScrollBarUI()));
    }

    @Override
    public void reset() {
        this.mScrollingMode = ScrollingMode.STREAMING;
        double now = this.mGlobalRange.getMax();
        this.mGlobalRange.setMin(now);
        this.mRange.set(now, now);
    }

    @Override
    public void animate(float frameLength) {
        if (this.mScrollingMode == ScrollingMode.STREAMING && !this.mRange.setMax(this.mGlobalRange.getMax())) {
            this.mScrollingMode = ScrollingMode.VIEWING;
        }
        double globalLength = this.mGlobalRange.getLength();
        double currentLength = this.mRange.getLength();
        int scrollbarExtent = this.getWidth();
        int scrollbarRange = (int)(globalLength * (double)scrollbarExtent / currentLength);
        switch (this.mScrollingMode) {
            case STREAMING: {
                this.setValues(scrollbarRange - scrollbarExtent, scrollbarExtent, 0, scrollbarRange);
                break;
            }
            case VIEWING: {
                this.setValues((int)((double)scrollbarRange * (this.mRange.getMin() - this.mGlobalRange.getMin()) / globalLength), scrollbarExtent, 0, scrollbarRange);
                break;
            }
            case SCROLLING: {
                float adjustedValue;
                if (!this.mStableScrolling) {
                    this.setMaximum(scrollbarRange);
                }
                if (Float.isNaN(adjustedValue = (float)this.getValue() / (float)(this.getMaximum() - scrollbarExtent) * (float)(scrollbarRange - scrollbarExtent))) {
                    adjustedValue = 0.0f;
                }
                double newMin = globalLength * (double)adjustedValue / (double)scrollbarRange + this.mGlobalRange.getMin();
                this.mRange.set(newMin, newMin + currentLength);
                this.mRange.lockValues();
            }
        }
    }

    private boolean closeToMaxRange() {
        BoundedRangeModel model = this.getModel();
        return (float)(model.getMaximum() - (model.getValue() + model.getExtent())) < 0.1f * (float)model.getExtent();
    }

    private static class RangeScrollBarUI
    extends ButtonlessScrollBarUI {
        private RangeScrollBarUI() {
        }

        protected boolean isMacOverlayScrollbar() {
            return false;
        }
    }

    private static enum ScrollingMode {
        STREAMING,
        VIEWING,
        SCROLLING;

    }
}

