/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Choreographer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class AccordionLayout
implements LayoutManager2,
Animatable {
    private static final float DEFAULT_LERP_FRACTION = 0.9999f;
    private static final float DEFAULT_LERP_THRESHOLD_PIXEL = 1.0f;
    @NotNull
    private final HashMap<Component, ComponentInfo> mComponentInfoMap;
    @NotNull
    private final TreeSet<ComponentInfo> mComponentInfoSet;
    @NotNull
    private final Orientation mOrientation;
    @NotNull
    private final Container mParent;
    private float mMaxTotal;
    private float mPreferredTotal;
    private float mPreoccupiedSpace;
    private float mLerpFraction;
    private float mLerpThreshold;

    public AccordionLayout(@NotNull Container parent, @NotNull Orientation orientation) {
        this.mParent = parent;
        this.mOrientation = orientation;
        this.mComponentInfoMap = new HashMap();
        this.mComponentInfoSet = new TreeSet();
        this.mLerpFraction = 0.9999f;
        this.mLerpThreshold = 1.0f;
    }

    @Override
    public void setLerpFraction(float fraction) {
        this.mLerpFraction = fraction;
    }

    @Override
    public void setLerpThreshold(float threshold) {
        this.mLerpThreshold = threshold;
    }

    public AccordionState getState(@NotNull Component comp) {
        assert (this.mComponentInfoMap.containsKey(comp));
        return this.mComponentInfoMap.get((Object)comp).state;
    }

    public void setState(@NotNull Component comp, @NotNull AccordionState state) {
        assert (this.mComponentInfoMap.containsKey(comp));
        ComponentInfo info = this.mComponentInfoMap.get(comp);
        if (info.state != state) {
            this.setStateInternal(comp, info, state);
        }
    }

    private void setStateInternal(@NotNull Component comp, @NotNull ComponentInfo info, @NotNull AccordionState state) {
        this.mComponentInfoSet.remove(info);
        info.state = state;
        if (state == AccordionState.MINIMIZE) {
            info.currentSize = this.mOrientation == Orientation.VERTICAL ? (float)comp.getHeight() : (float)comp.getWidth();
        }
        this.mComponentInfoSet.add(info);
    }

    public void toggleMaximize(@NotNull Component comp) {
        assert (this.mComponentInfoMap.containsKey(comp));
        ComponentInfo info = this.mComponentInfoMap.get(comp);
        this.setStateInternal(comp, info, info.state == AccordionState.MAXIMIZE ? AccordionState.PREFERRED : AccordionState.MAXIMIZE);
    }

    public void toggleMinimize(@NotNull Component comp) {
        assert (this.mComponentInfoMap.containsKey(comp));
        ComponentInfo info = this.mComponentInfoMap.get(comp);
        this.setStateInternal(comp, info, info.state == AccordionState.MINIMIZE ? AccordionState.PREFERRED : AccordionState.MINIMIZE);
    }

    public void resetComponents() {
        for (Component comp : this.mComponentInfoMap.keySet()) {
            this.setState(comp, AccordionState.PREFERRED);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        ComponentInfo info = new ComponentInfo(comp, 0.0f, AccordionState.PREFERRED);
        this.mComponentInfoMap.put(comp, info);
        this.mComponentInfoSet.add(info);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        ComponentInfo info = new ComponentInfo(comp, 0.0f, AccordionState.PREFERRED);
        this.mComponentInfoMap.put(comp, info);
        this.mComponentInfoSet.add(info);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        assert (this.mComponentInfoMap.containsKey(comp));
        ComponentInfo info = this.mComponentInfoMap.get(comp);
        this.mComponentInfoMap.remove(comp);
        this.mComponentInfoSet.remove(info);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        throw new NotImplementedException();
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        throw new NotImplementedException();
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateSizes(parent, AccordionState.MINIMIZE);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateSizes(parent, AccordionState.PREFERRED);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.calculateSizes(parent, AccordionState.MAXIMIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int maxWidth = parent.getWidth() - (insets.left + insets.right);
        int maxHeight = parent.getHeight() - (insets.top + insets.bottom);
        int remainingSpace = this.mOrientation == Orientation.VERTICAL ? maxHeight : maxWidth;
        HashMap<Component, Float> clampedComponents = new HashMap<Component, Float>();
        HashMap<Component, Point> layoutInfos = new HashMap<Component, Point>();
        float totalUsedSpace = 0.0f;
        float otherStatesPreoccupiedSpace = 0.0f;
        float currentStateUsedSpace = 0.0f;
        float currentStateFixedSpace = 0.0f;
        float currentStateFluidSpace = 0.0f;
        int currentStateStartIndex = -1;
        AccordionState currentState = null;
        Component componentToFill = null;
        ArrayList<ComponentInfo> infos = new ArrayList<ComponentInfo>(this.mComponentInfoSet);
        block19: for (int i = 0; i < infos.size(); ++i) {
            Float size;
            ComponentInfo info = (ComponentInfo)infos.get(i);
            if (currentState != info.state) {
                currentState = info.state;
                currentStateStartIndex = i;
                totalUsedSpace += currentStateUsedSpace;
                currentStateUsedSpace = 0.0f;
                currentStateFixedSpace = 0.0f;
                switch (currentState) {
                    case MAXIMIZE: {
                        otherStatesPreoccupiedSpace = this.mPreoccupiedSpace;
                        currentStateFluidSpace = this.mMaxTotal;
                        break;
                    }
                    case PREFERRED: {
                        otherStatesPreoccupiedSpace = 0.0f;
                        currentStateFluidSpace = this.mPreferredTotal;
                        break;
                    }
                }
            }
            if ((size = (Float)clampedComponents.get(info.component)) == null) {
                if (info.state == AccordionState.MINIMIZE) {
                    size = Float.valueOf(info.currentSize);
                } else {
                    float fluidSpace = this.mOrientation == Orientation.VERTICAL ? (float)maxHeight - (totalUsedSpace + otherStatesPreoccupiedSpace + currentStateFixedSpace) : (float)maxWidth - (totalUsedSpace + otherStatesPreoccupiedSpace + currentStateFixedSpace);
                    size = Float.valueOf(fluidSpace * info.currentSize / currentStateFluidSpace);
                    float clampedSize = this.clampSize(info.component, size.floatValue());
                    if (clampedSize != size.floatValue()) {
                        clampedComponents.put(info.component, Float.valueOf(clampedSize));
                        currentStateFluidSpace -= info.currentSize;
                        currentStateFixedSpace += clampedSize;
                        currentStateUsedSpace = 0.0f;
                        i = currentStateStartIndex - 1;
                        continue;
                    }
                    if (componentToFill == null) {
                        componentToFill = info.component;
                    }
                }
            } else if (info.component == componentToFill) {
                componentToFill = null;
            }
            currentStateUsedSpace += size.floatValue();
            switch (this.mOrientation) {
                case HORIZONTAL: {
                    if (layoutInfos.containsKey(info.component)) {
                        remainingSpace += ((Point)layoutInfos.get((Object)info.component)).x;
                    }
                    int width = Math.round(size.floatValue());
                    layoutInfos.put(info.component, new Point(width, maxHeight));
                    remainingSpace -= width;
                    continue block19;
                }
                case VERTICAL: {
                    if (layoutInfos.containsKey(info.component)) {
                        remainingSpace += ((Point)layoutInfos.get((Object)info.component)).y;
                    }
                    int height = Math.round(size.floatValue());
                    layoutInfos.put(info.component, new Point(maxWidth, height));
                    remainingSpace -= height;
                }
            }
        }
        int currX = insets.left;
        int currY = insets.top;
        Object object = parent.getTreeLock();
        synchronized (object) {
            block20: for (Component comp : parent.getComponents()) {
                Point size = (Point)layoutInfos.get(comp);
                if (componentToFill == comp) {
                    switch (this.mOrientation) {
                        case HORIZONTAL: {
                            size.x += remainingSpace;
                            break;
                        }
                        case VERTICAL: {
                            size.y += remainingSpace;
                        }
                    }
                }
                comp.setBounds(currX, currY, size.x, size.y);
                switch (this.mOrientation) {
                    case HORIZONTAL: {
                        currX += size.x;
                        continue block20;
                    }
                    case VERTICAL: {
                        currY += size.y;
                    }
                }
            }
        }
    }

    @Override
    public void animate(float frameLength) {
        boolean hasMaximizedComponents = false;
        this.mPreferredTotal = 0.0f;
        this.mMaxTotal = 0.0f;
        this.mPreoccupiedSpace = 0.0f;
        for (ComponentInfo info : this.mComponentInfoSet) {
            float minSize = 0.0f;
            float maxSize = 0.0f;
            float preferredSize = 0.0f;
            float targetSize = 0.0f;
            float currentSize = 0.0f;
            switch (this.mOrientation) {
                case HORIZONTAL: {
                    minSize = info.component.getMinimumSize().width;
                    maxSize = info.component.getMaximumSize().width;
                    preferredSize = info.component.getPreferredSize().width;
                    currentSize = info.component.getSize().width;
                    break;
                }
                case VERTICAL: {
                    minSize = info.component.getMinimumSize().height;
                    maxSize = info.component.getMaximumSize().height;
                    preferredSize = info.component.getPreferredSize().height;
                    currentSize = info.component.getSize().height;
                }
            }
            switch (info.state) {
                case MINIMIZE: {
                    targetSize = minSize;
                    break;
                }
                case MAXIMIZE: {
                    targetSize = maxSize;
                    hasMaximizedComponents = true;
                    break;
                }
                case PREFERRED: {
                    targetSize = preferredSize;
                }
            }
            if (info.currentSize != targetSize) {
                info.currentSize = Choreographer.lerp(info.currentSize, targetSize, this.mLerpFraction, frameLength, this.mLerpThreshold);
            }
            if (currentSize != minSize) {
                currentSize = Choreographer.lerp(currentSize, minSize, this.mLerpFraction, frameLength, this.mLerpThreshold);
            }
            switch (info.state) {
                case MINIMIZE: {
                    this.mPreoccupiedSpace += currentSize;
                    break;
                }
                case MAXIMIZE: {
                    this.mMaxTotal += info.currentSize;
                    break;
                }
                case PREFERRED: {
                    this.mPreferredTotal += info.currentSize;
                    if (!hasMaximizedComponents) break;
                    this.mPreoccupiedSpace += currentSize;
                }
            }
        }
        this.mParent.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension calculateSizes(Container parent, AccordionState state) {
        Dimension dim = new Dimension();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension childSize = new Dimension();
            block12: for (Component child : parent.getComponents()) {
                switch (state) {
                    case MINIMIZE: {
                        childSize = child.getMinimumSize();
                        break;
                    }
                    case MAXIMIZE: {
                        childSize = child.getMaximumSize();
                        break;
                    }
                    case PREFERRED: {
                        childSize = child.getPreferredSize();
                    }
                }
                switch (this.mOrientation) {
                    case HORIZONTAL: {
                        dim.width += childSize.width;
                        dim.height = Math.max(dim.height, childSize.height);
                        continue block12;
                    }
                    case VERTICAL: {
                        dim.width = Math.max(dim.width, childSize.width);
                        dim.height += childSize.height;
                    }
                }
            }
        }
        Insets insets = parent.getInsets();
        int insetWidth = insets.left + insets.right;
        int insetHeight = insets.top + insets.bottom;
        dim.width += insetWidth;
        dim.height += insetHeight;
        return dim;
    }

    private float clampSize(Component c, float preferred) {
        return this.mOrientation == Orientation.VERTICAL ? Math.min((float)c.getMaximumSize().height, Math.max((float)c.getMinimumSize().height, preferred)) : Math.min((float)c.getMaximumSize().width, Math.max((float)c.getMinimumSize().width, preferred));
    }

    private static class ComponentInfo
    implements Comparable<ComponentInfo> {
        Component component;
        float currentSize;
        AccordionState state;

        ComponentInfo(Component component, float size, AccordionState state) {
            this.component = component;
            this.currentSize = size;
            this.state = state;
        }

        @Override
        public int compareTo(ComponentInfo other) {
            int ret = this.state.compareTo(other.state);
            if (ret == 0) {
                ret = this.component.hashCode() - other.component.hashCode();
            }
            return ret;
        }
    }

    public static enum AccordionState {
        MAXIMIZE,
        MINIMIZE,
        PREFERRED;

    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

