/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.java.decompiler.code.ExceptionHandler;
import org.jetbrains.java.decompiler.code.ExceptionTable;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.interpreter.Util;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public abstract class InstructionSequence {
    protected final VBStyleCollection<Instruction, Integer> collinstr;
    protected int pointer = 0;
    protected ExceptionTable exceptionTable = ExceptionTable.EMPTY;

    protected InstructionSequence() {
        this(new VBStyleCollection<Instruction, Integer>());
    }

    protected InstructionSequence(VBStyleCollection<Instruction, Integer> collinstr) {
        this.collinstr = collinstr;
    }

    public InstructionSequence clone() {
        return null;
    }

    public void clear() {
        this.collinstr.clear();
        this.pointer = 0;
        this.exceptionTable = ExceptionTable.EMPTY;
    }

    public void addInstruction(Instruction inst, int offset) {
        this.collinstr.addWithKey(inst, offset);
    }

    public void addInstruction(int index, Instruction inst, int offset) {
        this.collinstr.addWithKeyAndIndex(index, inst, offset);
    }

    public void addSequence(InstructionSequence seq) {
        for (int i = 0; i < seq.length(); ++i) {
            this.addInstruction(seq.getInstr(i), -1);
        }
    }

    public void removeInstruction(int index) {
        this.collinstr.remove(index);
    }

    public void removeLast() {
        if (!this.collinstr.isEmpty()) {
            this.collinstr.remove(this.collinstr.size() - 1);
        }
    }

    public Instruction getCurrentInstr() {
        return (Instruction)this.collinstr.get(this.pointer);
    }

    public Instruction getInstr(int index) {
        return (Instruction)this.collinstr.get(index);
    }

    public Instruction getLastInstr() {
        return this.collinstr.getLast();
    }

    public int getCurrentOffset() {
        return this.collinstr.getKey(this.pointer);
    }

    public int getOffset(int index) {
        return this.collinstr.getKey(index);
    }

    public int getPointerByAbsOffset(int offset) {
        Integer absoffset = new Integer(offset);
        if (this.collinstr.containsKey(absoffset)) {
            return this.collinstr.getIndexByKey(absoffset);
        }
        return -1;
    }

    public int getPointerByRelOffset(int offset) {
        Integer absoffset = new Integer(this.collinstr.getKey(this.pointer) + offset);
        if (this.collinstr.containsKey(absoffset)) {
            return this.collinstr.getIndexByKey(absoffset);
        }
        return -1;
    }

    public void setPointerByAbsOffset(int offset) {
        Integer absoffset = new Integer(this.collinstr.getKey(this.pointer) + offset);
        if (this.collinstr.containsKey(absoffset)) {
            this.pointer = this.collinstr.getIndexByKey(absoffset);
        }
    }

    public int length() {
        return this.collinstr.size();
    }

    public boolean isEmpty() {
        return this.collinstr.isEmpty();
    }

    public void addToPointer(int diff) {
        this.pointer += diff;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.collinstr.size(); ++i) {
            buf.append(InterpreterUtil.getIndentString(indent));
            buf.append(this.collinstr.getKey(i));
            buf.append(": ");
            buf.append(((Instruction)this.collinstr.get(i)).toString());
            buf.append(new_line_separator);
        }
        return buf.toString();
    }

    public void writeCodeToStream(DataOutputStream out) throws IOException {
        for (int i = 0; i < this.collinstr.size(); ++i) {
            ((Instruction)this.collinstr.get(i)).writeToStream(out, this.collinstr.getKey(i));
        }
    }

    public void writeExceptionsToStream(DataOutputStream out) throws IOException {
        List<ExceptionHandler> handlers = this.exceptionTable.getHandlers();
        out.writeShort(handlers.size());
        for (int i = 0; i < handlers.size(); ++i) {
            handlers.get(i).writeToStream(out);
        }
    }

    public void sortHandlers(final StructContext context) {
        Collections.sort(this.exceptionTable.getHandlers(), new Comparator<ExceptionHandler>(){

            @Override
            public int compare(ExceptionHandler handler0, ExceptionHandler handler1) {
                if (handler0.to == handler1.to) {
                    if (handler0.exceptionClass == null) {
                        return 1;
                    }
                    if (handler1.exceptionClass == null) {
                        return -1;
                    }
                    if (handler0.exceptionClass.equals(handler1.exceptionClass)) {
                        return handler0.from > handler1.from ? -1 : 1;
                    }
                    if (Util.instanceOf(context, handler0.exceptionClass, handler1.exceptionClass)) {
                        return -1;
                    }
                    return 1;
                }
                return handler0.to > handler1.to ? 1 : -1;
            }
        });
    }

    public int getPointer() {
        return this.pointer;
    }

    public void setPointer(int pointer) {
        this.pointer = pointer;
    }

    public ExceptionTable getExceptionTable() {
        return this.exceptionTable;
    }

    public void setExceptionTable(ExceptionTable exceptionTable) {
        this.exceptionTable = exceptionTable;
    }
}

