/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.AppResourceRepository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalResourceManager
extends ResourceManager {
    private AttributeDefinitions myAttrDefs;
    protected final AndroidFacet myFacet;

    public LocalResourceManager(@NotNull AndroidFacet facet) {
        super(facet.getModule().getProject());
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    @NotNull
    public VirtualFile[] getAllResourceDirs() {
        Set<VirtualFile> result = AppResourceRepository.getAppResources(this.myFacet, true).getResourceDirs();
        return VfsUtilCore.toVirtualFileArray(result);
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        for (VirtualFile resDir : this.getResourceDirs()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile dir1 : this.getResourceOverlayDirs()) {
            if (!dir.equals(dir1)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<VirtualFile> getResourceDirs() {
        return this.myFacet.getAllResourceDirectories();
    }

    public List<Pair<Resources, VirtualFile>> getResourceElements() {
        return this.getResourceElements(null);
    }

    @Override
    @NotNull
    public VirtualFile[] getResourceOverlayDirs() {
        return AndroidRootUtil.getResourceOverlayDirs(this.getFacet());
    }

    @NotNull
    public List<ResourceElement> getValueResources(@NotNull ResourceType resourceType) {
        return this.getValueResources(resourceType, null);
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? facet.getLocalResourceManager() : null;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull PsiElement element) {
        AndroidFacet facet = AndroidFacet.getInstance(element);
        return facet != null ? facet.getLocalResourceManager() : null;
    }

    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        if (this.myAttrDefs == null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ArrayList<XmlFile> xmlResFiles = new ArrayList<XmlFile>();
                    for (PsiFile file : LocalResourceManager.this.findResourceFiles("values")) {
                        if (!(file instanceof XmlFile)) continue;
                        xmlResFiles.add((XmlFile)file);
                    }
                    LocalResourceManager.this.myAttrDefs = new AttributeDefinitionsImpl(xmlResFiles.toArray(new XmlFile[xmlResFiles.size()]));
                }
            });
        }
        return this.myAttrDefs;
    }

    public void invalidateAttributeDefinitions() {
        this.myAttrDefs = null;
    }

    @NotNull
    public List<Attr> findAttrs(@NotNull String name) {
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (Attr attr : res.getAttrs()) {
                if (!name.equals(attr.getName().getValue())) continue;
                list.add(attr);
            }
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                for (Attr attr : styleable.getAttrs()) {
                    if (!name.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    public List<DeclareStyleable> findStyleables(@NotNull String name) {
        ArrayList<DeclareStyleable> list = new ArrayList<DeclareStyleable>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!name.equals(styleable.getName().getValue())) continue;
                list.add(styleable);
            }
        }
        return list;
    }

    public List<Attr> findStyleableAttributesByFieldName(@NotNull String fieldName) {
        int prev;
        int index = fieldName.lastIndexOf(95);
        while (index != -1 && (prev = fieldName.lastIndexOf(95, index - 1)) != -1 && !Character.isUpperCase(fieldName.charAt(prev + 1))) {
            index = prev;
        }
        if (index == -1) {
            return Collections.emptyList();
        }
        String styleableName = fieldName.substring(0, index);
        String attrName = fieldName.substring(index + 1);
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!styleableName.equals(styleable.getName().getValue())) continue;
                for (Attr attr : styleable.getAttrs()) {
                    if (!attrName.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByField(@NotNull PsiField field) {
        String type = AndroidResourceUtil.getResourceClassName(field);
        if (type == null) {
            return Collections.emptyList();
        }
        String fieldName = field.getName();
        if (fieldName == null) {
            return Collections.emptyList();
        }
        return this.findResourcesByFieldName(type, fieldName);
    }

    @NotNull
    public List<PsiElement> findResourcesByFieldName(@NotNull String resClassName, @NotNull String fieldName) {
        ArrayList<PsiElement> targets;
        block7: {
            block6: {
                targets = new ArrayList<PsiElement>();
                if (resClassName.equals(ResourceType.ID.getName())) {
                    targets.addAll(this.findIdDeclarations(fieldName));
                }
                for (PsiFile file : this.findResourceFiles(resClassName, fieldName, false, new String[0])) {
                    targets.add((PsiElement)file);
                }
                for (ResourceElement element : this.findValueResources(resClassName, fieldName, false)) {
                    targets.add((PsiElement)element.getName().getXmlAttributeValue());
                }
                if (!resClassName.equals(ResourceType.ATTR.getName())) break block6;
                for (Attr attr : this.findAttrs(fieldName)) {
                    targets.add((PsiElement)attr.getName().getXmlAttributeValue());
                }
                break block7;
            }
            if (!resClassName.equals(ResourceType.STYLEABLE.getName())) break block7;
            for (DeclareStyleable styleable : this.findStyleables(fieldName)) {
                targets.add((PsiElement)styleable.getName().getXmlAttributeValue());
            }
            for (Attr attr : this.findStyleableAttributesByFieldName(fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        }
        return targets;
    }

    @Override
    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType resourceType, boolean publicOnly) {
        AppResourceRepository appResources = AppResourceRepository.getAppResources(this.myFacet, true);
        Collection<Object> resourceNames = resourceType == ResourceType.STYLEABLE ? appResources.getItemsOfType(ResourceType.DECLARE_STYLEABLE) : appResources.getItemsOfType(resourceType);
        if (publicOnly || resourceType == ResourceType.ATTR) {
            HashSet filtered = ContainerUtil.newHashSet((int)resourceNames.size());
            for (String name : resourceNames) {
                if (resourceType == ResourceType.ATTR && !name.startsWith("android:")) {
                    filtered.add(name);
                }
                if (!publicOnly || appResources.isPrivate(resourceType, name)) continue;
                filtered.add(name);
            }
            resourceNames = filtered;
        }
        return resourceNames;
    }
}

