/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidBaseXmlRefactoringAction;
import org.jetbrains.android.refactoring.AndroidFindStyleApplicationsDialog;
import org.jetbrains.android.refactoring.AndroidFindStyleApplicationsProcessor;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.ProjectBasedErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindStyleApplicationsAction
extends AndroidBaseXmlRefactoringAction {
    private final MyTestConfig myTestConfig;

    public AndroidFindStyleApplicationsAction() {
        this(null);
    }

    public AndroidFindStyleApplicationsAction(@Nullable MyTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        if (tags.length != 1) {
            return false;
        }
        MyStyleData data = AndroidFindStyleApplicationsAction.getStyleData(tags[0]);
        return data != null && data.getStyle().getItems().size() > 0;
    }

    @Override
    protected boolean isMyFile(PsiFile file) {
        return DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file) instanceof ResourcesDomFileDescription;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        assert (tags.length == 1);
        XmlTag tag = tags[0];
        MyStyleData styleData = AndroidFindStyleApplicationsAction.getStyleData(tag);
        assert (styleData != null);
        AndroidFindStyleApplicationsAction.doRefactoringForTag(tag, styleData, null, this.myTestConfig);
    }

    static void doRefactoringForTag(XmlTag tag, MyStyleData styleData, @Nullable PsiFile context, MyTestConfig testConfig) {
        boolean showModuleRadio;
        VirtualFile contextVFile;
        AndroidFindStyleApplicationsProcessor processor = AndroidFindStyleApplicationsAction.createFindStyleApplicationsProcessor(tag, styleData, context);
        if (processor == null) {
            return;
        }
        Module module = styleData.getFacet().getModule();
        VirtualFile virtualFile = contextVFile = context != null ? context.getVirtualFile() : null;
        if (testConfig != null) {
            processor.configureScope(testConfig.getScope(), contextVFile);
            processor.run();
            return;
        }
        processor.setPreviewUsages(true);
        boolean bl = showModuleRadio = AndroidFindStyleApplicationsProcessor.getAllModulesToScan(module).size() > 1;
        if (showModuleRadio || contextVFile != null) {
            AndroidFindStyleApplicationsDialog dialog = new AndroidFindStyleApplicationsDialog(contextVFile, processor, showModuleRadio);
            dialog.show();
        } else {
            processor.run();
        }
    }

    public static AndroidFindStyleApplicationsProcessor createFindStyleApplicationsProcessor(XmlTag tag, MyStyleData styleData, PsiFile context) {
        ProjectBasedErrorReporter errorReporter = new ProjectBasedErrorReporter(tag.getProject());
        Style style = styleData.getStyle();
        Map<AndroidAttributeInfo, String> attrMap = AndroidRefactoringUtil.computeAttributeMap(style, new ProjectBasedErrorReporter(tag.getProject()), AndroidBundle.message("android.find.style.applications.title", new Object[0]));
        if (attrMap == null || attrMap.size() == 0) {
            return null;
        }
        AndroidFacet facet = styleData.getFacet();
        StyleRefData parentStyleRef = AndroidRefactoringUtil.getParentStyle(style);
        PsiElement parentStyleAttrName = null;
        if (parentStyleRef != null && (parentStyleAttrName = AndroidFindStyleApplicationsAction.resolveStyleRef(parentStyleRef, facet)) == null) {
            errorReporter.report("Cannot resolve parent style '" + parentStyleRef.getStyleName() + "'", AndroidBundle.message("android.find.style.applications.title", new Object[0]));
            return null;
        }
        return new AndroidFindStyleApplicationsProcessor(styleData.getFacet().getModule(), attrMap, styleData.getName(), tag, styleData.getNameAttrValue(), parentStyleAttrName, context);
    }

    private static PsiElement resolveStyleRef(StyleRefData styleRef, AndroidFacet facet) {
        ResourceManager resourceManager = facet.getResourceManager(styleRef.getStylePackage());
        if (resourceManager == null) {
            return null;
        }
        List<ValueResourceInfoImpl> infos = resourceManager.findValueResourceInfos(ResourceType.STYLE.getName(), styleRef.getStyleName(), true, false);
        return infos.size() == 1 ? infos.get(0).computeXmlElement() : null;
    }

    @Nullable
    static MyStyleData getStyleData(@NotNull XmlTag tag) {
        DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (!(element instanceof Style)) {
            return null;
        }
        Style style = (Style)element;
        GenericAttributeValue<String> styleNameDomAttr = style.getName();
        String styleName = styleNameDomAttr.getStringValue();
        XmlAttributeValue styleNameAttrValue = styleNameDomAttr.getXmlAttributeValue();
        if (styleName == null || styleName.length() == 0 || styleNameAttrValue == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
        if (facet == null) {
            return null;
        }
        return new MyStyleData(style, styleName, facet, styleNameAttrValue);
    }

    static class MyTestConfig {
        private final AndroidFindStyleApplicationsProcessor.MyScope myScope;

        MyTestConfig(@NotNull AndroidFindStyleApplicationsProcessor.MyScope scope) {
            this.myScope = scope;
        }

        @NotNull
        public AndroidFindStyleApplicationsProcessor.MyScope getScope() {
            return this.myScope;
        }
    }

    static class MyStyleData {
        private final Style myStyle;
        private final String myName;
        private final XmlAttributeValue myNameAttrValue;
        private final AndroidFacet myFacet;

        private MyStyleData(@NotNull Style style, @NotNull String name, @NotNull AndroidFacet facet, @NotNull XmlAttributeValue nameAttrValue) {
            this.myStyle = style;
            this.myName = name;
            this.myFacet = facet;
            this.myNameAttrValue = nameAttrValue;
        }

        @NotNull
        public Style getStyle() {
            return this.myStyle;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public AndroidFacet getFacet() {
            return this.myFacet;
        }

        @NotNull
        public XmlAttributeValue getNameAttrValue() {
            return this.myNameAttrValue;
        }
    }
}

