/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidExtractAsIncludeAction
extends AndroidBaseLayoutRefactoringAction {
    @NonNls
    public static final String ACTION_ID = "AndroidExtractAsIncludeAction";
    private final MyTestConfig myTestConfig;

    public AndroidExtractAsIncludeAction() {
        this.myTestConfig = null;
    }

    public AndroidExtractAsIncludeAction(@Nullable MyTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        if (tags.length == 0) {
            return;
        }
        PsiFile file = tags[0].getContainingFile();
        if (file == null) {
            return;
        }
        XmlTag startTag = null;
        XmlTag endTag = null;
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        for (XmlTag tag : tags) {
            int end;
            TextRange range = tag.getTextRange();
            int start = range.getStartOffset();
            if (start < startOffset) {
                startOffset = start;
                startTag = tag;
            }
            if ((end = range.getEndOffset()) <= endOffset) continue;
            endOffset = end;
            endTag = tag;
        }
        assert (startTag != null && endTag != null);
        this.doRefactorForPsiRange(project, file, (PsiElement)startTag, (PsiElement)endTag);
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        if (tags.length == 0) {
            return false;
        }
        DomManager domManager = DomManager.getDomManager((Project)tags[0].getProject());
        boolean containsViewElement = false;
        for (XmlTag tag : tags) {
            DomElement domElement = domManager.getDomElement(tag);
            if (!AndroidExtractAsIncludeAction.isSuitableDomElement(domElement)) {
                return false;
            }
            if (!(domElement instanceof LayoutViewElement)) continue;
            containsViewElement = true;
        }
        if (!containsViewElement) {
            return false;
        }
        PsiElement parent = tags[0].getParent();
        if (!(parent instanceof XmlTag) || parent.getContainingFile() == null) {
            return false;
        }
        for (int i = 1; i < tags.length; ++i) {
            if (tags[i].getParent() == parent) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doRefactorForPsiRange(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement from, @NotNull PsiElement to) {
        PsiDirectory dir = file.getContainingDirectory();
        if (dir == null) {
            return;
        }
        final AndroidFacet facet = AndroidFacet.getInstance(from);
        assert (facet != null);
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)from, XmlTag.class);
        assert (parentTag != null);
        List<XmlTag> tagsInRange = AndroidExtractAsIncludeAction.collectAllTags(from, to);
        assert (tagsInRange.size() > 0) : "there is no tag inside the range";
        final String fileName = this.myTestConfig != null ? this.myTestConfig.myLayoutFileName : null;
        String dirName = dir.getName();
        final FolderConfiguration config = dirName.length() > 0 ? FolderConfiguration.getConfig((String[])dirName.split("-")) : null;
        String title = "Extract Android Layout";
        AsyncResult dataContextAsyncResult = DataManager.getInstance().getDataContextFromFocus();
        dataContextAsyncResult.doWhenDone(dataContext -> CommandProcessor.getInstance().executeCommand(project, new Runnable((DataContext)dataContext, file, from, to, parentTag, tagsInRange){
            final /* synthetic */ DataContext val$dataContext;
            final /* synthetic */ PsiFile val$cap$4;
            final /* synthetic */ PsiElement val$cap$5;
            final /* synthetic */ PsiElement val$cap$6;
            final /* synthetic */ XmlTag val$cap$7;
            final /* synthetic */ List val$cap$8;
            {
                this.val$dataContext = dataContext;
                this.val$cap$4 = psiFile;
                this.val$cap$5 = psiElement;
                this.val$cap$6 = psiElement2;
                this.val$cap$7 = xmlTag;
                this.val$cap$8 = list;
            }

            @Override
            public void run() {
                final XmlFile newFile = CreateResourceFileAction.createFileResource(facet, ResourceFolderType.LAYOUT, fileName, "temp_root", config, true, "Extract Android Layout", null, this.val$dataContext);
                if (newFile != null) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            AndroidExtractAsIncludeAction.doRefactor(facet, val$cap$4, newFile, val$cap$5, val$cap$6, val$cap$7, val$cap$8.size() > 1);
                        }
                    });
                }
            }
        }, "Extract Android Layout", null, UndoConfirmationPolicy.REQUEST_CONFIRMATION));
    }

    private static void doRefactor(AndroidFacet facet, PsiFile file, XmlFile newFile, PsiElement from, PsiElement to, XmlTag parentTag, boolean wrapWithMerge) {
        Project project = facet.getModule().getProject();
        String textToExtract = file.getText().substring(from.getTextRange().getStartOffset(), to.getTextRange().getEndOffset());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument((PsiFile)newFile);
        assert (document != null);
        document.setText((CharSequence)("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + (wrapWithMerge ? "<merge>\n" + textToExtract + "\n</merge>" : textToExtract)));
        documentManager.commitDocument(document);
        HashSet unknownPrefixes = new HashSet();
        newFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((Set)unknownPrefixes){
            final /* synthetic */ Set val$unknownPrefixes;
            {
                this.val$unknownPrefixes = set;
            }

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                String prefix = tag.getNamespacePrefix();
                if (!this.val$unknownPrefixes.contains(prefix) && tag.getNamespace().length() == 0) {
                    this.val$unknownPrefixes.add(prefix);
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                String prefix = attribute.getNamespacePrefix();
                if (!this.val$unknownPrefixes.contains(prefix) && attribute.getNamespace().length() == 0) {
                    this.val$unknownPrefixes.add(prefix);
                }
            }
        });
        XmlTag rootTag = newFile.getRootTag();
        assert (rootTag != null);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute firstAttribute = attributes.length > 0 ? attributes[0] : null;
        for (String prefix : unknownPrefixes) {
            String namespace = parentTag.getNamespaceByPrefix(prefix);
            String xmlNsAttrName = "xmlns:" + prefix;
            if (namespace.length() <= 0 || rootTag.getAttribute(xmlNsAttrName) != null) continue;
            XmlAttribute xmlnsAttr = elementFactory.createXmlAttribute(xmlNsAttrName, namespace);
            if (firstAttribute != null) {
                rootTag.addBefore((PsiElement)xmlnsAttr, (PsiElement)firstAttribute);
                continue;
            }
            rootTag.add((PsiElement)xmlnsAttr);
        }
        String includingLayout = "@layout/" + ResourceHelper.getResourceName(file);
        IncludeReference.setIncludingLayout(project, newFile, includingLayout);
        String resourceName = AndroidCommonUtils.getResourceName((String)ResourceType.LAYOUT.getName(), (String)newFile.getName());
        XmlTag includeTag = elementFactory.createTagFromText((CharSequence)("<include layout=\"@layout/" + resourceName + "\"/>"));
        parentTag.addAfter((PsiElement)includeTag, to);
        parentTag.deleteChildRange(from, to);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat((PsiElement)newFile);
    }

    @NotNull
    private static List<XmlTag> collectAllTags(PsiElement from, PsiElement to) {
        PsiElement e;
        ArrayList<XmlTag> result = new ArrayList<XmlTag>();
        for (e = from; e != null; e = e.getNextSibling()) {
            if (e instanceof XmlTag) {
                result.add((XmlTag)e);
            }
            if (e == to) break;
        }
        assert (e != null) : "invalid range";
        return result;
    }

    @Override
    protected boolean isEnabledForPsiRange(@NotNull PsiElement from, @Nullable PsiElement to) {
        DomManager domManager = DomManager.getDomManager((Project)from.getProject());
        boolean containsViewElement = false;
        for (PsiElement e = from; e != null; e = e.getNextSibling()) {
            if (e instanceof XmlTag) {
                DomElement domElement = domManager.getDomElement((XmlTag)e);
                if (!AndroidExtractAsIncludeAction.isSuitableDomElement(domElement)) {
                    return false;
                }
                if (domElement instanceof LayoutViewElement) {
                    containsViewElement = true;
                }
            }
            if (e == to) break;
        }
        return containsViewElement;
    }

    private static boolean isSuitableDomElement(DomElement element) {
        return element instanceof LayoutViewElement || element instanceof Include;
    }

    static class MyTestConfig {
        private final String myLayoutFileName;

        MyTestConfig(@NotNull String layoutFileName) {
            this.myLayoutFileName = layoutFileName;
        }
    }
}

