/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AndroidBaseXmlRefactoringAction
extends BaseRefactoringAction {
    AndroidBaseXmlRefactoringAction() {
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        XmlTag[] tags = AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(context);
        if (tags.length > 0) {
            return AndroidFacet.getInstance((PsiElement)tags[0]) != null && this.isEnabledForTags(tags);
        }
        TextRange range = AndroidBaseXmlRefactoringAction.getNonEmptySelectionRange(editor);
        if (range != null) {
            Pair<PsiElement, PsiElement> psiRange = AndroidBaseXmlRefactoringAction.getExtractableRange(file, range.getStartOffset(), range.getEndOffset());
            return psiRange != null && this.isEnabledForPsiRange((PsiElement)psiRange.getFirst(), (PsiElement)psiRange.getSecond());
        }
        if (element == null || AndroidFacet.getInstance(element) == null || PsiTreeUtil.getParentOfType((PsiElement)element, XmlText.class) != null) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        return tag != null && this.isEnabledForTags(new XmlTag[]{tag});
    }

    @Nullable
    private static TextRange getNonEmptySelectionRange(Editor editor) {
        int end;
        int start;
        SelectionModel model;
        if (editor != null && (model = editor.getSelectionModel()).hasSelection() && (start = model.getSelectionStart()) < (end = model.getSelectionEnd())) {
            return TextRange.create((int)start, (int)end);
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, PsiElement> getExtractableRange(PsiFile file, int start, int end) {
        PsiElement e;
        PsiElement parent;
        PsiElement startElement = file.findElementAt(start);
        PsiElement psiElement = parent = startElement != null ? startElement.getParent() : null;
        while (parent != null && !(parent instanceof PsiFile) && parent.getTextRange().getStartOffset() == startElement.getTextRange().getStartOffset()) {
            startElement = parent;
            parent = parent.getParent();
        }
        PsiElement endElement = file.findElementAt(end - 1);
        PsiElement psiElement2 = parent = endElement != null ? endElement.getParent() : null;
        while (parent != null && !(parent instanceof PsiFile) && parent.getTextRange().getEndOffset() == endElement.getTextRange().getEndOffset()) {
            endElement = parent;
            parent = parent.getParent();
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        PsiElement commonParent = startElement.getParent();
        if (commonParent == null || !(commonParent instanceof XmlTag) || commonParent != endElement.getParent()) {
            return null;
        }
        boolean containTag = false;
        for (e = startElement; e != null; e = e.getNextSibling()) {
            if (!(e instanceof XmlText || e instanceof XmlTag || e instanceof PsiWhiteSpace || e instanceof PsiComment)) {
                return null;
            }
            if (e instanceof XmlTag) {
                containTag = true;
            }
            if (e == endElement) break;
        }
        return e != null && containTag ? Pair.create((Object)startElement, (Object)endElement) : null;
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements.length == 0) {
            return false;
        }
        PsiElement element = elements[0];
        if (AndroidFacet.getInstance(element) == null) {
            return false;
        }
        XmlTag[] tags = new XmlTag[elements.length];
        for (int i = 0; i < tags.length; ++i) {
            if (!(elements[i] instanceof XmlTag)) {
                return false;
            }
            tags[i] = (XmlTag)elements[i];
        }
        return this.isEnabledForTags(tags);
    }

    protected abstract boolean isEnabledForTags(@NotNull XmlTag[] var1);

    protected boolean isEnabledForPsiRange(@NotNull PsiElement from, @Nullable PsiElement to) {
        return false;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language == XMLLanguage.INSTANCE;
    }

    protected boolean isAvailableForFile(PsiFile file) {
        return file instanceof XmlFile && AndroidFacet.getInstance((PsiElement)file) != null && this.isMyFile(file);
    }

    protected abstract boolean isMyFile(PsiFile var1);

    public void update(AnActionEvent e) {
        final DataContext context = e.getDataContext();
        DataContext patchedContext = new DataContext(){

            public Object getData(@NonNls String dataId) {
                Object data = context.getData(dataId);
                if (data != null) {
                    return data;
                }
                if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                    XmlTag[] tags = AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(context);
                    return tags.length == 1 ? tags[0] : null;
                }
                if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                    return AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(context);
                }
                return null;
            }
        };
        super.update(new AnActionEvent(e.getInputEvent(), patchedContext, e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers()));
    }

    protected abstract void doRefactorForTags(@NotNull Project var1, @NotNull XmlTag[] var2);

    protected void doRefactorForPsiRange(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement from, @NotNull PsiElement to) {
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        XmlTag[] componentTags = AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(dataContext);
        return new MyHandler(componentTags);
    }

    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    @NotNull
    protected static XmlTag[] getXmlTagsFromExternalContext(DataContext dataContext) {
        PsiElement[] data = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (data instanceof XmlTag[]) {
            return (XmlTag[])data;
        }
        return XmlTag.EMPTY;
    }

    private class MyHandler
    implements RefactoringActionHandler {
        private final XmlTag[] myTagsFromExternalContext;

        private MyHandler(XmlTag[] tagsFromExternalContext) {
            this.myTagsFromExternalContext = tagsFromExternalContext;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
            if (this.myTagsFromExternalContext.length > 0) {
                AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, this.myTagsFromExternalContext);
                return;
            }
            TextRange range = AndroidBaseXmlRefactoringAction.getNonEmptySelectionRange(editor);
            if (range != null) {
                Pair psiRange = AndroidBaseXmlRefactoringAction.getExtractableRange(file, range.getStartOffset(), range.getEndOffset());
                if (psiRange != null) {
                    AndroidBaseXmlRefactoringAction.this.doRefactorForPsiRange(project, file, (PsiElement)psiRange.getFirst(), (PsiElement)psiRange.getSecond());
                }
                return;
            }
            PsiElement element = BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)file);
            if (element == null) {
                return;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag == null) {
                return;
            }
            AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, new XmlTag[]{tag});
        }

        public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
            if (this.myTagsFromExternalContext.length > 0) {
                AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, this.myTagsFromExternalContext);
                return;
            }
            if (elements.length != 1) {
                return;
            }
            PsiElement element = elements[0];
            if (!(element instanceof XmlTag)) {
                return;
            }
            AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, new XmlTag[]{(XmlTag)element});
        }
    }
}

