/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.detector.api.Issue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.annotations.NotNull;

public class State {
    private final Module myModule;
    private final VirtualFile myMainFile;
    private final String myMainFileContent;
    private final List<ProblemData> myProblems = new ArrayList<ProblemData>();
    private final List<Issue> myIssues;
    private volatile boolean myDirty;

    State(@NotNull Module module, @NotNull VirtualFile mainFile, @NotNull String mainFileContent, @NotNull List<Issue> issues) {
        this.myModule = module;
        this.myMainFile = mainFile;
        this.myMainFileContent = mainFileContent;
        this.myIssues = issues;
    }

    @NotNull
    public VirtualFile getMainFile() {
        return this.myMainFile;
    }

    @NotNull
    public String getMainFileContent() {
        return this.myMainFileContent;
    }

    public void markDirty() {
        this.myDirty = true;
    }

    public boolean isDirty() {
        return this.myDirty;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public List<ProblemData> getProblems() {
        return this.myProblems;
    }

    @NotNull
    public List<Issue> getIssues() {
        return this.myIssues;
    }
}

