/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import javax.swing.JComponent;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.annotations.NotNull;

class ShowCustomIssueExplanationFix
implements AndroidLintQuickFix {
    private final PsiElement myElement;
    private final Issue myIssue;

    public static AndroidLintQuickFix[] getFixes(@NotNull PsiElement element, @NotNull String message) {
        Issue issue = IntellijLintClient.findCustomIssue(message);
        if (issue != null) {
            return new AndroidLintQuickFix[]{new ShowCustomIssueExplanationFix(element, issue)};
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    private ShowCustomIssueExplanationFix(@NotNull PsiElement element, @NotNull Issue issue) {
        this.myElement = element;
        this.myIssue = issue;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Project project = this.myElement.getProject();
        DocumentationManager manager = DocumentationManager.getInstance((Project)project);
        DocumentationComponent component = new DocumentationComponent(manager);
        component.setText("<html>" + this.myIssue.getExplanation(TextFormat.HTML) + "</html>", this.myElement, false);
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, (JComponent)component).setDimensionServiceKey(project, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).createPopup();
        component.setHint(popup);
        if (context.getType() == AndroidQuickfixContexts.EditorContext.TYPE) {
            popup.showInBestPositionFor(((AndroidQuickfixContexts.EditorContext)context).getEditor());
        } else {
            popup.showCenteredInCurrentWindow(project);
        }
        Disposer.dispose((Disposable)component);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "Show Full Explanation";
    }
}

