/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.ast.Catch;
import lombok.ast.Node;
import lombok.ast.Position;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;
import org.jetbrains.android.inspections.lint.LombokPsiConverter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LombokPsiParser
extends JavaParser {
    private final LintClient myClient;
    private final JavaEvaluator myJavaEvaluator;
    private AccessToken myLock;

    public LombokPsiParser(LintClient client, Project project) {
        this.myClient = client;
        this.myJavaEvaluator = new MyJavaEvaluator(project);
    }

    public void prepareJavaParse(List<JavaContext> contexts) {
    }

    public Node parseJava(JavaContext context) {
        assert (this.myLock == null);
        this.myLock = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            Node node = this.parse(context);
            if (node != null) {
                return node;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.myLock.finish();
        this.myLock = null;
        return null;
    }

    public JavaEvaluator getEvaluator() {
        return this.myJavaEvaluator;
    }

    public PsiJavaFile parseJavaToPsi(JavaContext context) {
        PsiFile psiFile = IntellijLintUtils.getPsiFile((Context)context);
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        return (PsiJavaFile)psiFile;
    }

    public void dispose(JavaContext context, Node compilationUnit) {
        if (context.getCompilationUnit() != null) {
            context.setCompilationUnit(null);
        }
        if (this.myLock != null) {
            this.myLock.finish();
            this.myLock = null;
        }
    }

    private Node parse(JavaContext context) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        PsiFile psiFile = IntellijLintUtils.getPsiFile((Context)context);
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        try {
            return LombokPsiConverter.convert(javaFile);
        }
        catch (ProcessCanceledException ignore) {
            context.getDriver().cancel();
            return null;
        }
        catch (Throwable t) {
            this.myClient.log(t, "Failed converting PSI parse tree to Lombok for file %1$s", new Object[]{context.file.getPath()});
            return null;
        }
    }

    public Location getLocation(JavaContext context, Node node) {
        Position position = node.getPosition();
        if (position == null) {
            this.myClient.log(Severity.WARNING, null, "No position data found for node %1$s", new Object[]{node});
            return Location.create((File)context.file);
        }
        return Location.create((File)context.file, null, (int)position.getStart(), (int)position.getEnd());
    }

    public Location getLocation(JavaContext context, PsiElement element) {
        TextRange range = element.getTextRange();
        PsiFile containingFile = element.getContainingFile();
        File file = context.file;
        if (containingFile != context.getJavaFile()) {
            if (context.getDriver().getScope().size() == 1) {
                return Location.NONE;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile != null) {
                file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            } else {
                return Location.NONE;
            }
        }
        return Location.create((File)file, null, (int)range.getStartOffset(), (int)range.getEndOffset());
    }

    public Location getRangeLocation(JavaContext context, Node from, int fromDelta, Node to, int toDelta) {
        Position position1 = from.getPosition();
        Position position2 = to.getPosition();
        if (position1 == null) {
            return this.getLocation(context, to);
        }
        if (position2 == null) {
            return this.getLocation(context, from);
        }
        int start = Math.max(0, from.getPosition().getStart() + fromDelta);
        int end = to.getPosition().getEnd() + toDelta;
        return Location.create((File)context.file, null, (int)start, (int)end);
    }

    public Location getRangeLocation(JavaContext context, PsiElement from, int fromDelta, PsiElement to, int toDelta) {
        int start = Math.max(0, from.getTextRange().getStartOffset() + fromDelta);
        int end = to.getTextRange().getEndOffset() + toDelta;
        return Location.create((File)context.file, null, (int)start, (int)end);
    }

    public Location.Handle createLocationHandle(JavaContext context, Node node) {
        return new LocationHandle(context.file, node);
    }

    private static PsiElement getPsiElement(Node node) {
        Object nativeNode = node.getNativeNode();
        if (nativeNode == null) {
            return null;
        }
        return (PsiElement)nativeNode;
    }

    public JavaParser.ResolvedNode resolve(JavaContext context, Node node) {
        final PsiElement element = LombokPsiParser.getPsiElement(node);
        if (element == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            return LombokPsiParser.resolve(element);
        }
        return (JavaParser.ResolvedNode)application.runReadAction((Computable)new Computable<JavaParser.ResolvedNode>(){

            public JavaParser.ResolvedNode compute() {
                return LombokPsiParser.resolve(element);
            }
        });
    }

    public JavaParser.ResolvedClass findClass(JavaContext context, final String fullyQualifiedName) {
        Node compilationUnit = context.getCompilationUnit();
        if (compilationUnit == null) {
            return null;
        }
        final PsiElement element = LombokPsiParser.getPsiElement(compilationUnit);
        if (element == null) {
            return null;
        }
        return (JavaParser.ResolvedClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JavaParser.ResolvedClass>(){

            public JavaParser.ResolvedClass compute() {
                PsiClass aClass = JavaPsiFacade.getInstance((Project)element.getProject()).findClass(fullyQualifiedName, element.getResolveScope());
                if (aClass != null) {
                    return new ResolvedPsiClass(aClass);
                }
                return null;
            }
        });
    }

    public List<JavaParser.TypeDescriptor> getCatchTypes(JavaContext context, Catch catchBlock) {
        PsiCatchSection node;
        PsiType type;
        Object nativeNode = catchBlock.getNativeNode();
        if (nativeNode instanceof PsiCatchSection && (type = (node = (PsiCatchSection)nativeNode).getCatchType()) != null) {
            if (type instanceof PsiDisjunctionType) {
                List disjunctions = ((PsiDisjunctionType)type).getDisjunctions();
                ArrayList list = Lists.newArrayListWithCapacity((int)disjunctions.size());
                for (PsiType t : disjunctions) {
                    list.add(new PsiTypeDescriptor(t));
                }
                return list;
            }
            return Collections.singletonList(new PsiTypeDescriptor(type));
        }
        return super.getCatchTypes(context, catchBlock);
    }

    public JavaParser.TypeDescriptor getType(JavaContext context, Node node) {
        final PsiElement element = LombokPsiParser.getPsiElement(node);
        if (element == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            return LombokPsiParser.getTypeDescriptor(element);
        }
        return (JavaParser.TypeDescriptor)application.runReadAction((Computable)new Computable<JavaParser.TypeDescriptor>(){

            public JavaParser.TypeDescriptor compute() {
                return LombokPsiParser.getTypeDescriptor(element);
            }
        });
    }

    public void runReadAction(Runnable runnable) {
        ApplicationManager.getApplication().runReadAction(runnable);
    }

    static JavaParser.ResolvedNode resolve(PsiElement element) {
        PsiElement resolved;
        if (element instanceof PsiCall) {
            PsiMethod resolved2 = ((PsiCall)element).resolveMethod();
            if (resolved2 != null) {
                return new ResolvedPsiMethod(resolved2);
            }
            return null;
        }
        PsiReference reference = element.getReference();
        if (reference != null && (resolved = reference.resolve()) != null) {
            element = resolved;
        }
        if (element instanceof PsiField) {
            return new ResolvedPsiField((PsiField)element);
        }
        if (element instanceof PsiMethod) {
            return new ResolvedPsiMethod((PsiMethod)element);
        }
        if (element instanceof PsiVariable) {
            return new ResolvedPsiVariable((PsiVariable)element);
        }
        if (element instanceof PsiClass) {
            return new ResolvedPsiClass((PsiClass)element);
        }
        if (element instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement r = (PsiJavaCodeReferenceElement)element;
            String qualifiedName = r.getQualifiedName();
            if (qualifiedName != null) {
                return new ResolvedPsiClassName(element.getManager(), qualifiedName);
            }
        } else if (element instanceof PsiAnnotation) {
            return new ResolvedPsiAnnotation((PsiAnnotation)element);
        }
        return null;
    }

    private static JavaParser.TypeDescriptor getTypeDescriptor(PsiElement element) {
        PsiType type = null;
        if (element instanceof PsiExpression) {
            type = ((PsiExpression)element).getType();
        } else if (element instanceof PsiVariable) {
            type = ((PsiVariable)element).getType();
        } else if (element instanceof PsiMethod) {
            type = ((PsiMethod)element).getReturnType();
        } else if (element instanceof PsiAnnotation) {
            final PsiAnnotation annotation = (PsiAnnotation)element;
            return new JavaParser.DefaultTypeDescriptor(annotation.getQualifiedName()){

                public JavaParser.ResolvedClass getTypeClass() {
                    GlobalSearchScope resolveScope = annotation.getResolveScope();
                    if (resolveScope.getProject() != null) {
                        ApplicationManager.getApplication().assertReadAccessAllowed();
                        PsiClass aClass = JavaPsiFacade.getInstance((Project)resolveScope.getProject()).findClass(this.getSignature(), resolveScope);
                        if (aClass != null) {
                            return new ResolvedPsiClass(aClass);
                        }
                    }
                    return null;
                }
            };
        }
        return LombokPsiParser.getTypeDescriptor(type);
    }

    @Contract(value="!null -> !null")
    private static JavaParser.TypeDescriptor getTypeDescriptor(PsiType type) {
        return type != null ? new PsiTypeDescriptor(type) : null;
    }

    private static int computeModifiers(PsiModifierListOwner owner) {
        int modifiers = 0;
        if (owner != null) {
            if (owner.hasModifierProperty("abstract")) {
                modifiers |= 0x400;
            }
            if (owner.hasModifierProperty("public")) {
                modifiers |= 1;
            }
            if (owner.hasModifierProperty("static")) {
                modifiers |= 8;
            }
            if (owner.hasModifierProperty("private")) {
                modifiers |= 2;
            }
            if (owner.hasModifierProperty("protected")) {
                modifiers |= 4;
            }
            if (owner.hasModifierProperty("final")) {
                modifiers |= 0x10;
            }
        }
        return modifiers;
    }

    private static Iterable<JavaParser.ResolvedAnnotation> getAnnotations(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiAnnotation[] annotations;
            PsiModifierList modifierList = owner.getModifierList();
            if (modifierList != null && (annotations = modifierList.getAnnotations()).length > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)annotations.length);
                for (PsiAnnotation method : annotations) {
                    result.add(new ResolvedPsiAnnotation(method));
                }
                return result;
            }
            ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)owner.getProject());
            PsiAnnotation[] annotations2 = annotationsManager.findExternalAnnotations(owner);
            if (annotations2 != null) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)annotations2.length);
                for (PsiAnnotation method : annotations2) {
                    result.add(new ResolvedPsiAnnotation(method));
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    static boolean isInPackage(PsiClass cls, String pkg, boolean includeSubPackages) {
        if (cls != null) {
            PsiClass outer = cls.getContainingClass();
            while (outer != null) {
                cls = outer;
                outer = cls.getContainingClass();
            }
            String qualifiedName = cls.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            if (!qualifiedName.startsWith(pkg)) {
                return false;
            }
            if (!includeSubPackages) {
                return qualifiedName.length() - cls.getName().length() - 1 == pkg.length();
            }
            return qualifiedName.length() == pkg.length() || qualifiedName.charAt(pkg.length()) == '.';
        }
        return false;
    }

    @NotNull
    public static JavaParser.ResolvedAnnotation createResolvedAnnotation(PsiAnnotation annotation) {
        return new ResolvedPsiAnnotation(annotation);
    }

    private static class ResolvedPsiPackage
    extends JavaParser.ResolvedPackage {
        private PsiPackage myPackage;

        public ResolvedPsiPackage(PsiPackage pkg) {
            this.myPackage = pkg;
        }

        public String getName() {
            return this.myPackage.getQualifiedName();
        }

        public String getSignature() {
            return this.getName();
        }

        public int getModifiers() {
            return 0;
        }

        public ResolvedPsiPackage getParentPackage() {
            PsiPackage parentPackage = this.myPackage.getParentPackage();
            if (parentPackage != null) {
                return new ResolvedPsiPackage(parentPackage);
            }
            return null;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return LombokPsiParser.getAnnotations((PsiModifierListOwner)this.myPackage);
        }
    }

    private static class ResolvedPsiAnnotation
    extends JavaParser.ResolvedAnnotation {
        private PsiAnnotation myAnnotation;

        private ResolvedPsiAnnotation(PsiAnnotation annotation) {
            this.myAnnotation = annotation;
        }

        public String getName() {
            String qualifiedName = this.myAnnotation.getQualifiedName();
            if (qualifiedName == null) {
                return "?";
            }
            return qualifiedName;
        }

        public boolean matches(String name) {
            return name.equals(this.getName());
        }

        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = LombokPsiParser.getTypeDescriptor((PsiElement)this.myAnnotation);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public JavaParser.ResolvedClass getClassType() {
            PsiElement element;
            PsiJavaCodeReferenceElement reference = this.myAnnotation.getNameReferenceElement();
            if (reference != null && (element = reference.resolve()) instanceof PsiClass) {
                return new ResolvedPsiClass((PsiClass)element);
            }
            return null;
        }

        public List<JavaParser.ResolvedAnnotation.Value> getValues() {
            PsiNameValuePair[] attributes = this.myAnnotation.getParameterList().getAttributes();
            if (attributes.length > 0) {
                ArrayList values = Lists.newArrayListWithExpectedSize((int)attributes.length);
                for (PsiNameValuePair pair : attributes) {
                    String name = pair.getName();
                    if (name == null) {
                        name = "value";
                    }
                    values.add(new JavaParser.ResolvedAnnotation.Value(name, ResolvedPsiAnnotation.getAnnotationPairValue(pair)));
                }
                return values;
            }
            return Collections.emptyList();
        }

        public Object getValue(String name) {
            PsiNameValuePair[] attributes = this.myAnnotation.getParameterList().getAttributes();
            if (attributes.length > 0) {
                for (PsiNameValuePair pair : attributes) {
                    String pairName = pair.getName();
                    if (!name.equals(pairName) && (pairName != null || !name.equals("value"))) continue;
                    return ResolvedPsiAnnotation.getAnnotationPairValue(pair);
                }
            }
            return null;
        }

        private static Object getAnnotationPairValue(PsiNameValuePair pair) {
            PsiAnnotationMemberValue v = pair.getValue();
            if (v instanceof PsiLiteral) {
                PsiLiteral literal = (PsiLiteral)v;
                return literal.getValue();
            }
            if (v instanceof PsiArrayInitializerMemberValue) {
                PsiElement resolved;
                PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                PsiAnnotationMemberValue[] values = mv.getInitializers();
                ArrayList list = Lists.newArrayListWithExpectedSize((int)values.length);
                boolean fields = false;
                for (PsiAnnotationMemberValue mmv : values) {
                    PsiElement resolved2;
                    PsiElement resolved3;
                    if (mmv instanceof PsiLiteral) {
                        PsiLiteral literal = (PsiLiteral)mmv;
                        list.add(literal.getValue());
                        continue;
                    }
                    if (!(mmv instanceof PsiExpression)) continue;
                    if (mmv instanceof PsiReferenceExpression && (resolved3 = ((PsiReferenceExpression)mmv).resolve()) instanceof PsiField) {
                        list.add(new ResolvedPsiField((PsiField)resolved3));
                        fields = true;
                        continue;
                    }
                    Object o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)mmv), (boolean)false);
                    if (o == null && mmv instanceof PsiReferenceExpression && (resolved2 = ((PsiReferenceExpression)mmv).resolve()) instanceof PsiField) {
                        o = new ResolvedPsiField((PsiField)resolved2);
                    }
                    list.add(o);
                }
                if (fields) {
                    return list.toArray();
                }
                PsiReference reference = pair.getReference();
                if (reference != null && (resolved = reference.resolve()) instanceof PsiAnnotationMethod) {
                    PsiType returnType = ((PsiAnnotationMethod)resolved).getReturnType();
                    if (returnType != null) {
                        returnType = returnType.getDeepComponentType();
                    }
                    if (returnType != null && returnType.getCanonicalText().equals("java.lang.String")) {
                        return list.toArray(new String[list.size()]);
                    }
                    if (returnType != null && returnType.getCanonicalText().equals("java.lang.annotation.Annotation")) {
                        return list.toArray(new Annotation[list.size()]);
                    }
                    if (PsiType.INT.equals((Object)returnType)) {
                        return list.toArray(new Integer[list.size()]);
                    }
                    if (PsiType.LONG.equals((Object)returnType)) {
                        return list.toArray(new Long[list.size()]);
                    }
                    if (PsiType.DOUBLE.equals((Object)returnType)) {
                        return list.toArray(new Double[list.size()]);
                    }
                    if (PsiType.FLOAT.equals((Object)returnType)) {
                        return list.toArray(new Float[list.size()]);
                    }
                }
                if (!list.isEmpty()) {
                    Object first = list.get(0);
                    if (first instanceof String) {
                        return list.toArray(new String[list.size()]);
                    }
                    if (first instanceof Annotation) {
                        return list.toArray(new Annotation[list.size()]);
                    }
                    if (first instanceof Class) {
                        return list.toArray(new Class[list.size()]);
                    }
                } else {
                    return ArrayUtil.EMPTY_STRING_ARRAY;
                }
                return list.toArray();
            }
            if (v instanceof PsiExpression) {
                return JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)v), (boolean)false);
            }
            return null;
        }

        public int getModifiers() {
            return 0;
        }

        public String getSignature() {
            return this.myAnnotation.getQualifiedName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiAnnotation that = (ResolvedPsiAnnotation)((Object)o);
            return this.myAnnotation.equals(that.myAnnotation);
        }

        public int hashCode() {
            return this.myAnnotation.hashCode();
        }
    }

    private static class ResolvedPsiClass
    extends JavaParser.ResolvedClass {
        protected PsiClass myClass;

        private ResolvedPsiClass(PsiClass cls) {
            this.myClass = cls;
        }

        public String getName() {
            if (this.myClass != null) {
                String qualifiedName = this.myClass.getQualifiedName();
                if (qualifiedName != null) {
                    return qualifiedName;
                }
                return this.myClass.getName();
            }
            return "";
        }

        public String getSimpleName() {
            if (this.myClass != null) {
                return this.myClass.getName();
            }
            return "";
        }

        public boolean matches(String name) {
            return name.equals(this.getName());
        }

        public JavaParser.ResolvedClass getSuperClass() {
            if (this.myClass != null) {
                PsiClass[] interfaces;
                PsiClass superClass = this.myClass.getSuperClass();
                if (PsiUtil.isLocalOrAnonymousClass((PsiClass)this.myClass) && (interfaces = this.myClass.getInterfaces()).length > 0) {
                    return new ResolvedPsiClass(interfaces[0]);
                }
                if (superClass != null) {
                    return new ResolvedPsiClass(superClass);
                }
            }
            return null;
        }

        public Iterable<JavaParser.ResolvedClass> getInterfaces() {
            PsiClass[] interfaces;
            if (this.myClass != null && (interfaces = this.myClass.getInterfaces()).length > 0) {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)interfaces.length);
                for (PsiClass cls : interfaces) {
                    list.add(new ResolvedPsiClass(cls));
                }
                return list;
            }
            return Collections.emptyList();
        }

        public boolean isInterface() {
            if (this.myClass != null) {
                return this.myClass.isInterface();
            }
            return false;
        }

        public boolean isEnum() {
            if (this.myClass != null) {
                return this.myClass.isEnum();
            }
            return false;
        }

        public JavaParser.TypeDescriptor getType() {
            if (this.myClass != null) {
                return new PsiTypeDescriptor((PsiType)PsiTypesUtil.getClassType((PsiClass)this.myClass)){

                    @Override
                    public JavaParser.ResolvedClass getTypeClass() {
                        return this;
                    }
                };
            }
            return super.getType();
        }

        public JavaParser.ResolvedClass getContainingClass() {
            PsiClass containingClass;
            if (this.myClass != null && (containingClass = this.myClass.getContainingClass()) != null) {
                return new ResolvedPsiClass(containingClass);
            }
            return null;
        }

        public boolean isSubclassOf(String name, boolean strict) {
            return this.isInheritingFrom(name, strict);
        }

        public boolean isImplementing(String name, boolean strict) {
            return this.isInheritingFrom(name, strict);
        }

        public boolean isInheritingFrom(String name, boolean strict) {
            PsiClass cls = this.myClass;
            if (cls != null) {
                if (strict) {
                    cls = cls.getSuperClass();
                }
                if (cls != null) {
                    return InheritanceUtil.isInheritor((PsiClass)cls, (String)name);
                }
            }
            return false;
        }

        public Iterable<JavaParser.ResolvedMethod> getConstructors() {
            PsiMethod[] methods;
            if (this.myClass != null && (methods = this.myClass.getConstructors()).length > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)methods.length);
                for (PsiMethod method : methods) {
                    result.add(new ResolvedPsiMethod(method));
                }
                return result;
            }
            return Collections.emptyList();
        }

        public Iterable<JavaParser.ResolvedMethod> getMethods(boolean includeInherited) {
            if (this.myClass != null) {
                PsiMethod[] methods;
                PsiMethod[] psiMethodArray = methods = includeInherited ? this.myClass.getAllMethods() : this.myClass.getMethods();
                if (methods.length > 0) {
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)methods.length);
                    for (PsiMethod method : methods) {
                        if (method.isConstructor()) continue;
                        result.add(new ResolvedPsiMethod(method));
                    }
                    return result;
                }
            }
            return Collections.emptyList();
        }

        public Iterable<JavaParser.ResolvedMethod> getMethods(String name, boolean includeInherited) {
            PsiMethod[] methods;
            if (this.myClass != null && (methods = this.myClass.findMethodsByName(name, includeInherited)).length > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)methods.length);
                for (PsiMethod method : methods) {
                    if (method.isConstructor()) continue;
                    result.add(new ResolvedPsiMethod(method));
                }
                return result;
            }
            return Collections.emptyList();
        }

        public Iterable<JavaParser.ResolvedField> getFields(boolean includeInherited) {
            if (this.myClass != null) {
                PsiField[] fields;
                PsiField[] psiFieldArray = fields = includeInherited ? this.myClass.getAllFields() : this.myClass.getFields();
                if (fields.length > 0) {
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)fields.length);
                    for (PsiField field : fields) {
                        result.add(new ResolvedPsiField(field));
                    }
                    return result;
                }
            }
            return Collections.emptyList();
        }

        public JavaParser.ResolvedField getField(String name, boolean includeInherited) {
            PsiField field;
            if (this.myClass != null && (field = this.myClass.findFieldByName(name, includeInherited)) != null) {
                return new ResolvedPsiField(field);
            }
            return null;
        }

        public JavaParser.ResolvedPackage getPackage() {
            PsiPackage pkg;
            PsiFile file;
            PsiDirectory dir;
            if (this.myClass != null && (dir = (file = this.myClass.getContainingFile()).getContainingDirectory()) != null && (pkg = JavaDirectoryService.getInstance().getPackage(dir)) != null) {
                return new ResolvedPsiPackage(pkg);
            }
            return null;
        }

        public boolean isInPackage(String pkg, boolean includeSubPackages) {
            return LombokPsiParser.isInPackage(this.myClass, pkg, includeSubPackages);
        }

        public Node findAstNode() {
            return this.myClass != null ? LombokPsiConverter.toNode((PsiElement)this.myClass) : null;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return LombokPsiParser.getAnnotations((PsiModifierListOwner)this.myClass);
        }

        public int getModifiers() {
            return LombokPsiParser.computeModifiers((PsiModifierListOwner)this.myClass);
        }

        public String getSignature() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiClass that = (ResolvedPsiClass)((Object)o);
            return !(this.myClass != null ? !this.myClass.equals(that.myClass) : that.myClass != null);
        }

        public int hashCode() {
            return this.myClass != null ? this.myClass.hashCode() : 0;
        }
    }

    private static class ResolvedPsiClassName
    extends ResolvedPsiClass {
        private final String myName;
        private final PsiManager myManager;
        private boolean myInitialized;

        private ResolvedPsiClassName(PsiManager manager, String name) {
            super(null);
            this.myManager = manager;
            this.myName = name;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public boolean matches(String name) {
            return name.equals(this.myName);
        }

        private void ensureInitialized() {
            if (this.myInitialized) {
                return;
            }
            this.myInitialized = true;
            Project project = this.myManager.getProject();
            this.myClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myName, GlobalSearchScope.allScope((Project)project));
        }

        @Override
        public JavaParser.ResolvedClass getSuperClass() {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getSuperClass();
            }
            return null;
        }

        @Override
        public boolean isInterface() {
            this.ensureInitialized();
            return super.isInterface();
        }

        @Override
        public boolean isEnum() {
            this.ensureInitialized();
            return super.isEnum();
        }

        @Override
        public JavaParser.ResolvedClass getContainingClass() {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getContainingClass();
            }
            return null;
        }

        @Override
        public boolean isSubclassOf(String name, boolean strict) {
            if (!strict && name.equals(this.myName)) {
                return true;
            }
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.isSubclassOf(name, strict);
            }
            return false;
        }

        @Override
        public Iterable<JavaParser.ResolvedMethod> getConstructors() {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getConstructors();
            }
            return Collections.emptyList();
        }

        @Override
        public Iterable<JavaParser.ResolvedMethod> getMethods(String name, boolean includeInherited) {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getMethods(name, includeInherited);
            }
            return Collections.emptyList();
        }

        @Override
        public JavaParser.ResolvedField getField(String name, boolean includeInherited) {
            this.ensureInitialized();
            if (this.myClass != null) {
                return super.getField(name, includeInherited);
            }
            return null;
        }

        @Override
        public int getModifiers() {
            this.ensureInitialized();
            return LombokPsiParser.computeModifiers((PsiModifierListOwner)this.myClass);
        }

        @Override
        public String getSignature() {
            return this.myName;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiClassName that = (ResolvedPsiClassName)((Object)o);
            return this.myName.equals(that.myName);
        }

        @Override
        public int hashCode() {
            return this.myName.hashCode();
        }
    }

    private static class ResolvedPsiField
    extends JavaParser.ResolvedField {
        private PsiField myField;

        private ResolvedPsiField(PsiField field) {
            this.myField = field;
        }

        public String getName() {
            return this.myField.getName();
        }

        public boolean matches(String name) {
            return name.equals(this.myField.getName());
        }

        public JavaParser.TypeDescriptor getType() {
            return LombokPsiParser.getTypeDescriptor(this.myField.getType());
        }

        public JavaParser.ResolvedClass getContainingClass() {
            return new ResolvedPsiClass(this.myField.getContainingClass());
        }

        public Object getValue() {
            return this.myField.computeConstantValue();
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return LombokPsiParser.getAnnotations((PsiModifierListOwner)this.myField);
        }

        public int getModifiers() {
            return LombokPsiParser.computeModifiers((PsiModifierListOwner)this.myField);
        }

        public String getSignature() {
            return this.myField.toString();
        }

        public boolean isInPackage(String pkg, boolean includeSubPackages) {
            return LombokPsiParser.isInPackage(this.myField.getContainingClass(), pkg, includeSubPackages);
        }

        public Node findAstNode() {
            return LombokPsiConverter.toNode((PsiElement)this.myField);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiField that = (ResolvedPsiField)((Object)o);
            return this.myField.equals(that.myField);
        }

        public int hashCode() {
            return this.myField.hashCode();
        }
    }

    private static class ResolvedPsiVariable
    extends JavaParser.ResolvedVariable {
        private PsiVariable myVariable;

        private ResolvedPsiVariable(PsiVariable variable) {
            this.myVariable = variable;
        }

        public String getName() {
            return this.myVariable.getName();
        }

        public boolean matches(String name) {
            return name.equals(this.myVariable.getName());
        }

        public JavaParser.TypeDescriptor getType() {
            return LombokPsiParser.getTypeDescriptor(this.myVariable.getType());
        }

        public int getModifiers() {
            return LombokPsiParser.computeModifiers((PsiModifierListOwner)this.myVariable);
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return LombokPsiParser.getAnnotations((PsiModifierListOwner)this.myVariable);
        }

        public String getSignature() {
            return this.myVariable.toString();
        }

        public Node findAstNode() {
            return LombokPsiConverter.toNode((PsiElement)this.myVariable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiVariable that = (ResolvedPsiVariable)((Object)o);
            return this.myVariable.equals(that.myVariable);
        }

        public int hashCode() {
            return this.myVariable.hashCode();
        }
    }

    private static class ResolvedPsiMethod
    extends JavaParser.ResolvedMethod {
        private PsiMethod myMethod;

        private ResolvedPsiMethod(PsiMethod method) {
            this.myMethod = method;
        }

        public String getName() {
            return this.myMethod.getName();
        }

        public boolean matches(String name) {
            return name.equals(this.myMethod.getName());
        }

        public JavaParser.ResolvedClass getContainingClass() {
            PsiClass containingClass = this.myMethod.getContainingClass();
            return new ResolvedPsiClass(containingClass);
        }

        public int getArgumentCount() {
            return this.myMethod.getParameterList().getParametersCount();
        }

        public JavaParser.TypeDescriptor getArgumentType(int index) {
            PsiParameter parameter = this.myMethod.getParameterList().getParameters()[index];
            PsiType type = parameter.getType();
            return LombokPsiParser.getTypeDescriptor(type);
        }

        public JavaParser.TypeDescriptor getReturnType() {
            if (this.myMethod.isConstructor()) {
                return null;
            }
            return LombokPsiParser.getTypeDescriptor(this.myMethod.getReturnType());
        }

        public String getSignature() {
            return this.myMethod.toString();
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return LombokPsiParser.getAnnotations((PsiModifierListOwner)this.myMethod);
        }

        public Iterable<JavaParser.ResolvedAnnotation> getParameterAnnotations(int index) {
            PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
            if (index >= 0 && index < parameters.length) {
                return LombokPsiParser.getAnnotations((PsiModifierListOwner)parameters[index]);
            }
            return Collections.emptyList();
        }

        public JavaParser.ResolvedAnnotation getParameterAnnotation(String type, int parameterIndex) {
            PsiParameter parameter;
            PsiAnnotation annotation;
            PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
            if (parameterIndex >= 0 && parameterIndex < parameters.length && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)(parameter = parameters[parameterIndex]), (String[])new String[]{type})) != null) {
                return new ResolvedPsiAnnotation(annotation);
            }
            return null;
        }

        public JavaParser.ResolvedAnnotation getAnnotation(String type) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)this.myMethod, (String[])new String[]{type});
            if (annotation != null) {
                return new ResolvedPsiAnnotation(annotation);
            }
            return null;
        }

        public int getModifiers() {
            int modifiers = 0;
            if (this.myMethod.hasModifierProperty("abstract")) {
                modifiers |= 0x400;
            }
            if (this.myMethod.hasModifierProperty("public")) {
                modifiers |= 1;
            }
            if (this.myMethod.hasModifierProperty("static")) {
                modifiers |= 8;
            }
            if (this.myMethod.hasModifierProperty("private")) {
                modifiers |= 2;
            }
            if (this.myMethod.hasModifierProperty("protected")) {
                modifiers |= 4;
            }
            if (this.myMethod.hasModifierProperty("final")) {
                modifiers |= 0x10;
            }
            return modifiers;
        }

        public JavaParser.ResolvedMethod getSuperMethod() {
            PsiMethod[] superMethods = this.myMethod.findSuperMethods();
            if (superMethods.length > 0) {
                return new ResolvedPsiMethod(superMethods[0]);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResolvedPsiMethod that = (ResolvedPsiMethod)((Object)o);
            return this.myMethod.equals(that.myMethod);
        }

        public boolean isInPackage(String pkg, boolean includeSubPackages) {
            return LombokPsiParser.isInPackage(this.myMethod.getContainingClass(), pkg, includeSubPackages);
        }

        public Node findAstNode() {
            return LombokPsiConverter.toNode((PsiElement)this.myMethod);
        }

        public int hashCode() {
            return this.myMethod.hashCode();
        }
    }

    private class LocationHandle
    implements Location.Handle {
        private final File myFile;
        private final Node myNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.myFile = file;
            this.myNode = node;
        }

        public Location resolve() {
            Position pos = this.myNode.getPosition();
            if (pos == null) {
                LombokPsiParser.this.myClient.log(Severity.WARNING, null, "No position data found for node %1$s", new Object[]{this.myNode});
                return Location.create((File)this.myFile);
            }
            return Location.create((File)this.myFile, null, (int)pos.getStart(), (int)pos.getEnd());
        }

        public void setClientData(Object clientData) {
            this.mClientData = clientData;
        }

        public Object getClientData() {
            return this.mClientData;
        }
    }

    private static class MyJavaEvaluator
    extends JavaEvaluator {
        private final Project myProject;

        public MyJavaEvaluator(Project project) {
            this.myProject = project;
        }

        public boolean extendsClass(PsiClass cls, String className, boolean strict) {
            return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
        }

        public boolean implementsInterface(PsiClass cls, String interfaceName, boolean strict) {
            return false;
        }

        public boolean inheritsFrom(PsiClass cls, String className, boolean strict) {
            return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
        }

        public PsiClass findClass(String qualifiedName) {
            return JavaPsiFacade.getInstance((Project)this.myProject).findClass(qualifiedName, GlobalSearchScope.allScope((Project)this.myProject));
        }

        public PsiClassType getClassType(PsiClass cls) {
            return cls != null ? JavaPsiFacade.getElementFactory((Project)this.myProject).createType(cls) : null;
        }

        public PsiAnnotation[] getAllAnnotations(PsiModifierListOwner owner, boolean inHierarchy) {
            return AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)inHierarchy, null, (boolean)true);
        }

        public PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner listOwner, String ... annotationNames) {
            return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)listOwner, (Set)Sets.newHashSet((Object[])annotationNames));
        }

        public PsiAnnotation findAnnotation(PsiModifierListOwner listOwner, String ... annotationNames) {
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (boolean)false, (String[])annotationNames);
        }

        public File getFile(PsiFile file) {
            VirtualFile virtualFile = file.getVirtualFile();
            return virtualFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile) : null;
        }
    }

    private static class PsiTypeDescriptor
    extends JavaParser.DefaultTypeDescriptor {
        private final PsiType myType;

        public PsiTypeDescriptor(PsiType type) {
            super(type.getCanonicalText());
            this.myType = type;
        }

        public JavaParser.ResolvedClass getTypeClass() {
            GlobalSearchScope resolveScope;
            if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)this.myType) && (resolveScope = this.myType.getResolveScope()) != null && resolveScope.getProject() != null) {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                PsiClass aClass = JavaPsiFacade.getInstance((Project)resolveScope.getProject()).findClass(this.getSignature(), resolveScope);
                if (aClass != null) {
                    return new ResolvedPsiClass(aClass);
                }
            }
            return null;
        }

        public boolean isPrimitive() {
            return this.myType.getDeepComponentType() instanceof PsiPrimitiveType;
        }

        public boolean isArray() {
            return this.myType instanceof PsiArrayType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            PsiTypeDescriptor that = (PsiTypeDescriptor)((Object)o);
            return this.myType.equals(that.myType);
        }

        public int hashCode() {
            return this.myType.hashCode();
        }
    }
}

