/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IntellijApiDetector
extends ApiDetector {
    static final Implementation IMPLEMENTATION = new Implementation(IntellijApiDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.MANIFEST, Scope.JAVA_FILE), new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE});
    @NonNls
    private static final String TARGET_API_FQCN = "android.annotation.TargetApi";

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiJavaFile.class);
    }

    public JavaElementVisitor createPsiVisitor(final JavaContext context) {
        return new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                PsiClass[] classes = file.getClasses();
                if (classes.length > 0) {
                    file.accept((PsiElementVisitor)new ApiCheckVisitor((Context)context, classes[0], (PsiFile)file));
                }
            }
        };
    }

    private static int getTargetApi(PsiElement e, PsiElement file) {
        for (PsiElement element = e; element != null && element != file; element = element.getParent()) {
            if (!(element instanceof PsiModifierListOwner)) continue;
            PsiModifierListOwner owner = (PsiModifierListOwner)element;
            PsiModifierList modifierList = owner.getModifierList();
            PsiAnnotation annotation = null;
            if (modifierList != null && (annotation = modifierList.findAnnotation(TARGET_API_FQCN)) == null) {
                annotation = modifierList.findAnnotation("android.support.annotation.RequiresApi");
            }
            if (annotation == null) continue;
            for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue v = pair.getValue();
                if (v instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)v;
                    Object value = literal.getValue();
                    if (value instanceof Integer) {
                        return (Integer)value;
                    }
                    if (!(value instanceof String)) continue;
                    return IntellijApiDetector.codeNameToApi((String)((String)value));
                }
                if (v instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                    for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                        if (!(mmv instanceof PsiLiteral)) continue;
                        PsiLiteral literal = (PsiLiteral)mmv;
                        Object value = literal.getValue();
                        if (value instanceof Integer) {
                            return (Integer)value;
                        }
                        if (!(value instanceof String)) continue;
                        return IntellijApiDetector.codeNameToApi((String)((String)value));
                    }
                    continue;
                }
                if (!(v instanceof PsiExpression)) continue;
                if (v instanceof PsiReferenceExpression) {
                    String fqcn = ((PsiReferenceExpression)v).getQualifiedName();
                    return IntellijApiDetector.codeNameToApi((String)fqcn);
                }
                return IntellijApiDetector.codeNameToApi((String)v.getText());
            }
        }
        return -1;
    }

    private class ApiCheckVisitor
    extends JavaRecursiveElementVisitor {
        private final Context myContext;
        private boolean mySeenSuppress;
        private boolean mySeenTargetApi;
        private final PsiClass myClass;
        private final PsiFile myFile;
        private final boolean myCheckAccess;
        private boolean myCheckOverride;
        private String myFrameworkParent;

        public ApiCheckVisitor(Context context, PsiClass clz, PsiFile file) {
            this.myContext = context;
            this.myClass = clz;
            this.myFile = file;
            this.myCheckAccess = context.isEnabled(ApiDetector.UNSUPPORTED) || context.isEnabled(ApiDetector.INLINED);
            this.myCheckOverride = context.isEnabled(ApiDetector.OVERRIDE) && context.getMainProject().getBuildSdk() >= 1;
            int depth = 0;
            if (this.myCheckOverride) {
                this.myFrameworkParent = null;
                for (PsiClass superClass = this.myClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                    String fqcn = superClass.getQualifiedName();
                    if (fqcn == null) {
                        this.myCheckOverride = false;
                        continue;
                    }
                    if (!fqcn.startsWith("android.") && !fqcn.startsWith("java.") && !fqcn.startsWith("javax.")) continue;
                    if (fqcn.equals("java.lang.Object")) break;
                    this.myFrameworkParent = ClassContext.getInternalName((String)fqcn);
                    break;
                }
                if (this.myFrameworkParent == null) {
                    this.myCheckOverride = false;
                }
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            String fqcn = annotation.getQualifiedName();
            if (IntellijApiDetector.TARGET_API_FQCN.equals(fqcn) || "android.support.annotation.RequiresApi".equals(fqcn)) {
                this.mySeenTargetApi = true;
            } else if ("android.annotation.SuppressLint".equals(fqcn) || "java.lang.SuppressWarnings".equals(fqcn)) {
                this.mySeenSuppress = true;
            }
        }

        public void visitMethod(PsiMethod method) {
            int minSdk;
            int api;
            super.visitMethod(method);
            if (method.getModifierList().hasExplicitModifier("default") && !this.isSuppressed(api = 24, (PsiElement)method, minSdk = IntellijApiDetector.this.getMinSdk(this.myContext))) {
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)method);
                String message = String.format("Default method requires API level %1$d (current min is %2$d)", api, minSdk);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
            if (!this.myCheckOverride) {
                return;
            }
            int buildSdk = this.myContext.getMainProject().getBuildSdk();
            String name = method.getName();
            assert (this.myFrameworkParent != null);
            String desc = IntellijLintUtils.getInternalDescription(method, false, false);
            if (desc == null) {
                return;
            }
            int api2 = IntellijApiDetector.this.mApiDatabase.getCallVersion(this.myFrameworkParent, name, desc);
            if (api2 > buildSdk && buildSdk != -1) {
                String fqcn;
                if (this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)method, this.myFile, ApiDetector.OVERRIDE)) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null) {
                    String className = containingClass.getName();
                    String fullClassName = containingClass.getQualifiedName();
                    if (fullClassName != null) {
                        className = fullClassName;
                    }
                    fqcn = className + '#' + name;
                } else {
                    fqcn = name;
                }
                String message = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): %3$s", api2, buildSdk, fqcn);
                PsiIdentifier locationNode = method.getNameIdentifier();
                if (locationNode == null) {
                    locationNode = method;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)locationNode);
                this.myContext.report(ApiDetector.OVERRIDE, location, message);
            }
        }

        public void visitClass(PsiClass aClass) {
            String message;
            PsiModifierList modifierList;
            super.visitClass(aClass);
            if (!this.myCheckAccess) {
                return;
            }
            if (aClass.isAnnotationType() && (modifierList = aClass.getModifierList()) != null) {
                PsiAnnotation[] psiAnnotationArray = modifierList.getAnnotations();
                int n = psiAnnotationArray.length;
                for (int i = 0; i < n; ++i) {
                    int minSdk;
                    int api;
                    PsiAnnotation annotation = psiAnnotationArray[i];
                    String name = annotation.getQualifiedName();
                    if (!"java.lang.annotation.Repeatable".equals(name) || this.isSuppressed(api = 24, (PsiElement)aClass, minSdk = IntellijApiDetector.this.getMinSdk(this.myContext))) continue;
                    Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)annotation);
                    message = String.format("Repeatable annotation requires API level %1$d (current min is %2$d)", api, minSdk);
                    this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
                }
            }
            for (PsiClassType type : aClass.getSuperTypes()) {
                Location location;
                int target;
                int minSdk;
                int api;
                String signature = IntellijLintUtils.getInternalName(type);
                if (signature == null || (api = IntellijApiDetector.this.mApiDatabase.getClassVersion(signature)) == -1 || api <= (minSdk = IntellijApiDetector.this.getMinSdk(this.myContext)) || this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi((PsiElement)aClass, (PsiElement)this.myFile)) != -1 && api <= target || this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)aClass, this.myFile, ApiDetector.UNSUPPORTED)) continue;
                if (type instanceof PsiClassReferenceType) {
                    PsiJavaCodeReferenceElement reference = ((PsiClassReferenceType)type).getReference();
                    PsiElement element = reference.getElement();
                    if (ApiDetector.isWithinVersionCheckConditional((PsiElement)element, (int)api) || ApiDetector.isPrecededByVersionCheckExit((PsiElement)element, (int)api)) continue;
                    location = IntellijLintUtils.getLocation(this.myContext.file, element);
                } else {
                    location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)aClass);
                }
                String fqcn = type.getClassName();
                message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            if (!this.myCheckAccess) {
                return;
            }
            PsiReference reference = expression.getReference();
            if (reference == null) {
                return;
            }
            PsiElement resolved = reference.resolve();
            if (resolved != null && resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String owner = IntellijLintUtils.getInternalName(containingClass);
                if (owner == null) {
                    return;
                }
                String name = field.getName();
                if (name == null) {
                    return;
                }
                int api = IntellijApiDetector.this.mApiDatabase.getFieldVersion(owner, name);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (this.isSuppressed(api, (PsiElement)expression, minSdk)) {
                    return;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)expression);
                String fqcn = containingClass.getQualifiedName();
                String message = String.format("Field requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + name);
                Issue issue = ApiDetector.UNSUPPORTED;
                PsiType type = field.getType();
                if (PsiType.INT.equals((Object)type) || PsiType.CHAR.equals((Object)type) || PsiType.BOOLEAN.equals((Object)type) || PsiType.DOUBLE.equals((Object)type) || PsiType.FLOAT.equals((Object)type) || PsiType.BYTE.equals((Object)type) || type.equalsToText("java.lang.String")) {
                    issue = ApiDetector.INLINED;
                    if (ApiDetector.isBenignConstantUsage((PsiElement)expression, (String)name, (String)owner)) {
                        return;
                    }
                }
                this.myContext.report(issue, location, message);
            }
        }

        public void visitTryStatement(PsiTryStatement statement) {
            super.visitTryStatement(statement);
            PsiResourceList resourceList = statement.getResourceList();
            if (resourceList != null) {
                int api = 19;
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (this.isSuppressed(api, (PsiElement)statement, minSdk)) {
                    return;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)resourceList);
                String message = String.format("Try-with-resources requires API level %1$d (current min is %2$d)", api, minSdk);
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
            for (PsiParameter parameter : statement.getCatchBlockParameters()) {
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null) continue;
                this.checkCatchTypeElement(statement, typeElement, typeElement.getType());
            }
        }

        private void checkCatchTypeElement(PsiTryStatement statement, @NotNull PsiTypeElement typeElement, PsiType type) {
            PsiClass resolved = null;
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                if ((type = disjunctionType.getLeastUpperBound()) instanceof PsiClassType) {
                    resolved = ((PsiClassType)type).resolve();
                }
                for (PsiElement child : typeElement.getChildren()) {
                    PsiTypeElement childTypeElement;
                    PsiType childType;
                    if (!(child instanceof PsiTypeElement) || type.equals(childType = (childTypeElement = (PsiTypeElement)child).getType())) continue;
                    this.checkCatchTypeElement(statement, childTypeElement, childType);
                }
            } else if (type instanceof PsiClassReferenceType) {
                PsiClassReferenceType referenceType = (PsiClassReferenceType)type;
                resolved = referenceType.resolve();
            } else if (type instanceof PsiClassType) {
                resolved = ((PsiClassType)type).resolve();
            }
            if (resolved != null) {
                int target;
                String signature = IntellijLintUtils.getInternalName(resolved);
                if (signature == null) {
                    return;
                }
                int api = IntellijApiDetector.this.mApiDatabase.getClassVersion(signature);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (api <= minSdk) {
                    return;
                }
                if (this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi((PsiElement)statement, (PsiElement)this.myFile)) != -1 && api <= target) {
                    return;
                }
                if (this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)statement, this.myFile, ApiDetector.UNSUPPORTED)) {
                    return;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)typeElement);
                String fqcn = resolved.getName();
                String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                if (api == 19 && "ReflectiveOperationException".equals(fqcn)) {
                    message = String.format("Multi-catch with these reflection exceptions requires API level 19 (current min is %2$d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.", api, minSdk);
                }
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
        }

        private boolean isSuppressed(int api, PsiElement element, int minSdk) {
            int target;
            if (api <= minSdk) {
                return true;
            }
            if (this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi(element, (PsiElement)this.myFile)) != -1 && api <= target) {
                return true;
            }
            if (this.mySeenSuppress && (IntellijLintUtils.isSuppressed(element, this.myFile, ApiDetector.UNSUPPORTED) || IntellijLintUtils.isSuppressed(element, this.myFile, ApiDetector.INLINED))) {
                return true;
            }
            if (ApiDetector.isWithinVersionCheckConditional((PsiElement)element, (int)api)) {
                return true;
            }
            return ApiDetector.isPrecededByVersionCheckExit((PsiElement)element, (int)api);
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            if (!this.myCheckAccess) {
                return;
            }
            PsiTypeElement castTypeElement = expression.getCastType();
            PsiExpression operand = expression.getOperand();
            if (operand == null || castTypeElement == null) {
                return;
            }
            PsiType operandType = operand.getType();
            PsiType castType = castTypeElement.getType();
            if (castType.equals(operandType)) {
                return;
            }
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)operandType;
            PsiClassType interfaceType = (PsiClassType)castType;
            this.checkCast((PsiElement)expression, classType, interfaceType);
        }

        private void checkCast(@NotNull PsiElement node, @NotNull PsiClassType classType, @NotNull PsiClassType interfaceType) {
            if (classType.equals((Object)interfaceType)) {
                return;
            }
            String classTypeInternal = IntellijLintUtils.getInternalName(classType);
            String interfaceTypeInternal = IntellijLintUtils.getInternalName(interfaceType);
            if (classTypeInternal == null || interfaceTypeInternal == null || "java/lang/Object".equals(interfaceTypeInternal)) {
                return;
            }
            int api = IntellijApiDetector.this.mApiDatabase.getValidCastVersion(classTypeInternal, interfaceTypeInternal);
            if (api == -1) {
                return;
            }
            int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
            if (api <= minSdk) {
                return;
            }
            if (this.isSuppressed(api, node, minSdk)) {
                return;
            }
            Location location = IntellijLintUtils.getLocation(this.myContext.file, node);
            String message = String.format("Cast from %1$s to %2$s requires API level %3$d (current min is %4$d)", classType.getClassName(), interfaceType.getClassName(), api, minSdk);
            this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            if (!this.myCheckAccess) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            PsiType initializerType = initializer.getType();
            if (initializerType == null || !(initializerType instanceof PsiClassType)) {
                return;
            }
            PsiType interfaceType = variable.getType();
            if (initializerType.equals(interfaceType)) {
                return;
            }
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            this.checkCast((PsiElement)initializer, (PsiClassType)initializerType, (PsiClassType)interfaceType);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            if (!this.myCheckAccess) {
                return;
            }
            PsiExpression rExpression = expression.getRExpression();
            if (rExpression == null) {
                return;
            }
            PsiType rhsType = rExpression.getType();
            if (rhsType == null || !(rhsType instanceof PsiClassType)) {
                return;
            }
            PsiType interfaceType = expression.getLExpression().getType();
            if (rhsType.equals(interfaceType)) {
                return;
            }
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            this.checkCast((PsiElement)rExpression, (PsiClassType)rhsType, (PsiClassType)interfaceType);
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            String expressionOwner;
            super.visitForeachStatement(statement);
            if (!this.myCheckAccess) {
                return;
            }
            PsiExpression value = statement.getIteratedValue();
            if (value == null) {
                return;
            }
            PsiType type = value.getType();
            if (type instanceof PsiClassType && (expressionOwner = IntellijLintUtils.getInternalName((PsiClassType)type)) != null) {
                PsiMethod keySet;
                PsiMethodCallExpression valueCall;
                int target;
                int api = IntellijApiDetector.this.mApiDatabase.getClassVersion(expressionOwner);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (api <= minSdk) {
                    return;
                }
                if (this.mySeenTargetApi && (target = IntellijApiDetector.getTargetApi((PsiElement)statement, (PsiElement)this.myFile)) != -1 && api <= target) {
                    return;
                }
                if (this.mySeenSuppress && IntellijLintUtils.isSuppressed((PsiElement)statement, this.myFile, ApiDetector.UNSUPPORTED)) {
                    return;
                }
                if (ApiDetector.isWithinVersionCheckConditional((PsiElement)statement, (int)api)) {
                    return;
                }
                if (ApiDetector.isPrecededByVersionCheckExit((PsiElement)statement, (int)api)) {
                    return;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, (PsiElement)value);
                String message = String.format("The type of the for loop iterated value is %1$s, which requires API level %2$d (current min is %3$d)", type.getCanonicalText(), api, minSdk);
                if (value instanceof PsiMethodCallExpression && "keySet".equals((valueCall = (PsiMethodCallExpression)value).getMethodExpression().getReferenceName()) && (keySet = valueCall.resolveMethod()) != null && keySet.getContainingClass() != null && "java.util.concurrent.ConcurrentHashMap".equals(keySet.getContainingClass().getQualifiedName())) {
                    message = message + "; to work around this, add an explicit cast to (Map) before the `keySet` call.";
                }
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
        }

        public void visitCallExpression(PsiCallExpression expression) {
            super.visitCallExpression(expression);
            if (!this.myCheckAccess) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method != null) {
                PsiMethod containingMethod;
                PsiMethodCallExpression call;
                PsiReferenceExpression methodExpression;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() > 0) {
                    PsiParameter[] parameters = parameterList.getParameters();
                    PsiExpressionList argumentList = expression.getArgumentList();
                    if (argumentList != null) {
                        PsiExpression[] arguments = argumentList.getExpressions();
                        for (int i = 0; i < parameters.length; ++i) {
                            PsiType parameterType = parameters[i].getType();
                            if (!(parameterType instanceof PsiClassType)) continue;
                            if (i >= arguments.length) break;
                            PsiExpression argument = arguments[i];
                            PsiType argumentType = argument.getType();
                            if (argumentType == null || parameterType.equals(argumentType) || !(argumentType instanceof PsiClassType)) continue;
                            this.checkCast((PsiElement)argument, (PsiClassType)argumentType, (PsiClassType)parameterType);
                        }
                    }
                }
                String fqcn = containingClass.getQualifiedName();
                String owner = IntellijLintUtils.getInternalName(containingClass);
                if (owner == null) {
                    return;
                }
                String name = IntellijLintUtils.getInternalMethodName(method);
                String desc = IntellijLintUtils.getInternalDescription(method, false, false);
                if (desc == null) {
                    return;
                }
                int api = IntellijApiDetector.this.mApiDatabase.getCallVersion(owner, name, desc);
                if (api == -1) {
                    return;
                }
                int minSdk = IntellijApiDetector.this.getMinSdk(this.myContext);
                if (api <= minSdk) {
                    return;
                }
                if (expression instanceof PsiMethodCallExpression) {
                    PsiExpression qualifier = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression();
                    if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                        String expressionOwner;
                        PsiType type = qualifier.getType();
                        if (type != null && type instanceof PsiClassType && (expressionOwner = IntellijLintUtils.getInternalName((PsiClassType)type)) != null && !expressionOwner.equals(owner)) {
                            int specificApi = IntellijApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                            if (specificApi == -1) {
                                if (ApiLookup.isRelevantOwner((String)expressionOwner)) {
                                    return;
                                }
                            } else {
                                if (specificApi <= minSdk) {
                                    return;
                                }
                                if (specificApi < api) {
                                    api = specificApi;
                                    fqcn = expressionOwner.replace('/', '.');
                                }
                                api = Math.min(specificApi, api);
                            }
                        }
                    } else {
                        PsiElement resolved;
                        PsiQualifiedExpression pte;
                        PsiJavaCodeReferenceElement operand;
                        PsiClass cls = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
                        if ((qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) && (operand = (pte = (PsiQualifiedExpression)qualifier).getQualifier()) != null && (resolved = operand.resolve()) instanceof PsiClass) {
                            cls = (PsiClass)resolved;
                        }
                        while (cls != null) {
                            String expressionOwner;
                            if (cls instanceof PsiAnonymousClass) {
                                boolean found = false;
                                PsiClassType anonymousBaseType = ((PsiAnonymousClass)cls).getBaseClassType();
                                PsiClass anonymousBase = anonymousBaseType.resolve();
                                if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                    cls = anonymousBase;
                                    found = true;
                                } else {
                                    PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class, (boolean)true);
                                    if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                        cls = surroundingBaseType;
                                        found = true;
                                    }
                                }
                                if (!found) break;
                            }
                            if ((expressionOwner = IntellijLintUtils.getInternalName(cls)) == null) break;
                            int specificApi = IntellijApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                            if (specificApi != -1) {
                                if (specificApi <= minSdk) {
                                    return;
                                }
                                if (specificApi < api) {
                                    api = specificApi;
                                    fqcn = expressionOwner.replace('/', '.');
                                }
                                api = Math.min(specificApi, api);
                                break;
                            }
                            if (ApiLookup.isRelevantOwner((String)expressionOwner)) {
                                return;
                            }
                            cls = cls.getSuperClass();
                        }
                    }
                }
                if (this.isSuppressed(api, (PsiElement)expression, minSdk)) {
                    return;
                }
                if (expression instanceof PsiMethodCallExpression && (methodExpression = (call = (PsiMethodCallExpression)expression).getMethodExpression()).getQualifierExpression() instanceof PsiSuperExpression && (containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true)) != null && name.equals(containingMethod.getName()) && MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)containingMethod) && !method.isConstructor()) {
                    return;
                }
                PsiElement locationNode = IntellijLintUtils.getCallName(expression);
                if (locationNode == null) {
                    locationNode = expression;
                }
                Location location = IntellijLintUtils.getLocation(this.myContext.file, locationNode);
                String message = String.format("Call requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn + '#' + method.getName());
                this.myContext.report(ApiDetector.UNSUPPORTED, location, message);
            }
        }
    }
}

