/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidTextUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.animation.AndroidAnimationUtils;
import org.jetbrains.android.dom.animator.AndroidAnimatorUtil;
import org.jetbrains.android.dom.drawable.AndroidDrawableDomUtil;
import org.jetbrains.android.dom.transition.TransitionDomUtil;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.MoveFileQuickFix;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlWrongFileTypeInspection
extends LocalInspectionTool {
    private static ImmutableMultimap<String, ResourceFolderType> ourResourceFolderTypeMap;
    private static final Function<ResourceFolderType, String> TYPE_NAME_FUNCTION;

    @NotNull
    public static ImmutableCollection<ResourceFolderType> determineResourceFolderTypeByRootTag(@NotNull AndroidFacet facet, @NotNull String tagName) {
        if (ourResourceFolderTypeMap == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (String tag : AndroidAnimationUtils.getPossibleRoots()) {
                builder.put((Object)tag, (Object)ResourceFolderType.ANIM);
            }
            for (String tag : AndroidAnimatorUtil.getPossibleRoots()) {
                builder.put((Object)tag, (Object)ResourceFolderType.ANIMATOR);
            }
            for (String tag : AndroidXmlResourcesUtil.getPossibleRoots(facet)) {
                builder.put((Object)tag, (Object)ResourceFolderType.XML);
            }
            for (String tag : AndroidDrawableDomUtil.getPossibleRoots(facet)) {
                builder.put((Object)tag, (Object)ResourceFolderType.DRAWABLE);
            }
            for (String tag : TransitionDomUtil.getPossibleRoots()) {
                builder.put((Object)tag, (Object)ResourceFolderType.TRANSITION);
            }
            ourResourceFolderTypeMap = builder.build();
        }
        return ourResourceFolderTypeMap.get((Object)tagName);
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String resourceQualifier;
        String resourceType;
        if (!(file instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)file;
        XmlTag rootTag = xmlFile.getRootTag();
        if (rootTag == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        DomFileDescription description = DomManager.getDomManager((Project)file.getProject()).getDomFileDescription(xmlFile);
        if (description != null) {
            return null;
        }
        PsiDirectory directory = file.getContainingDirectory();
        if (directory == null) {
            return null;
        }
        if (!AndroidResourceUtil.isResourceSubdirectory(directory, null)) {
            return null;
        }
        String name = rootTag.getName();
        ImmutableCollection<ResourceFolderType> folderTypes = XmlWrongFileTypeInspection.determineResourceFolderTypeByRootTag(facet, name);
        if (folderTypes.isEmpty()) {
            return null;
        }
        String directoryName = directory.getName();
        int dashIndex = directoryName.indexOf(45);
        if (dashIndex != -1) {
            resourceType = directoryName.substring(0, dashIndex);
            resourceQualifier = directoryName.substring(dashIndex + 1);
        } else {
            resourceType = directoryName;
            resourceQualifier = null;
        }
        String folderEnumeration = AndroidTextUtils.generateCommaSeparatedList(Collections2.transform(folderTypes, TYPE_NAME_FUNCTION), "or");
        if (folderTypes.size() > 1) {
            folderEnumeration = "either " + folderEnumeration;
        }
        String message = String.format("<%1$s> XML file should be in %2$s, not \"%3$s\"", name, folderEnumeration, resourceType);
        ASTNode node = XmlChildRole.START_TAG_NAME_FINDER.findChild(rootTag.getNode());
        LocalQuickFix[] quickFixes = new LocalQuickFix[folderTypes.size()];
        int i = 0;
        for (ResourceFolderType type : folderTypes) {
            String resultFolder = resourceQualifier == null ? type.getName() : type.getName() + '-' + resourceQualifier;
            quickFixes[i++] = new MoveFileQuickFix(resultFolder, xmlFile);
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)(node == null ? rootTag : node.getPsi()), message, isOnTheFly, quickFixes, ProblemHighlightType.GENERIC_ERROR);
        return new ProblemDescriptor[]{descriptor};
    }

    static {
        TYPE_NAME_FUNCTION = new Function<ResourceFolderType, String>(){

            @NotNull
            public String apply(ResourceFolderType input) {
                return '\"' + input.getName() + '\"';
            }
        };
    }
}

