/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaSourceProvider {
    public static Function<IdeaSourceProvider, List<VirtualFile>> MANIFEST_PROVIDER = provider -> {
        VirtualFile manifestFile = provider.getManifestFile();
        return manifestFile == null ? Collections.emptyList() : Collections.singletonList(manifestFile);
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> RES_PROVIDER = provider -> Lists.newArrayList(provider.getResDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> JAVA_PROVIDER = provider -> Lists.newArrayList(provider.getJavaDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> RESOURCES_PROVIDER = provider -> Lists.newArrayList(provider.getResourcesDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> AIDL_PROVIDER = provider -> Lists.newArrayList(provider.getAidlDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_PROVIDER = provider -> Lists.newArrayList(provider.getJniDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_LIBS_PROVIDER = provider -> Lists.newArrayList(provider.getJniLibsDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> ASSETS_PROVIDER = provider -> Lists.newArrayList(provider.getAssetsDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> RENDERSCRIPT_PROVIDER = provider -> Lists.newArrayList(provider.getRenderscriptDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> SHADERS_PROVIDER = provider -> Lists.newArrayList(provider.getShadersDirectories());

    private IdeaSourceProvider() {
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull SourceProvider provider) {
        return new Gradle(provider);
    }

    @NotNull
    private static List<IdeaSourceProvider> createAll(@NotNull List<SourceProvider> providers) {
        ArrayList ideaProviders = Lists.newArrayList();
        for (SourceProvider provider : providers) {
            ideaProviders.add(IdeaSourceProvider.create(provider));
        }
        return ideaProviders;
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull NativeAndroidGradleFacet facet) {
        return new Native(facet);
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull AndroidFacet facet) {
        return new Legacy(facet);
    }

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract VirtualFile getManifestFile();

    @NotNull
    public abstract Collection<VirtualFile> getJavaDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getResourcesDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getAidlDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getRenderscriptDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getJniDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getJniLibsDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getResDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getAssetsDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getShadersDirectories();

    @NotNull
    public static List<IdeaSourceProvider> getCurrentSourceProviders(@NotNull AndroidFacet facet) {
        if (!facet.requiresAndroidModel()) {
            return Collections.singletonList(facet.getMainIdeaSourceProvider());
        }
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            return IdeaSourceProvider.createAll(androidModel.getActiveSourceProviders());
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<IdeaSourceProvider> getCurrentTestSourceProviders(@NotNull AndroidFacet facet) {
        if (!facet.requiresAndroidModel()) {
            return Collections.emptyList();
        }
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            return IdeaSourceProvider.createAll(androidModel.getTestSourceProviders());
        }
        return Collections.emptyList();
    }

    @NotNull
    private Collection<VirtualFile> getAllSourceFolders() {
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(this.getJavaDirectories());
        srcDirectories.addAll(this.getResDirectories());
        srcDirectories.addAll(this.getAidlDirectories());
        srcDirectories.addAll(this.getRenderscriptDirectories());
        srcDirectories.addAll(this.getAssetsDirectories());
        srcDirectories.addAll(this.getJniDirectories());
        srcDirectories.addAll(this.getJniLibsDirectories());
        return srcDirectories;
    }

    @NotNull
    public static Collection<File> getAllSourceFolders(@NotNull SourceProvider provider) {
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(provider.getJavaDirectories());
        srcDirectories.addAll(provider.getResDirectories());
        srcDirectories.addAll(provider.getAidlDirectories());
        srcDirectories.addAll(provider.getRenderscriptDirectories());
        srcDirectories.addAll(provider.getAssetsDirectories());
        srcDirectories.addAll(provider.getCDirectories());
        srcDirectories.addAll(provider.getCppDirectories());
        srcDirectories.addAll(provider.getJniLibsDirectories());
        return srcDirectories;
    }

    public boolean containsFile(@NotNull VirtualFile file) {
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        if (file.equals(this.getManifestFile())) {
            return true;
        }
        for (VirtualFile container : srcDirectories) {
            if (!container.exists()) continue;
            if (VfsUtilCore.isAncestor((VirtualFile)container, (VirtualFile)file, (boolean)false)) {
                return true;
            }
            if (!file.equals(container.getParent())) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainedBy(@NotNull SourceProvider provider, @NotNull File targetFolder) {
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        for (File container : srcDirectories) {
            if (VfsUtilCore.isAncestor((File)targetFolder, (File)container, (boolean)false)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)targetFolder, (File)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFile(@NotNull SourceProvider provider, @NotNull File file) {
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        if (FileUtil.filesEqual((File)provider.getManifestFile(), (File)file)) {
            return true;
        }
        for (File container : srcDirectories) {
            File parent = container.getParentFile();
            if (parent != null && parent.isDirectory() && FileUtil.filesEqual((File)parent, (File)file)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)container, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainedBy(@NotNull VirtualFile targetFolder) {
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        for (VirtualFile container : srcDirectories) {
            if (!container.exists() || !VfsUtilCore.isAncestor((VirtualFile)targetFolder, (VirtualFile)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<SourceProvider> getAllSourceProviders(@NotNull AndroidFacet facet) {
        if (!facet.requiresAndroidModel() || facet.getAndroidModel() == null) {
            return Collections.singletonList(facet.getMainSourceProvider());
        }
        return facet.getAndroidModel().getAllSourceProviders();
    }

    @NotNull
    public static List<IdeaSourceProvider> getAllIdeaSourceProviders(@NotNull AndroidFacet facet) {
        if (!facet.requiresAndroidModel() || facet.getAndroidModel() == null) {
            return Collections.singletonList(facet.getMainIdeaSourceProvider());
        }
        return IdeaSourceProvider.createAll(IdeaSourceProvider.getAllSourceProviders(facet));
    }

    @NotNull
    public static List<IdeaSourceProvider> getIdeaSourceProvidersForFile(@NotNull AndroidFacet facet, @Nullable VirtualFile targetFolder, @Nullable IdeaSourceProvider defaultIdeaSourceProvider) {
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getAllIdeaSourceProviders(facet)) {
                if (!provider.containsFile(targetFolder) && !provider.isContainedBy(targetFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultIdeaSourceProvider != null) {
            sourceProviderList.add(defaultIdeaSourceProvider);
        }
        return sourceProviderList;
    }

    @NotNull
    public static List<SourceProvider> getSourceProvidersForFile(@NotNull AndroidFacet facet, @Nullable VirtualFile targetFolder, @Nullable SourceProvider defaultSourceProvider) {
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            File targetIoFolder = VfsUtilCore.virtualToIoFile((VirtualFile)targetFolder);
            for (SourceProvider provider : IdeaSourceProvider.getAllSourceProviders(facet)) {
                if (!IdeaSourceProvider.containsFile(provider, targetIoFolder) && !IdeaSourceProvider.isContainedBy(provider, targetIoFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultSourceProvider != null) {
            sourceProviderList.add(defaultSourceProvider);
        }
        return sourceProviderList;
    }

    public static boolean isManifestFile(@NotNull AndroidFacet facet, @Nullable VirtualFile candidate) {
        if (candidate == null) {
            return false;
        }
        if (facet.requiresAndroidModel()) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
                if (!candidate.equals(provider.getManifestFile())) continue;
                return true;
            }
            return false;
        }
        return candidate.equals(facet.getMainIdeaSourceProvider().getManifestFile());
    }

    @NotNull
    public static List<VirtualFile> getManifestFiles(@NotNull AndroidFacet facet) {
        VirtualFile main = facet.getMainIdeaSourceProvider().getManifestFile();
        if (!facet.requiresAndroidModel()) {
            return main != null ? Collections.singletonList(main) : Collections.emptyList();
        }
        ArrayList files = Lists.newArrayList();
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
            VirtualFile manifest = provider.getManifestFile();
            if (manifest == null) continue;
            files.add(manifest);
        }
        return files;
    }

    private static class Legacy
    extends IdeaSourceProvider {
        @NotNull
        private final AndroidFacet myFacet;

        private Legacy(@NotNull AndroidFacet facet) {
            this.myFacet = facet;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            Module module = this.myFacet.getModule();
            VirtualFile file = AndroidRootUtil.getFileByRelativeModulePath(module, this.myFacet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
            if (file != null) {
                return file;
            }
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (contentRoots.length == 1) {
                return contentRoots[0].findChild("AndroidManifest.xml");
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJavaDirectories() {
            Module module = this.myFacet.getModule();
            HashSet dirs = new HashSet();
            Collections.addAll(dirs, ModuleRootManager.getInstance((Module)module).getContentRoots());
            return dirs;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResourcesDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAidlDirectories() {
            VirtualFile dir = AndroidRootUtil.getAidlGenDir(this.myFacet);
            assert (dir != null);
            return Collections.singleton(dir);
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRenderscriptDirectories() {
            VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(this.myFacet);
            assert (dir != null);
            return Collections.singleton(dir);
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniLibsDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResDirectories() {
            String resRelPath = this.myFacet.getProperties().RES_FOLDER_RELATIVE_PATH;
            VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), resRelPath, true);
            if (dir != null) {
                return Collections.singleton(dir);
            }
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAssetsDirectories() {
            VirtualFile dir = AndroidRootUtil.getAssetsDir(this.myFacet);
            assert (dir != null);
            return Collections.singleton(dir);
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getShadersDirectories() {
            return Collections.emptySet();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Legacy that = (Legacy)o;
            return this.myFacet.equals((Object)that.myFacet);
        }

        public int hashCode() {
            return this.myFacet.hashCode();
        }
    }

    private static class Native
    extends IdeaSourceProvider {
        @NotNull
        private final NativeAndroidGradleFacet myFacet;

        private Native(@NotNull NativeAndroidGradleFacet facet) {
            this.myFacet = facet;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            return null;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJavaDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResourcesDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAidlDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRenderscriptDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniDirectories() {
            NativeAndroidGradleModel nativeAndroidGradleModel = this.myFacet.getNativeAndroidGradleModel();
            if (nativeAndroidGradleModel == null) {
                return Collections.emptyList();
            }
            Collection<File> sourceFolders = nativeAndroidGradleModel.getSelectedVariant().getSourceFolders();
            LinkedHashSet result = Sets.newLinkedHashSetWithExpectedSize((int)sourceFolders.size());
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File file : sourceFolders) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
                if (virtualFile == null) continue;
                result.add(virtualFile);
            }
            return result;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniLibsDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAssetsDirectories() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getShadersDirectories() {
            return Collections.emptySet();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Native that = (Native)o;
            return this.myFacet.equals((Object)that.myFacet);
        }

        public int hashCode() {
            return this.myFacet.hashCode();
        }
    }

    private static class Gradle
    extends IdeaSourceProvider {
        private final SourceProvider myProvider;
        private VirtualFile myManifestFile;
        private File myManifestIoFile;

        private Gradle(@NotNull SourceProvider provider) {
            this.myProvider = provider;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myProvider.getName();
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            File manifestFile = this.myProvider.getManifestFile();
            if (this.myManifestFile == null || !FileUtil.filesEqual((File)manifestFile, (File)this.myManifestIoFile)) {
                this.myManifestIoFile = manifestFile;
                this.myManifestFile = VfsUtil.findFileByIoFile((File)manifestFile, (boolean)false);
            }
            return this.myManifestFile;
        }

        private static Collection<VirtualFile> convertFileSet(@NotNull Collection<File> fileSet) {
            ArrayList result = Lists.newArrayListWithCapacity((int)fileSet.size());
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File file : fileSet) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
                if (virtualFile == null) continue;
                result.add(virtualFile);
            }
            return result;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJavaDirectories() {
            return Gradle.convertFileSet(this.myProvider.getJavaDirectories());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResourcesDirectories() {
            return Gradle.convertFileSet(this.myProvider.getResourcesDirectories());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAidlDirectories() {
            return Gradle.convertFileSet(this.myProvider.getAidlDirectories());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRenderscriptDirectories() {
            return Gradle.convertFileSet(this.myProvider.getRenderscriptDirectories());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniDirectories() {
            java.util.HashSet jniDirectories = Sets.newHashSet();
            jniDirectories.addAll(Gradle.convertFileSet(this.myProvider.getCDirectories()));
            jniDirectories.addAll(Gradle.convertFileSet(this.myProvider.getCppDirectories()));
            return jniDirectories;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniLibsDirectories() {
            return Gradle.convertFileSet(this.myProvider.getJniLibsDirectories());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResDirectories() {
            return Gradle.convertFileSet(this.myProvider.getResDirectories());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAssetsDirectories() {
            return Gradle.convertFileSet(this.myProvider.getAssetsDirectories());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getShadersDirectories() {
            return Gradle.convertFileSet(this.myProvider.getShadersDirectories());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Gradle that = (Gradle)o;
            if (!this.myProvider.getName().equals(that.getName())) {
                return false;
            }
            return this.myProvider.getManifestFile().getPath().equals(that.myProvider.getManifestFile().getPath());
        }

        public int hashCode() {
            return this.myProvider.getManifestFile().getPath().hashCode();
        }
    }
}

