/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidXmlResourcesUtil {
    @NonNls
    public static final String SEARCHABLE_TAG_NAME = "searchable";
    @NonNls
    public static final String KEYBOARD_TAG_NAME = "Keyboard";
    @NonNls
    public static final String DEVICE_ADMIN_TAG_NAME = "device-admin";
    @NonNls
    public static final String ACCOUNT_AUTHENTICATOR_TAG_NAME = "account-authenticator";
    @NonNls
    public static final String PREFERENCE_HEADERS_TAG_NAME = "preference-headers";
    public static final ImmutableMap<String, String> SPECIAL_STYLEABLE_NAMES = ImmutableMap.builder().put((Object)"appwidget-provider", (Object)"AppWidgetProviderInfo").put((Object)"searchable", (Object)"Searchable").put((Object)"actionkey", (Object)"SearchableActionKey").put((Object)"intent", (Object)"Intent").put((Object)"Keyboard", (Object)"Keyboard").put((Object)"Row", (Object)"Keyboard_Row").put((Object)"Key", (Object)"Keyboard_Key").put((Object)"device-admin", (Object)"DeviceAdmin").put((Object)"account-authenticator", (Object)"AccountAuthenticator").put((Object)"header", (Object)"PreferenceHeader").build();
    private static final ImmutableSet<String> ROOT_TAGS = ImmutableSet.of((Object)"appwidget-provider", (Object)"searchable", (Object)"Keyboard", (Object)"device-admin", (Object)"account-authenticator", (Object)"preference-headers", (Object[])new String[0]);

    private AndroidXmlResourcesUtil() {
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(AndroidDomUtil.removeUnambiguousNames(AttributeProcessingUtil.getPreferencesClassMap(facet)));
        result.addAll((Collection<String>)ROOT_TAGS);
        return result;
    }

    public static boolean isSupportedRootTag(@NotNull AndroidFacet facet, @NotNull String rootTagName) {
        return ROOT_TAGS.contains((Object)rootTagName) || LayoutViewClassUtils.findClassByTagName(facet, rootTagName, "android.preference.Preference") != null;
    }
}

