/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.lint;

import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueIdConverter
extends ResolvingConverter<Issue> {
    private static ImmutableMap<String, Issue> ourIssues = null;

    @NotNull
    public static ImmutableMap<String, Issue> getIdSet() {
        if (ourIssues == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Issue issue : new BuiltinIssueRegistry().getIssues()) {
                builder.put((Object)issue.getId(), (Object)issue);
            }
            ourIssues = builder.build();
        }
        return ourIssues;
    }

    @NotNull
    public Collection<Issue> getVariants(ConvertContext context) {
        return IssueIdConverter.getIdSet().values();
    }

    @Nullable
    public Issue fromString(@Nullable @NonNls String s, ConvertContext context) {
        return (Issue)IssueIdConverter.getIdSet().get((Object)s);
    }

    @Nullable
    public String toString(@Nullable Issue issue, ConvertContext context) {
        return issue == null ? null : issue.getId();
    }

    @Nullable
    public LookupElement createLookupElement(Issue issue) {
        return LookupElementBuilder.create((Object)issue, (String)issue.getId());
    }
}

