/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomCompletionContributor;
import java.util.ArrayList;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceReference
extends AndroidResourceReferenceBase {
    private final GenericDomValue<ResourceValue> myValue;

    public AndroidResourceReference(@NotNull GenericDomValue<ResourceValue> value, @NotNull AndroidFacet facet, @NotNull ResourceValue resourceValue, @Nullable TextRange range) {
        super(value, range, resourceValue, facet);
        this.myValue = value;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        Converter converter = WrappingConverter.getDeepestConverter((Converter)this.myValue.getConverter(), this.myValue);
        if ((converter instanceof EnumConverter || converter == AndroidDomUtil.BOOLEAN_CONVERTER) && DomCompletionContributor.isSchemaEnumerated((PsiElement)this.getElement())) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (converter instanceof ResolvingConverter) {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
            ArrayList<Object> result = new ArrayList<Object>();
            ConvertContext convertContext = ConvertContextFactory.createConvertContext(this.myValue);
            for (Object variant : resolvingConverter.getVariants(convertContext)) {
                String name = converter.toString(variant, convertContext);
                if (name == null) continue;
                result.add(ElementPresentationManager.getInstance().createVariant(variant, name, resolvingConverter.getPsiElement(variant)));
            }
            return result.toArray();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (newElementName.startsWith("@+id/")) {
            newElementName = AndroidResourceUtil.getResourceNameByReferenceText(newElementName);
        }
        ResourceValue value = (ResourceValue)this.myValue.getValue();
        assert (value != null);
        ResourceType resType = value.getType();
        if (resType != null && newElementName != null) {
            ResourceFolderType folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(resType);
            String newResName = folderType != null && newElementName.contains(".") ? AndroidCommonUtils.getResourceName((String)resType.getName(), (String)newElementName) : newElementName;
            this.myValue.setValue((Object)ResourceValue.referenceTo(value.getPrefix(), value.getNamespace(), value.getResourceType(), newResName));
        }
        return this.myValue.getXmlTag();
    }
}

