/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.DefaultXmlExtension;
import org.jetbrains.android.dom.AndroidClassTagNameReference;
import org.jetbrains.android.dom.AndroidXmlReferenceProvider;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlExtension
extends DefaultXmlExtension {
    private static final SchemaPrefix EMPTY_SCHEMA = new SchemaPrefix(null, new TextRange(0, 0), "android");

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return AndroidXmlReferenceProvider.areReferencesProvidedByReferenceProvider(nameElement) ? null : new AndroidClassTagNameReference(nameElement, startTagFlag);
    }

    public boolean isAvailable(final PsiFile file) {
        if (file instanceof XmlFile) {
            if (AndroidFacet.getInstance((PsiElement)file) == null) {
                return false;
            }
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return AndroidResourceUtil.isInResourceSubdirectory(file, null) || ManifestDomFileDescription.isManifestFile((XmlFile)file) || "lint.xml".equals(file.getName());
                }
            });
        }
        return false;
    }

    public SchemaPrefix getPrefixDeclaration(XmlTag context, String namespacePrefix) {
        SchemaPrefix prefix = super.getPrefixDeclaration(context, namespacePrefix);
        if (prefix != null) {
            return prefix;
        }
        if (namespacePrefix.isEmpty()) {
            return EMPTY_SCHEMA;
        }
        return null;
    }
}

