/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidResourceDomFileDescription<T extends DomElement>
extends DomFileDescription<T> {
    protected final ResourceFolderType myResourceType;

    public AndroidResourceDomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, @NotNull ResourceFolderType resourceType) {
        super(rootElementClass, rootTagName, new String[0]);
        this.myResourceType = resourceType;
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        return AndroidResourceDomFileDescription.doIsMyFile(file, this.myResourceType);
    }

    public static boolean doIsMyFile(final XmlFile file, final ResourceFolderType resourceType) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (file.getProject().isDisposed()) {
                    return false;
                }
                if (AndroidResourceUtil.isInResourceSubdirectory((PsiFile)file, resourceType.getName())) {
                    return AndroidFacet.getInstance((PsiElement)file) != null;
                }
                return false;
            }
        });
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
    }

    @NotNull
    public ResourceFolderType getResourceType() {
        return this.myResourceType;
    }
}

