/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.attrs.ToolsAttributeDefinitionsImpl;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.DimensionConverter;
import org.jetbrains.android.dom.converters.FlagConverter;
import org.jetbrains.android.dom.converters.FragmentClassConverter;
import org.jetbrains.android.dom.converters.IntegerConverter;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StaticEnumConverter;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.manifest.Action;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Category;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Provider;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.dom.menu.MenuItem;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomUtil {
    public static final StaticEnumConverter BOOLEAN_CONVERTER = new StaticEnumConverter("true", "false");
    public static final Map<String, ResourceType> SPECIAL_RESOURCE_TYPES = Maps.newHashMapWithExpectedSize((int)40);
    private static final PackageClassConverter ACTIVITY_CONVERTER = new PackageClassConverter("android.app.Activity");
    private static final FragmentClassConverter FRAGMENT_CLASS_CONVERTER = new FragmentClassConverter();
    private static final ToolsAttributeDefinitionsImpl TOOLS_ATTRIBUTE_DEFINITIONS = new ToolsAttributeDefinitionsImpl();
    public static final List<String> AVAILABLE_FAMILIES = ImmutableList.of((Object)"sans-serif", (Object)"sans-serif-condensed", (Object)"serif", (Object)"monospace", (Object)"serif-monospace", (Object)"casual", (Object)"cursive", (Object)"sans-serif-smallcaps");

    private AndroidDomUtil() {
    }

    @Nullable
    public static ResourceType getResourceType(@NotNull AttributeFormat format) {
        switch (format) {
            case Color: {
                return ResourceType.COLOR;
            }
            case Dimension: {
                return ResourceType.DIMEN;
            }
            case String: {
                return ResourceType.STRING;
            }
            case Float: 
            case Integer: {
                return ResourceType.INTEGER;
            }
            case Fraction: {
                return ResourceType.FRACTION;
            }
            case Boolean: {
                return ResourceType.BOOL;
            }
        }
        return null;
    }

    @Nullable
    public static ResolvingConverter<String> getStringConverter(@NotNull AttributeFormat format, @NotNull String[] values) {
        switch (format) {
            case Enum: {
                return new StaticEnumConverter(values);
            }
            case Boolean: {
                return BOOLEAN_CONVERTER;
            }
            case Integer: {
                return IntegerConverter.INSTANCE;
            }
            case Dimension: {
                return DimensionConverter.INSTANCE;
            }
        }
        return null;
    }

    @Nullable
    public static ResourceReferenceConverter getResourceReferenceConverter(@NotNull AttributeDefinition attr) {
        boolean containsReference = false;
        boolean containsNotReference = false;
        EnumSet<ResourceType> resourceTypes = EnumSet.noneOf(ResourceType.class);
        Set<AttributeFormat> formats = attr.getFormats();
        for (AttributeFormat format : formats) {
            ResourceType type;
            if (format == AttributeFormat.Reference) {
                containsReference = true;
            } else {
                containsNotReference = true;
            }
            if ((type = AndroidDomUtil.getResourceType(format)) == null) continue;
            resourceTypes.add(type);
        }
        ResourceType specialResourceType = AndroidDomUtil.getSpecialResourceType(attr.getName());
        if (specialResourceType != null) {
            resourceTypes.add(specialResourceType);
        }
        if (containsReference) {
            if (resourceTypes.contains(ResourceType.COLOR)) {
                resourceTypes.add(ResourceType.DRAWABLE);
            }
            if (resourceTypes.contains(ResourceType.DRAWABLE)) {
                resourceTypes.add(ResourceType.MIPMAP);
            }
            if (resourceTypes.size() == 0) {
                resourceTypes.addAll(AndroidResourceUtil.REFERRABLE_RESOURCE_TYPES);
            }
        }
        if (resourceTypes.size() > 0) {
            ResourceReferenceConverter converter = new ResourceReferenceConverter(resourceTypes, attr);
            converter.setAllowLiterals(containsNotReference);
            return converter;
        }
        return null;
    }

    @Nullable
    public static Converter getSpecificConverter(@NotNull XmlName attrName, DomElement context) {
        if (context == null) {
            return null;
        }
        if (!"http://schemas.android.com/apk/res/android".equals(attrName.getNamespaceKey())) {
            return null;
        }
        XmlTag xmlTag = context.getXmlTag();
        if (xmlTag == null) {
            return null;
        }
        String localName = attrName.getLocalName();
        String tagName = xmlTag.getName();
        if (context instanceof XmlResourceElement) {
            if ("configure".equals(localName) && "appwidget-provider".equals(tagName)) {
                return ACTIVITY_CONVERTER;
            }
            if ("fragment".equals(localName)) {
                return FRAGMENT_CLASS_CONVERTER;
            }
        } else if ((context instanceof LayoutViewElement || context instanceof MenuItem) && "onClick".equals(localName)) {
            return context instanceof LayoutViewElement ? OnClickConverter.CONVERTER_FOR_LAYOUT : OnClickConverter.CONVERTER_FOR_MENU;
        }
        return null;
    }

    @Nullable
    public static ResolvingConverter getConverter(@NotNull AttributeDefinition attr) {
        Set<AttributeFormat> formats = attr.getFormats();
        CompositeConverter.Builder compositeBuilder = new CompositeConverter.Builder();
        String[] values = attr.getValues();
        boolean containsUnsupportedFormats = false;
        if ("fontFamily".equals(attr.getName())) {
            compositeBuilder.addConverter(new StaticEnumConverter(AVAILABLE_FAMILIES).setContainsAllValues(false));
        }
        for (AttributeFormat format : formats) {
            ResolvingConverter<String> converter = AndroidDomUtil.getStringConverter(format, values);
            if (converter != null) {
                compositeBuilder.addConverter(converter);
                continue;
            }
            containsUnsupportedFormats = true;
        }
        ResourceReferenceConverter resConverter = AndroidDomUtil.getResourceReferenceConverter(attr);
        if (formats.contains((Object)AttributeFormat.Flag)) {
            return new FlagConverter(compositeBuilder.build(), values);
        }
        if (resConverter == null && formats.contains((Object)AttributeFormat.Enum)) {
            resConverter = new ResourceReferenceConverter(EnumSet.of(ResourceType.INTEGER), attr);
            resConverter.setQuiet(true);
        }
        ResolvingConverter<String> stringConverter = compositeBuilder.build();
        if (resConverter != null) {
            resConverter.setAdditionalConverter(stringConverter, containsUnsupportedFormats);
            return resConverter;
        }
        return stringConverter;
    }

    @Nullable
    public static ResourceType getSpecialResourceType(String attrName) {
        ResourceType type = SPECIAL_RESOURCE_TYPES.get(attrName);
        if (type != null) {
            return type;
        }
        if (attrName.endsWith("Animation")) {
            return ResourceType.ANIM;
        }
        return null;
    }

    static void addSpecialResourceType(ResourceType type, String ... attrs) {
        for (String attr : attrs) {
            SPECIAL_RESOURCE_TYPES.put(attr, type);
        }
    }

    public static boolean containsAction(@NotNull IntentFilter filter, @NotNull String name) {
        for (Action action : filter.getActions()) {
            if (!name.equals(action.getName().getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCategory(@NotNull IntentFilter filter, @NotNull String name) {
        for (Category category : filter.getCategories()) {
            if (!name.equals(category.getName().getValue())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Activity getActivityDomElementByClass(@NotNull List<Activity> activities, PsiClass c) {
        for (Activity activity : activities) {
            PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
            if (!c.getManager().areElementsEquivalent((PsiElement)c, (PsiElement)activityClass)) continue;
            return activity;
        }
        return null;
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull AndroidFacet facet, @NotNull XmlAttribute attribute) {
        AttributeDefinitions attrDefs;
        ResourceManager manager;
        String localName = attribute.getLocalName();
        String namespace = attribute.getNamespace();
        boolean isFramework = namespace.equals("http://schemas.android.com/apk/res/android");
        if (!isFramework && "http://schemas.android.com/tools".equals(namespace)) {
            isFramework = true;
            AttributeDefinition toolsAttr = TOOLS_ATTRIBUTE_DEFINITIONS.getAttrDefByName(localName);
            if (toolsAttr != null) {
                return toolsAttr;
            }
        }
        if ((manager = facet.getResourceManager(isFramework ? "android" : null)) != null && (attrDefs = manager.getAttributeDefinitions()) != null) {
            return attrDefs.getAttrDefByName(localName);
        }
        return null;
    }

    @NotNull
    public static Collection<String> removeUnambiguousNames(@NotNull Map<String, PsiClass> viewClassMap) {
        HashMap class2Name = new HashMap();
        for (String tagName : viewClassMap.keySet()) {
            String qName;
            String prevTagName;
            PsiClass viewClass = viewClassMap.get(tagName);
            if (AndroidUtils.isAbstract(viewClass) || (prevTagName = (String)class2Name.get(qName = viewClass.getQualifiedName())) != null && tagName.indexOf(46) != -1) continue;
            class2Name.put(qName, tagName);
        }
        return class2Name.values();
    }

    @Nullable
    public static AndroidResourceReferenceBase getAndroidResourceReference(@Nullable GenericAttributeValue<ResourceValue> attribute, boolean localOnly) {
        if (attribute == null) {
            return null;
        }
        ResourceValue resValue = (ResourceValue)attribute.getValue();
        if (resValue == null || localOnly && resValue.getNamespace() != null) {
            return null;
        }
        XmlAttributeValue value = attribute.getXmlAttributeValue();
        if (value == null) {
            return null;
        }
        for (PsiReference reference : value.getReferences()) {
            if (!(reference instanceof AndroidResourceReferenceBase)) continue;
            return (AndroidResourceReferenceBase)reference;
        }
        return null;
    }

    @Nullable
    public static AndroidAttributeValue<PsiClass> findComponentDeclarationInManifest(@NotNull PsiClass aClass) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)aClass);
        if (facet == null) {
            return null;
        }
        boolean isActivity = AndroidDomUtil.isInheritor(aClass, "android.app.Activity");
        boolean isService = AndroidDomUtil.isInheritor(aClass, "android.app.Service");
        boolean isReceiver = AndroidDomUtil.isInheritor(aClass, "android.content.BroadcastReceiver");
        boolean isProvider = AndroidDomUtil.isInheritor(aClass, "android.content.ContentProvider");
        if (!(isActivity || isService || isReceiver || isProvider)) {
            return null;
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return null;
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return null;
        }
        if (isActivity) {
            for (Activity activity : application.getActivities()) {
                AndroidAttributeValue<PsiClass> activityClass = activity.getActivityClass();
                if (activityClass.getValue() != aClass) continue;
                return activityClass;
            }
        } else if (isService) {
            for (Service service : application.getServices()) {
                AndroidAttributeValue<PsiClass> serviceClass = service.getServiceClass();
                if (serviceClass.getValue() != aClass) continue;
                return serviceClass;
            }
        } else if (isReceiver) {
            for (Receiver receiver : application.getReceivers()) {
                AndroidAttributeValue<PsiClass> receiverClass = receiver.getReceiverClass();
                if (receiverClass.getValue() != aClass) continue;
                return receiverClass;
            }
        } else {
            for (Provider provider : application.getProviders()) {
                AndroidAttributeValue<PsiClass> providerClass = provider.getProviderClass();
                if (providerClass.getValue() != aClass) continue;
                return providerClass;
            }
        }
        return null;
    }

    public static boolean isInheritor(@NotNull PsiClass aClass, @NotNull String baseClassQName) {
        Project project = aClass.getProject();
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)project).findClass(baseClassQName, aClass.getResolveScope());
        return baseClass != null && aClass.isInheritor(baseClass, true);
    }

    static {
        AndroidDomUtil.addSpecialResourceType(ResourceType.STRING, "label", "description", "title");
        AndroidDomUtil.addSpecialResourceType(ResourceType.DRAWABLE, "icon");
        AndroidDomUtil.addSpecialResourceType(ResourceType.STYLE, "theme", "style");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ANIM, "animation");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ID, "id", "layout_toRightOf", "layout_toLeftOf", "layout_above", "layout_below", "layout_alignBaseline", "layout_alignLeft", "layout_alignTop", "layout_alignRight", "layout_alignBottom", "layout_alignStart", "layout_alignEnd", "layout_toStartOf", "layout_toEndOf", "checkedButton", "accessibilityTraversalBefore", "accessibilityTraversalAfter", "labelFor", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBaseline_toBaselineOf");
        AndroidDomUtil.addSpecialResourceType(ResourceType.LAYOUT, "listitem", "layout");
    }
}

