/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidFinalPackageElementType
extends PackagingElementType<AndroidFinalPackageElement> {
    @NonNls
    public static final String TYPE_ID = "android-final-package";

    protected AndroidFinalPackageElementType() {
        super(TYPE_ID, "Android Final Package");
    }

    public static AndroidFinalPackageElementType getInstance() {
        return (AndroidFinalPackageElementType)AndroidFinalPackageElementType.getInstance(AndroidFinalPackageElementType.class);
    }

    public Icon getCreateElementIcon() {
        return AndroidIcons.Android;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        return AndroidFinalPackageElementType.getAndroidApplicationFacets(context, context.getModulesProvider().getModules()).size() > 0 && !AndroidArtifactUtil.containsAndroidPackage(context, artifact);
    }

    @NotNull
    private static List<AndroidFacet> getAndroidApplicationFacets(@NotNull ArtifactEditorContext context, @NotNull Module[] modules) {
        ArrayList<AndroidFacet> result = new ArrayList<AndroidFacet>();
        for (Module module : modules) {
            for (AndroidFacet facet : context.getFacetsProvider().getFacetsByType(module, AndroidFacet.ID)) {
                if (facet.isLibraryProject()) continue;
                result.add(facet);
            }
        }
        return result;
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        List<AndroidFacet> facets = AndroidFinalPackageElementType.getAndroidApplicationFacets(context, context.getModulesProvider().getModules());
        AndroidFacet facet = AndroidArtifactUtil.chooseAndroidApplicationModule(context.getProject(), facets);
        if (facet == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new AndroidFinalPackageElement(context.getProject(), facet));
    }

    @NotNull
    public AndroidFinalPackageElement createEmpty(@NotNull Project project) {
        return new AndroidFinalPackageElement(project, null);
    }
}

