/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.compiler.artifact.ApkSigningSettingsForm;
import org.jetbrains.android.compiler.artifact.ProGuardConfigFilesPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidArtifactPropertiesEditor
extends ArtifactPropertiesEditor
implements ApkSigningSettingsForm {
    private final AndroidApplicationArtifactProperties myProperties;
    private JPanel myPanel;
    private JPanel myCertificatePanel;
    private JPasswordField myKeyStorePasswordField;
    private JTextField myKeyStorePathField;
    private JPasswordField myKeyPasswordField;
    private TextFieldWithBrowseButton.NoPathCompletion myKeyAliasField;
    private JButton myLoadKeyStoreButton;
    private JButton myCreateKeyStoreButton;
    private JCheckBox myProGuardCheckBox;
    private JPanel myProGuardConfigPanel;
    private JPanel myKeyStoreButtonsPanel;
    private JPanel myProGuardPanel;
    private ProGuardConfigFilesPanel myProGuardConfigFilesPanel;
    private ComboBox myTypeCombo;
    private final Artifact myArtifact;
    private final Project myProject;

    public AndroidArtifactPropertiesEditor(@Nullable Artifact artifact, AndroidApplicationArtifactProperties properties, @NotNull Project project) {
        this.myProperties = properties;
        this.myArtifact = artifact;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myKeyStoreButtonsPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)5, (int)0));
        this.myProGuardPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
        this.myTypeCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                AndroidArtifactSigningMode mode = (AndroidArtifactSigningMode)value;
                this.setText(AndroidArtifactPropertiesEditor.getPresentableText(mode));
            }
        });
        this.myTypeCombo.setModel((ComboBoxModel)new EnumComboBoxModel(AndroidArtifactSigningMode.class));
        this.myTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidArtifactSigningMode mode = AndroidArtifactPropertiesEditor.this.getSigningMode();
                UIUtil.setEnabled((Component)AndroidArtifactPropertiesEditor.this.myCertificatePanel, (mode == AndroidArtifactSigningMode.RELEASE_SIGNED || mode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE ? 1 : 0) != 0, (boolean)true);
            }
        });
        AndroidUiUtil.initSigningSettingsForm(project, this);
        this.myProGuardCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)AndroidArtifactPropertiesEditor.this.myProGuardConfigPanel, (boolean)AndroidArtifactPropertiesEditor.this.myProGuardCheckBox.isSelected(), (boolean)true);
            }
        });
    }

    @NotNull
    private static String getPresentableText(@Nullable AndroidArtifactSigningMode mode) {
        if (mode == null) {
            return "";
        }
        switch (mode) {
            case DEBUG: {
                return "Debug signed with default certificate";
            }
            case DEBUG_WITH_CUSTOM_CERTIFICATE: {
                return "Debug signed with custom certificate";
            }
            case RELEASE_UNSIGNED: {
                return "Release unsigned";
            }
            case RELEASE_SIGNED: {
                return "Release signed";
            }
        }
        return "";
    }

    private String getKeyStorePath() {
        return this.myKeyStorePathField.getText().trim();
    }

    public String getTabName() {
        return "Android";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.getSigningMode() != this.myProperties.getSigningMode() || !this.getKeyStoreFileUrl().equals(this.myProperties.getKeyStoreUrl()) || !this.getKeyStorePassword().equals(this.myProperties.getPlainKeystorePassword()) || !this.getKeyAlias().equals(this.myProperties.getKeyAlias()) || !this.getKeyPassword().equals(this.myProperties.getPlainKeyPassword()) || this.myProGuardCheckBox.isSelected() != this.myProperties.isRunProGuard() || !this.myProGuardConfigFilesPanel.getUrls().equals(this.myProperties.getProGuardCfgFiles());
    }

    public void apply() {
        this.myProperties.setSigningMode(this.getSigningMode());
        this.myProperties.setKeyStoreUrl(this.getKeyStoreFileUrl());
        this.myProperties.setPlainKeystorePassword(this.getKeyStorePassword());
        this.myProperties.setKeyAlias(this.getKeyAlias());
        this.myProperties.setPlainKeyPassword(this.getKeyPassword());
        this.myProperties.setRunProGuard(this.myProGuardCheckBox.isSelected());
        this.myProperties.setProGuardCfgFiles(this.myProGuardConfigFilesPanel.getUrls());
    }

    public void reset() {
        this.myTypeCombo.setSelectedItem((Object)this.myProperties.getSigningMode());
        String keyStoreUrl = this.myProperties.getKeyStoreUrl();
        this.myKeyStorePathField.setText(keyStoreUrl != null ? FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)keyStoreUrl)) : "");
        this.myKeyStorePasswordField.setText(this.myProperties.getPlainKeystorePassword());
        String keyAlias = this.myProperties.getKeyAlias();
        this.myKeyAliasField.setText(keyAlias != null ? keyAlias : "");
        this.myKeyPasswordField.setText(this.myProperties.getPlainKeyPassword());
        this.myProGuardCheckBox.setSelected(this.myProperties.isRunProGuard());
        this.myProGuardConfigFilesPanel.setUrls(this.myProperties.getProGuardCfgFiles());
        UIUtil.setEnabled((Component)this.myCertificatePanel, (this.myProperties.getSigningMode() == AndroidArtifactSigningMode.RELEASE_SIGNED ? 1 : 0) != 0, (boolean)true);
        UIUtil.setEnabled((Component)this.myProGuardConfigPanel, (boolean)this.myProperties.isRunProGuard(), (boolean)true);
    }

    public void disposeUIResources() {
    }

    @NotNull
    private AndroidArtifactSigningMode getSigningMode() {
        return (AndroidArtifactSigningMode)this.myTypeCombo.getSelectedItem();
    }

    @NotNull
    private String getKeyStoreFileUrl() {
        String path = this.getKeyStorePath();
        return VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)path));
    }

    @NotNull
    private String getKeyStorePassword() {
        return String.valueOf(this.myKeyStorePasswordField.getPassword());
    }

    @NotNull
    private String getKeyAlias() {
        return this.myKeyAliasField.getText().trim();
    }

    @NotNull
    private String getKeyPassword() {
        return String.valueOf(this.myKeyPasswordField.getPassword());
    }

    @Override
    public JButton getLoadKeyStoreButton() {
        return this.myLoadKeyStoreButton;
    }

    @Override
    public JTextField getKeyStorePathField() {
        return this.myKeyStorePathField;
    }

    @Override
    public JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    public JButton getCreateKeyStoreButton() {
        return this.myCreateKeyStoreButton;
    }

    @Override
    public JPasswordField getKeyStorePasswordField() {
        return this.myKeyStorePasswordField;
    }

    @Override
    public TextFieldWithBrowseButton getKeyAliasField() {
        return this.myKeyAliasField;
    }

    @Override
    public JPasswordField getKeyPasswordField() {
        return this.myKeyPasswordField;
    }

    private void createUIComponents() {
        this.myProGuardConfigFilesPanel = new ProGuardConfigFilesPanel(){

            @Override
            @Nullable
            protected AndroidFacet getFacet() {
                return AndroidArtifactUtil.getPackagedFacet(AndroidArtifactPropertiesEditor.this.myProject, AndroidArtifactPropertiesEditor.this.myArtifact);
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        JTextField jTextField;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JPasswordField jPasswordField;
        JPasswordField jPasswordField2;
        JPanel jPanel2;
        ComboBox comboBox;
        JPanel jPanel3;
        JCheckBox jCheckBox;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myProGuardPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myProGuardCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Run ProGuard");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myProGuardConfigPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        ProGuardConfigFilesPanel proGuardConfigFilesPanel = this.myProGuardConfigFilesPanel;
        jPanel3.add((Component)proGuardConfigFilesPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Type:");
        jBLabel.setDisplayedMnemonic('T');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTypeCombo = comboBox = new ComboBox();
        jPanel6.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCertificatePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Key store path: ");
        jBLabel2.setDisplayedMnemonic('K');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Key store password:");
        jBLabel3.setDisplayedMnemonic('P');
        jBLabel3.setDisplayedMnemonicIndex(10);
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyStorePasswordField = jPasswordField2 = new JPasswordField();
        jPanel2.add((Component)jPasswordField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Key alias: ");
        jBLabel4.setDisplayedMnemonic('E');
        jBLabel4.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Key password:");
        jBLabel5.setDisplayedMnemonic('W');
        jBLabel5.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jBLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyPasswordField = jPasswordField = new JPasswordField();
        jPanel2.add((Component)jPasswordField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myKeyAliasField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel2.add((Component)noPathCompletion, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myKeyStorePathField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myKeyStoreButtonsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCreateKeyStoreButton = jButton2 = new JButton();
        jButton2.setText("Create new...");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myLoadKeyStoreButton = jButton = new JButton();
        jButton.setText("Choose existing...");
        jButton.setMnemonic('H');
        jButton.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        jBLabel.setLabelFor((Component)comboBox);
        jBLabel2.setLabelFor(jTextField);
        jBLabel3.setLabelFor(jPasswordField2);
        jBLabel4.setLabelFor((Component)noPathCompletion);
        jBLabel5.setLabelFor(jPasswordField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

