/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.util.Base64;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesEditor;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidApplicationArtifactProperties
extends ArtifactProperties<AndroidApplicationArtifactProperties> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties");
    private AndroidArtifactSigningMode mySigningMode = AndroidArtifactSigningMode.RELEASE_UNSIGNED;
    private String myKeyStoreUrl = "";
    private String myKeyStorePassword = "";
    private String myKeyAlias = "";
    private String myKeyPassword = "";
    private boolean myRunProGuard;
    private List<String> myProGuardCfgFiles = new ArrayList<String>();

    public void onBuildFinished(@NotNull Artifact artifact, @NotNull CompileContext context) {
        if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType)) {
            return;
        }
        if (this.mySigningMode != AndroidArtifactSigningMode.RELEASE_SIGNED && this.mySigningMode != AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) {
            return;
        }
        AndroidFacet facet = AndroidArtifactUtil.getPackagedFacet(context.getProject(), artifact);
        if (facet == null) {
            return;
        }
        String artifactName = artifact.getName();
        String messagePrefix = "[Artifact '" + artifactName + "'] ";
        Module module = facet.getModule();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            context.addMessage(CompilerMessageCategory.ERROR, messagePrefix + AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
            return;
        }
        String sdkLocation = platform.getSdkData().getPath();
        String artifactFilePath = artifact.getOutputFilePath();
        String keyStorePath = this.myKeyStoreUrl != null ? VfsUtilCore.urlToPath((String)this.myKeyStoreUrl) : "";
        String keyStorePassword = this.myKeyStorePassword != null && this.myKeyStorePassword.length() > 0 ? this.getPlainKeystorePassword() : null;
        String keyPassword = this.myKeyPassword != null && this.myKeyPassword.length() > 0 ? this.getPlainKeyPassword() : null;
        try {
            Map messages = AndroidCommonUtils.buildArtifact((String)artifactName, (String)messagePrefix, (String)sdkLocation, (IAndroidTarget)platform.getTarget(), (String)artifactFilePath, (String)keyStorePath, (String)this.myKeyAlias, (String)keyStorePassword, (String)keyPassword);
            AndroidCompileUtil.addMessages(context, AndroidCompileUtil.toCompilerMessageCategoryKeys(messages), null);
        }
        catch (GeneralSecurityException e) {
            AndroidCompileUtil.reportException(context, messagePrefix, e);
        }
        catch (IOException e) {
            AndroidCompileUtil.reportException(context, messagePrefix, e);
        }
    }

    public ArtifactPropertiesEditor createEditor(@NotNull ArtifactEditorContext context) {
        return new AndroidArtifactPropertiesEditor(context.getArtifact(), this, context.getProject());
    }

    public AndroidApplicationArtifactProperties getState() {
        return this;
    }

    public void loadState(AndroidApplicationArtifactProperties state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public AndroidArtifactSigningMode getSigningMode() {
        return this.mySigningMode;
    }

    public void setSigningMode(AndroidArtifactSigningMode signingMode) {
        this.mySigningMode = signingMode;
    }

    public String getKeyStoreUrl() {
        return this.myKeyStoreUrl;
    }

    public String getKeyStorePassword() {
        return this.myKeyStorePassword;
    }

    public String getKeyAlias() {
        return this.myKeyAlias;
    }

    public String getKeyPassword() {
        return this.myKeyPassword;
    }

    public void setKeyStoreUrl(String keyStoreUrl) {
        this.myKeyStoreUrl = keyStoreUrl;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.myKeyStorePassword = keyStorePassword;
    }

    public void setKeyAlias(String keyAlias) {
        this.myKeyAlias = keyAlias;
    }

    public void setKeyPassword(String keyPassword) {
        this.myKeyPassword = keyPassword;
    }

    @Transient
    @NotNull
    public String getPlainKeystorePassword() {
        return new String(Base64.decode((String)this.myKeyStorePassword));
    }

    @Transient
    public void setPlainKeystorePassword(@NotNull String password) {
        this.myKeyStorePassword = Base64.encode((byte[])password.getBytes(CharsetToolkit.UTF8_CHARSET));
    }

    @Transient
    @NotNull
    public String getPlainKeyPassword() {
        return new String(Base64.decode((String)this.myKeyPassword), CharsetToolkit.UTF8_CHARSET);
    }

    @Transient
    public void setPlainKeyPassword(@NotNull String password) {
        this.myKeyPassword = Base64.encode((byte[])password.getBytes(CharsetToolkit.UTF8_CHARSET));
    }

    public boolean isRunProGuard() {
        return this.myRunProGuard;
    }

    public void setRunProGuard(boolean runProGuard) {
        this.myRunProGuard = runProGuard;
    }

    public List<String> getProGuardCfgFiles() {
        return this.myProGuardCfgFiles;
    }

    public void setProGuardCfgFiles(List<String> proGuardCfgFiles) {
        this.myProGuardCfgFiles = proGuardCfgFiles;
    }
}

