/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidLightClass
extends AndroidLightClassBase {
    private final PsiClass myContainingClass;
    protected final String myName;

    protected AndroidLightClass(@NotNull PsiClass context, @NotNull String name) {
        super(context.getManager());
        this.myContainingClass = context;
        this.myName = name;
    }

    public String toString() {
        return "AndroidRClass";
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot add elements to R class");
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.myContainingClass.add(element);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myContainingClass.addBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myContainingClass.addAfter(element, anchor);
    }

    public String getQualifiedName() {
        return this.myContainingClass.getQualifiedName() + '.' + this.myName;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.myContainingClass;
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public String getName() {
        return this.myName;
    }

    public PsiElement getParent() {
        return this.myContainingClass;
    }
}

