/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.gradle.util.Projects;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.android.exportSignedPackage.CheckModulePanel;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class GenerateSignedApkAction
extends AnAction {
    public GenerateSignedApkAction() {
        super(AndroidBundle.message("android.generate.signed.apk.action.text", new Object[0]));
    }

    private static boolean checkFacet(@NotNull AndroidFacet facet) {
        final CheckModulePanel panel = new CheckModulePanel();
        panel.updateMessages(facet);
        final boolean hasError = panel.hasError();
        if (hasError || panel.hasWarnings()) {
            DialogWrapper dialog = new DialogWrapper(facet.getModule().getProject()){
                {
                    super(arg0);
                    if (!hasError) {
                        this.setOKButtonText("Continue");
                    }
                    this.init();
                }

                @NotNull
                protected Action[] createActions() {
                    if (hasError) {
                        return new Action[]{this.getOKAction()};
                    }
                    return super.createActions();
                }

                protected JComponent createCenterPanel() {
                    return panel;
                }
            };
            dialog.setTitle(hasError ? CommonBundle.getErrorTitle() : CommonBundle.getWarningTitle());
            dialog.show();
            return !hasError && dialog.isOK();
        }
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        List<AndroidFacet> facets = AndroidUtils.getApplicationFacets(project);
        assert (!facets.isEmpty());
        if (facets.size() == 1 && !GenerateSignedApkAction.checkFacet(facets.get(0))) {
            return;
        }
        ExportSignedPackageWizard wizard = new ExportSignedPackageWizard(project, facets, true);
        wizard.show();
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        boolean enabled = project != null && !AndroidUtils.getApplicationFacets(project).isEmpty() && (Projects.isBuildWithGradle(project) || !Projects.requiresAndroidModel(project));
        e.getPresentation().setEnabledAndVisible(enabled);
    }
}

