/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioButtonGroupBinding<E>
extends ScopedDataBinder.ComponentBinding<E, JRadioButton> {
    private final Map<JRadioButton, E> myValueToButtonBinding;

    public RadioButtonGroupBinding(Map<JRadioButton, E> buttonToValue) {
        this.myValueToButtonBinding = ImmutableMap.copyOf(buttonToValue);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (JRadioButton button : buttonToValue.keySet()) {
            buttonGroup.add(button);
        }
    }

    @Override
    public void setValue(@Nullable E newValue, @NotNull JRadioButton component) {
        component.setSelected(Objects.equal(newValue, this.myValueToButtonBinding.get(component)));
    }

    @Override
    @Nullable
    public E getValue(@NotNull JRadioButton component) {
        for (Map.Entry<JRadioButton, E> buttonToValue : this.myValueToButtonBinding.entrySet()) {
            if (!buttonToValue.getKey().isSelected()) continue;
            return buttonToValue.getValue();
        }
        return null;
    }

    @Override
    public void addActionListener(@NotNull ActionListener listener, @NotNull JRadioButton component) {
        component.addActionListener(listener);
    }
}

