/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.InstallComponentsPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Platform
extends InstallableComponent {
    private final AndroidVersion myVersion;
    private final boolean myIsDefaultPlatform;

    public Platform(@NotNull ScopedStateStore store, @NotNull String name, @NotNull String description, AndroidVersion version, boolean isDefaultPlatform, boolean installUpdates) {
        super(store, name, description, installUpdates, FileOpUtils.create());
        this.myVersion = version;
        this.myIsDefaultPlatform = isDefaultPlatform;
    }

    @Nullable
    private static Platform getLatestPlatform(@NotNull ScopedStateStore store, @Nullable Map<String, RemotePackage> remotePackages, boolean installUpdates) {
        RemotePackage latest = InstallComponentsPath.findLatestPlatform(remotePackages);
        if (latest != null) {
            AndroidVersion version = ((DetailsTypes.PlatformDetailsType)latest.getTypeDetails()).getAndroidVersion();
            String versionName = SdkVersionInfo.getAndroidName((int)version.getFeatureLevel());
            String description = "Android platform libraries for targeting " + versionName + " platform";
            return new Platform(store, versionName, description, version, !version.isPreview(), installUpdates);
        }
        return null;
    }

    @NotNull
    private static List<AndroidVersion> getInstalledPlatformVersions(@Nullable AndroidSdkHandler handler) {
        ArrayList result = Lists.newArrayList();
        if (handler != null) {
            RepositoryPackages packages = handler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(Platform.class)).getPackages();
            for (LocalPackage p : packages.getLocalPackages().values()) {
                if (!(p.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType)) continue;
                result.add(((DetailsTypes.PlatformDetailsType)p.getTypeDetails()).getAndroidVersion());
            }
        }
        return result;
    }

    @Nullable
    public static ComponentTreeNode createSubtree(@NotNull ScopedStateStore store, @Nullable Map<String, RemotePackage> remotePackages, boolean installUpdates) {
        Platform latestPlatform = Platform.getLatestPlatform(store, remotePackages, installUpdates);
        if (latestPlatform != null) {
            return new ComponentCategory("Android SDK Platform", "SDK components for creating applications for different Android platforms", latestPlatform);
        }
        return null;
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        ArrayList requests = Lists.newArrayList((Object[])new String[]{DetailsTypes.getPlatformPath((AndroidVersion)this.myVersion), DetailsTypes.getSourcesPath((AndroidVersion)this.myVersion)});
        String buildTool = this.findLatestCompatibleBuildTool();
        if (buildTool != null) {
            requests.add(buildTool);
        }
        return requests;
    }

    private String findLatestCompatibleBuildTool() {
        Revision revision = null;
        String path = null;
        for (RemotePackage remote : this.getRepositoryPackages().getRemotePackages().values()) {
            Revision testRevision;
            if (!remote.getPath().startsWith("build-tools") || (testRevision = remote.getVersion()).getMajor() != this.myVersion.getApiLevel() || revision != null && testRevision.compareTo(revision) <= 0) continue;
            revision = testRevision;
            path = remote.getPath();
        }
        return path;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
    }

    @Override
    public boolean isOptionalForSdkLocation() {
        List<AndroidVersion> locals = Platform.getInstalledPlatformVersions(this.mySdkHandler);
        if (locals.isEmpty()) {
            return !this.myIsDefaultPlatform;
        }
        for (AndroidVersion androidVersion : locals) {
            int apiLevel;
            int n = apiLevel = androidVersion == null ? 0 : androidVersion.getApiLevel();
            if (this.myVersion.getFeatureLevel() != apiLevel) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }
}

