/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.model.SelectionHandles;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class SelectionLayer
extends Layer {
    private final ScreenView myScreenView;

    public SelectionLayer(@NotNull ScreenView screenView) {
        this.myScreenView = screenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        SelectionModel model = this.myScreenView.getSelectionModel();
        for (NlComponent component : model.getSelection()) {
            if (component.isRoot() || !component.isShowing() || SelectionLayer.parentHandlingSelection(component)) continue;
            int x = Coordinates.getSwingX(this.myScreenView, component.x);
            int y = Coordinates.getSwingY(this.myScreenView, component.y);
            int w = Coordinates.getSwingDimension(this.myScreenView, component.w);
            int h = Coordinates.getSwingDimension(this.myScreenView, component.h);
            NlGraphics.drawRect(NlDrawingStyle.SELECTION, gc, x, y, w + 1, h + 1);
            SelectionHandles handles = model.getHandles(component);
            for (SelectionHandle handle : handles) {
                int sx = Coordinates.getSwingX(this.myScreenView, handle.getCenterX());
                int sy = Coordinates.getSwingY(this.myScreenView, handle.getCenterY());
                NlGraphics.drawFilledRect(NlDrawingStyle.SELECTION, gc, sx - 4, sy - 4, 8, 8);
            }
        }
    }

    private static boolean parentHandlingSelection(@NotNull NlComponent component) {
        ViewGroupHandler viewGroupHandler;
        NlComponent parent = component.getParent();
        if (parent == null) {
            return false;
        }
        ViewInfo view = parent.viewInfo;
        if (view == null) {
            return false;
        }
        ViewHandler handler = parent.getViewHandler();
        return handler != null && handler instanceof ViewGroupHandler && (viewGroupHandler = (ViewGroupHandler)handler).handlesPainting();
    }
}

