/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenViewLayer
extends Layer {
    private final ScreenView myScreenView;
    @Nullable
    private BufferedImage myImage;
    @Nullable
    private BufferedImage myScaledImage;
    @Nullable
    private RenderResult myLastRenderResult;
    private double myCachedScale;
    private Rectangle mySizeRectangle = new Rectangle();
    private Dimension myScreenViewSize = new Dimension();

    public ScreenViewLayer(@NotNull ScreenView screenView) {
        this.myScreenView = screenView;
    }

    @Nullable
    private static BufferedImage getRetinaScaledImage(@NotNull BufferedImage original, double scale, boolean fastScaling) {
        if (scale > 1.01) {
            return null;
        }
        if (Math.abs(scale - 0.5) > 0.01) {
            double retinaScale = 2.0 * scale;
            original = fastScaling ? ImageUtils.lowQualityFastScale(original, retinaScale, retinaScale) : ImageUtils.scale(original, retinaScale, retinaScale);
        }
        return ImageUtils.convertToRetina(original);
    }

    private void setNewImage(@NotNull BufferedImage newImage, double newScale) {
        this.myCachedScale = newScale;
        this.myImage = newImage;
        this.myScaledImage = null;
        boolean fastScaling = this.myScreenView.getSurface().isCanvasResizing();
        if (UIUtil.isRetina() && ImageUtils.supportsRetina()) {
            this.myScaledImage = ScreenViewLayer.getRetinaScaledImage(newImage, newScale, fastScaling);
        }
        if (this.myScaledImage == null) {
            this.myScaledImage = fastScaling ? ImageUtils.lowQualityFastScale(newImage, newScale, newScale) : ImageUtils.scale(newImage, newScale, newScale);
        }
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        this.myScreenViewSize = this.myScreenView.getSize(this.myScreenViewSize);
        this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle2D.intersect(this.mySizeRectangle, g.getClipBounds(), this.mySizeRectangle);
        if (this.mySizeRectangle.isEmpty()) {
            return;
        }
        RenderResult renderResult = this.myScreenView.getModel().getRenderResult();
        if (renderResult != null && renderResult.getImage() != null && renderResult != this.myLastRenderResult) {
            this.myLastRenderResult = renderResult;
            this.myImage = renderResult.getImage().getOriginalImage();
            this.myScaledImage = null;
        }
        if (this.myImage == null) {
            return;
        }
        double scale = this.myScreenView.getScale();
        if (this.myScaledImage == null || this.myCachedScale != scale) {
            this.setNewImage(this.myImage, scale);
        }
        Shape prevClip = null;
        Shape screenShape = this.myScreenView.getScreenShape();
        if (screenShape != null) {
            prevClip = g.getClip();
            g.clip(screenShape);
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myScaledImage, (int)this.myScreenView.getX(), (int)this.myScreenView.getY(), null);
        if (prevClip != null) {
            g.setClip(prevClip);
        }
    }
}

