/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionListener;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenView {
    private final DesignSurface mySurface;
    private ScreenViewType myType;
    private final NlModel myModel;
    private int x;
    private int y;

    public ScreenView(@NotNull DesignSurface surface, @NotNull ScreenViewType type, @NotNull NlModel model) {
        this.mySurface = surface;
        this.myType = type;
        this.myModel = model;
        this.myModel.getSelectionModel().addListener(new SelectionListener(){

            @Override
            public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScreenView.this.mySurface.repaint();
                    }
                });
            }
        });
    }

    @Nullable
    public RenderResult getResult() {
        return this.myModel.getRenderResult();
    }

    @NotNull
    public ScreenViewType getScreenViewType() {
        return this.myType;
    }

    public void setType(ScreenViewType type) {
        this.myType = type;
    }

    @NotNull
    public Dimension getSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        Dimension preferred = this.getPreferredSize(dimension);
        double scale = this.mySurface.getScale();
        dimension.setSize((int)(scale * (double)preferred.width), (int)(scale * (double)preferred.height));
        return dimension;
    }

    @NotNull
    public Dimension getSize() {
        return this.getSize(null);
    }

    @NotNull
    public Dimension getPreferredSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        Configuration configuration = this.getConfiguration();
        Device device = configuration.getDevice();
        State state = configuration.getDeviceState();
        if (device != null && state != null) {
            HardwareConfig config = new HardwareConfigHelper(device).setOrientation(state.getOrientation()).getConfig();
            dimension.setSize(config.getScreenWidth(), config.getScreenHeight());
        }
        return dimension;
    }

    @NotNull
    public Dimension getPreferredSize() {
        return this.getPreferredSize(null);
    }

    public void switchDevice() {
        List<Device> devices = this.myModel.getFacet().getConfigurationManager().getDevices();
        ArrayList applicable = Lists.newArrayList();
        for (Device device : devices) {
            if (!HardwareConfigHelper.isNexus((Device)device)) continue;
            applicable.add(device);
        }
        Configuration configuration = this.getConfiguration();
        Device currentDevice = configuration.getDevice();
        int n = applicable.size();
        for (int i = 0; i < n; ++i) {
            if (applicable.get(i) != currentDevice) continue;
            Device newDevice = (Device)applicable.get((i + 1) % applicable.size());
            configuration.setDevice(newDevice, true);
            break;
        }
    }

    public void toggleOrientation() {
        Configuration configuration = this.getConfiguration();
        configuration.getDeviceState();
        State current = configuration.getDeviceState();
        State flip = configuration.getNextDeviceState(current);
        if (flip != null) {
            configuration.setDeviceState(flip);
        }
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.myModel.getConfiguration();
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        this.myModel.setConfiguration(configuration);
    }

    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.myModel.getSelectionModel();
    }

    @Nullable
    public Shape getScreenShape() {
        Device device = this.getConfiguration().getDevice();
        if (device == null) {
            return null;
        }
        Screen screen = device.getDefaultHardware().getScreen();
        if (screen.getScreenRound() != ScreenRound.ROUND) {
            return null;
        }
        Dimension size = this.getSize();
        int chin = screen.getChin();
        if (chin == 0) {
            return new Ellipse2D.Double(this.x, this.y, size.width, size.height);
        }
        int height = size.height * chin / screen.getYDimension();
        Area a1 = new Area(new Ellipse2D.Double(this.x, this.y, size.width, size.height + height));
        Area a2 = new Area(new Rectangle2D.Double(this.x, this.y + 2 * (size.height + height) - height, size.width, height));
        a1.subtract(a2);
        return a1;
    }

    public DesignSurface getSurface() {
        return this.mySurface;
    }

    public double getScale() {
        return this.mySurface.getScale();
    }

    public void setLocation(int screenX, int screenY) {
        this.x = screenX;
        this.y = screenY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static enum ScreenViewType {
        NORMAL,
        BLUEPRINT;

    }
}

